/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session.fine;

import java.io.IOException;
import java.io.NotSerializableException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.wildfly.clustering.ee.Immutability;
import org.wildfly.clustering.ee.MutatorFactory;
import org.wildfly.clustering.ee.UUIDFactory;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.web.cache.session.SessionAttributeActivationNotifier;
import org.wildfly.clustering.web.cache.session.SessionAttributes;
import org.wildfly.clustering.web.cache.session.fine.ConcurrentSessionAttributeMapPutFunction;
import org.wildfly.clustering.web.cache.session.fine.ConcurrentSessionAttributeMapRemoveFunction;
import org.wildfly.clustering.web.cache.session.fine.CopyOnWriteSessionAttributeMapPutFunction;
import org.wildfly.clustering.web.cache.session.fine.CopyOnWriteSessionAttributeMapRemoveFunction;

public class FineSessionAttributes<NK, K, V>
implements SessionAttributes {
    private final NK key;
    private final Map<NK, Map<String, UUID>> namesCache;
    private final Function<UUID, K> keyFactory;
    private final Map<K, V> attributeCache;
    private final Map<K, Optional<Object>> mutations = new HashMap<K, Optional<Object>>();
    private final Marshaller<Object, V> marshaller;
    private final MutatorFactory<K, V> mutatorFactory;
    private final Immutability immutability;
    private final CacheProperties properties;
    private final SessionAttributeActivationNotifier notifier;
    private final AtomicReference<Map<String, UUID>> names;

    public FineSessionAttributes(NK key, AtomicReference<Map<String, UUID>> names, Map<NK, Map<String, UUID>> namesCache, Function<UUID, K> keyFactory, Map<K, V> attributeCache, Marshaller<Object, V> marshaller, MutatorFactory<K, V> mutatorFactory, Immutability immutability, CacheProperties properties, SessionAttributeActivationNotifier notifier) {
        this.key = key;
        this.names = names;
        this.namesCache = namesCache;
        this.keyFactory = keyFactory;
        this.attributeCache = attributeCache;
        this.marshaller = marshaller;
        this.mutatorFactory = mutatorFactory;
        this.immutability = immutability;
        this.properties = properties;
        this.notifier = notifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeAttribute(String name) {
        UUID attributeId = this.names.get().get(name);
        if (attributeId == null) {
            return null;
        }
        Map<K, Optional<Object>> map = this.mutations;
        synchronized (map) {
            this.setNames(this.namesCache.compute(this.key, (BiFunction<NK, Map<String, UUID>, Map<String, UUID>>)(this.properties.isTransactional() ? new CopyOnWriteSessionAttributeMapRemoveFunction(name) : new ConcurrentSessionAttributeMapRemoveFunction(name))));
            K key = this.keyFactory.apply(attributeId);
            Object result = this.read(this.attributeCache.remove(key));
            if (result != null) {
                this.mutations.remove(key);
                if (this.properties.isPersistent()) {
                    this.notifier.postActivate(result);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setAttribute(String name, Object attribute) {
        if (attribute == null) {
            return this.removeAttribute(name);
        }
        if (this.properties.isMarshalling() && !this.marshaller.isMarshallable(attribute)) {
            throw new IllegalArgumentException(new NotSerializableException(attribute.getClass().getName()));
        }
        UUID attributeId = this.names.get().get(name);
        Map<K, Optional<Object>> map = this.mutations;
        synchronized (map) {
            if (attributeId == null) {
                UUID newAttributeId = (UUID)UUIDFactory.INSECURE.get();
                this.setNames(this.namesCache.compute(this.key, (BiFunction<NK, Map<String, UUID>, Map<String, UUID>>)(this.properties.isTransactional() ? new CopyOnWriteSessionAttributeMapPutFunction(name, newAttributeId) : new ConcurrentSessionAttributeMapPutFunction(name, newAttributeId))));
                attributeId = this.names.get().get(name);
            }
            K key = this.keyFactory.apply(attributeId);
            V value = this.write(attribute);
            if (this.properties.isPersistent()) {
                this.notifier.prePassivate(attribute);
            }
            Object result = this.read(this.attributeCache.put(key, value));
            if (this.properties.isTransactional()) {
                this.mutations.put(key, Optional.empty());
            } else if (this.immutability.test(attribute)) {
                this.mutations.remove(key);
            } else {
                this.mutations.put(key, Optional.of(attribute));
            }
            if (this.properties.isPersistent()) {
                this.notifier.postActivate(attribute);
                if (result != attribute) {
                    this.notifier.postActivate(result);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        UUID attributeId = this.names.get().get(name);
        if (attributeId == null) {
            return null;
        }
        Map<K, Optional<Object>> map = this.mutations;
        synchronized (map) {
            K key = this.keyFactory.apply(attributeId);
            Optional<Object> mutableValue = this.mutations.get(key);
            if (mutableValue != null && mutableValue.isPresent()) {
                return mutableValue.get();
            }
            Object result = this.read(this.attributeCache.get(key));
            if (result != null) {
                if (this.properties.isPersistent()) {
                    this.notifier.postActivate(result);
                }
                if (!this.immutability.test(result)) {
                    this.mutations.putIfAbsent(key, Optional.of(result));
                }
            }
            return result;
        }
    }

    public Set<String> getAttributeNames() {
        return this.names.get().keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Map<K, Optional<Object>> map = this.mutations;
        synchronized (map) {
            this.notifier.close();
            for (Map.Entry<K, Optional<Object>> entry : this.mutations.entrySet()) {
                Optional<Object> optional = entry.getValue();
                if (!optional.isPresent()) continue;
                K key = entry.getKey();
                V value = this.write(optional.get());
                this.mutatorFactory.createMutator(key, value).mutate();
            }
            this.mutations.clear();
        }
    }

    private void setNames(Map<String, UUID> names) {
        this.names.set(names != null ? Collections.unmodifiableMap(names) : Collections.emptyMap());
    }

    private V write(Object value) {
        try {
            return (V)this.marshaller.write(value);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private Object read(V value) {
        try {
            return this.marshaller.read(value);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

