/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.ChildResourceDefinition;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleResourceRegistrar;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.capability.UnaryCapabilityNameResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.dmr.ModelNode;
import org.jgroups.JChannel;
import org.wildfly.clustering.server.GroupMember;
import org.wildfly.clustering.singleton.election.SingletonElectionPolicy;
import org.wildfly.common.function.Functions;
import org.wildfly.extension.clustering.singleton.SingletonPolicyResourceDefinition;
import org.wildfly.extension.clustering.singleton.election.OutboundSocketBindingPreference;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.ResourceModelResolver;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public abstract class ElectionPolicyResourceDefinition
extends ChildResourceDefinition<ManagementResourceRegistration>
implements ResourceServiceConfigurator,
ResourceModelResolver<SingletonElectionPolicy> {
    static final PathElement WILDCARD_PATH = ElectionPolicyResourceDefinition.pathElement("*");
    private static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of((UnaryServiceDescriptor)SingletonElectionPolicy.SERVICE_DESCRIPTOR).setDynamicNameMapper((Function)UnaryCapabilityNameResolver.PARENT).build();
    private final UnaryOperator<ResourceDescriptor> configurator;

    static PathElement pathElement(String value) {
        return PathElement.pathElement((String)"election-policy", (String)value);
    }

    ElectionPolicyResourceDefinition(PathElement path, ResourceDescriptionResolver resolver, UnaryOperator<ResourceDescriptor> configurator) {
        super(path, resolver);
        this.configurator = configurator;
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = parent.registerSubModel((ResourceDefinition)this);
        ResourceDescriptor descriptor = ((ResourceDescriptor)this.configurator.apply(new ResourceDescriptor(this.getResourceDescriptionResolver()))).addAttributes(Attribute.class).addCapabilities(List.of(CAPABILITY));
        ResourceOperationRuntimeHandler handler = ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this);
        new SimpleResourceRegistrar(descriptor, ResourceServiceHandler.of((ResourceOperationRuntimeHandler[])new ResourceOperationRuntimeHandler[]{handler})).register(registration);
        return registration;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        List socketBindingPreferences = Attribute.SOCKET_BINDING_PREFERENCES.resolveModelAttribute((ExpressionResolver)context, model).asListOrEmpty();
        List namePreferences = Attribute.NAME_PREFERENCES.resolveModelAttribute((ExpressionResolver)context, model).asListOrEmpty();
        ArrayList<Predicate<GroupMember>> preferences = new ArrayList<Predicate<GroupMember>>(socketBindingPreferences.size() + namePreferences.size());
        ArrayList<ServiceDependency> dependencies = new ArrayList<ServiceDependency>(socketBindingPreferences.size());
        if (!socketBindingPreferences.isEmpty()) {
            Resource policy = context.readResourceFromRoot(context.getCurrentAddress().getParent(), false);
            String containerName = SingletonPolicyResourceDefinition.Attribute.CACHE_CONTAINER.resolveModelAttribute((ExpressionResolver)context, policy.getModel()).asString();
            UnaryServiceDescriptor containerTransportChannel = UnaryServiceDescriptor.of((String)"org.wildfly.clustering.infinispan.transport.channel", JChannel.class);
            if (context.hasOptionalCapability(containerTransportChannel, containerName, CAPABILITY, Attribute.SOCKET_BINDING_PREFERENCES.getDefinition())) {
                ServiceDependency channel = ServiceDependency.on((UnaryServiceDescriptor)containerTransportChannel, (String)containerName);
                for (ModelNode preference : socketBindingPreferences) {
                    ServiceDependency binding = ServiceDependency.on((UnaryServiceDescriptor)OutboundSocketBinding.SERVICE_DESCRIPTOR, (String)preference.toString());
                    dependencies.add(binding);
                    preferences.add(new OutboundSocketBindingPreference((Supplier<OutboundSocketBinding>)binding, (Supplier<JChannel>)channel));
                }
            }
        }
        for (ModelNode preference : namePreferences) {
            final String name = preference.asString();
            preferences.add(new Predicate<GroupMember>(){

                @Override
                public boolean test(GroupMember member) {
                    return member.getName().equals(name);
                }

                public String toString() {
                    return name;
                }
            });
        }
        SingletonElectionPolicy electionPolicy = (SingletonElectionPolicy)this.resolve(context, model);
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(CAPABILITY, (Supplier)Functions.constantSupplier((Object)electionPolicy.prefer(preferences))).requires(dependencies)).build();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<StringListAttributeDefinition.Builder>
    {
        NAME_PREFERENCES("name-preferences", "socket-binding-preferences"),
        SOCKET_BINDING_PREFERENCES("socket-binding-preferences", "name-preferences"){

            @Override
            public StringListAttributeDefinition.Builder apply(StringListAttributeDefinition.Builder builder) {
                return (StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)builder.setAllowExpression(false)).setCapabilityReference((CapabilityReferenceRecorder)org.wildfly.subsystem.resource.capability.CapabilityReferenceRecorder.builder(CAPABILITY, (UnaryServiceDescriptor)OutboundSocketBinding.SERVICE_DESCRIPTOR).build());
            }
        };

        private final AttributeDefinition definition;

        private Attribute(String name, String alternative) {
            this.definition = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)this.apply((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder(name).setAllowExpression(true)).setAlternatives(new String[]{alternative})).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public StringListAttributeDefinition.Builder apply(StringListAttributeDefinition.Builder builder) {
            return builder;
        }
    }
}

