/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.singleton.election;

import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.wildfly.clustering.server.GroupMember;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;

public interface SingletonElectionPolicy {
    public static final UnaryServiceDescriptor<SingletonElectionPolicy> SERVICE_DESCRIPTOR = UnaryServiceDescriptor.of((String)"org.wildfly.clustering.singleton-policy.election", SingletonElectionPolicy.class);

    public GroupMember elect(List<GroupMember> var1);

    default public SingletonElectionPolicy prefer(final List<Predicate<GroupMember>> preferences) {
        return !preferences.isEmpty() ? new SingletonElectionPolicy(){

            @Override
            public GroupMember elect(List<GroupMember> candidates) {
                for (Predicate preference : preferences) {
                    List<GroupMember> preferred = candidates.stream().filter(preference).collect(Collectors.toUnmodifiableList());
                    if (preferred.isEmpty()) continue;
                    return SingletonElectionPolicy.this.elect(preferred);
                }
                return SingletonElectionPolicy.this.elect(candidates);
            }
        } : this;
    }

    public static SingletonElectionPolicy random() {
        final Random random = new Random();
        return new SingletonElectionPolicy(){

            @Override
            public GroupMember elect(List<GroupMember> candidates) {
                int size = candidates.size();
                return size > 0 ? candidates.get(random.nextInt(size)) : null;
            }
        };
    }

    public static SingletonElectionPolicy oldest() {
        return SingletonElectionPolicy.position(0);
    }

    public static SingletonElectionPolicy youngest() {
        return SingletonElectionPolicy.position(-1);
    }

    public static SingletonElectionPolicy position(final int position) {
        return new SingletonElectionPolicy(){

            @Override
            public GroupMember elect(List<GroupMember> candidates) {
                int size = candidates.size();
                return size > 0 ? candidates.get((position % size + size) % size) : null;
            }
        };
    }
}

