/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.service;

import java.util.AbstractMap;
import java.util.Map;
import org.jboss.as.controller.ServiceNameFactory;
import org.jboss.msc.service.ServiceName;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.service.ServiceDependency;

public interface BinaryServiceConfiguration {
    default public Map.Entry<String, String> getName() {
        return new AbstractMap.SimpleImmutableEntry<String, String>(this.getParentName(), this.getChildName());
    }

    public String getParentName();

    public String getChildName();

    default public BinaryServiceConfiguration withChildName(String childName) {
        return BinaryServiceConfiguration.of(this.getParentName(), childName);
    }

    default public <T> ServiceDependency<T> getServiceDependency(BinaryServiceDescriptor<T> descriptor) {
        return ServiceDependency.on(descriptor, (String)this.getParentName(), (String)this.getChildName());
    }

    default public <T> ServiceDependency<T> getServiceDependency(UnaryServiceDescriptor<T> descriptor) {
        return ServiceDependency.on(descriptor, (String)this.getParentName());
    }

    default public ServiceName resolveServiceName(BinaryServiceDescriptor<?> descriptor) {
        return ServiceNameFactory.resolveServiceName(descriptor, (String)this.getParentName(), (String)this.getChildName());
    }

    default public ServiceName resolveServiceName(UnaryServiceDescriptor<?> descriptor) {
        return ServiceNameFactory.resolveServiceName(descriptor, (String)this.getParentName());
    }

    public static BinaryServiceConfiguration of(final String parentName, final String childName) {
        return new BinaryServiceConfiguration(){

            @Override
            public String getParentName() {
                return parentName;
            }

            @Override
            public String getChildName() {
                return childName;
            }
        };
    }
}

