/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.util;

import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.DecoratorExternalizer;
import org.wildfly.clustering.marshalling.spi.ExternalizerProvider;
import org.wildfly.clustering.marshalling.spi.ObjectExternalizer;
import org.wildfly.clustering.marshalling.spi.StringExternalizer;
import org.wildfly.clustering.marshalling.spi.SynchronizedDecoratorExternalizer;
import org.wildfly.clustering.marshalling.spi.ValueExternalizer;
import org.wildfly.clustering.marshalling.spi.util.BitSetExternalizer;
import org.wildfly.clustering.marshalling.spi.util.BoundedCollectionExternalizer;
import org.wildfly.clustering.marshalling.spi.util.CalendarExternalizer;
import org.wildfly.clustering.marshalling.spi.util.DateExternalizer;
import org.wildfly.clustering.marshalling.spi.util.EnumMapExternalizer;
import org.wildfly.clustering.marshalling.spi.util.EnumSetExternalizer;
import org.wildfly.clustering.marshalling.spi.util.HashMapExternalizer;
import org.wildfly.clustering.marshalling.spi.util.HashSetExternalizer;
import org.wildfly.clustering.marshalling.spi.util.LinkedHashMapExternalizer;
import org.wildfly.clustering.marshalling.spi.util.MapEntryExternalizer;
import org.wildfly.clustering.marshalling.spi.util.OptionalDoubleExternalizer;
import org.wildfly.clustering.marshalling.spi.util.OptionalIntExternalizer;
import org.wildfly.clustering.marshalling.spi.util.OptionalLongExternalizer;
import org.wildfly.clustering.marshalling.spi.util.SingletonCollectionExternalizer;
import org.wildfly.clustering.marshalling.spi.util.SingletonMapExternalizer;
import org.wildfly.clustering.marshalling.spi.util.SortedMapExternalizer;
import org.wildfly.clustering.marshalling.spi.util.SortedSetExternalizer;
import org.wildfly.clustering.marshalling.spi.util.UUIDExternalizer;
import org.wildfly.clustering.marshalling.spi.util.UnboundedCollectionExternalizer;
import org.wildfly.clustering.marshalling.spi.util.UnmodifiableCollectionExternalizer;
import org.wildfly.clustering.marshalling.spi.util.UnmodifiableMapExternalizer;

public enum UtilExternalizerProvider implements ExternalizerProvider
{
    ARRAY_DEQUE(new BoundedCollectionExternalizer<ArrayDeque>(ArrayDeque.class, ArrayDeque::new)),
    ARRAY_LIST(new BoundedCollectionExternalizer<ArrayList>(ArrayList.class, ArrayList::new)),
    BIT_SET(new BitSetExternalizer()),
    CALENDAR(new CalendarExternalizer()),
    CURRENCY(new StringExternalizer<Currency>(Currency.class, Currency::getInstance, Currency::getCurrencyCode)),
    DATE(new DateExternalizer<Date>(Date.class, Date::new)),
    EMPTY_LIST(new ValueExternalizer<List<T>>(Collections.emptyList())),
    EMPTY_MAP(new ValueExternalizer<Map<K, V>>(Collections.emptyMap())),
    EMPTY_NAVIGABLE_MAP(new ValueExternalizer<NavigableMap<K, V>>(Collections.emptyNavigableMap())),
    EMPTY_NAVIGABLE_SET(new ValueExternalizer<NavigableSet<E>>(Collections.emptyNavigableSet())),
    EMPTY_SET(new ValueExternalizer<Set<T>>(Collections.emptySet())),
    EMPTY_SORTED_MAP(new ValueExternalizer<SortedMap<K, V>>(Collections.emptySortedMap())),
    EMPTY_SORTED_SET(new ValueExternalizer<SortedSet<E>>(Collections.emptySortedSet())),
    ENUM_MAP(new EnumMapExternalizer<E>()),
    ENUM_SET(new EnumSetExternalizer<E>()),
    HASH_MAP(new HashMapExternalizer<HashMap>(HashMap.class, HashMap::new)),
    HASH_SET(new HashSetExternalizer<HashSet>(HashSet.class, HashSet::new)),
    LINKED_HASH_MAP(new LinkedHashMapExternalizer()),
    LINKED_HASH_SET(new HashSetExternalizer<LinkedHashSet>(LinkedHashSet.class, LinkedHashSet::new)),
    LINKED_LIST(new UnboundedCollectionExternalizer<LinkedList>(LinkedList.class, LinkedList::new)),
    LIST12(new UnmodifiableCollectionExternalizer<List>(List.of(Boolean.TRUE).getClass().asSubclass(List.class), List::of)),
    LISTN(new UnmodifiableCollectionExternalizer<List>(List.of().getClass().asSubclass(List.class), List::of)),
    LOCALE(new StringExternalizer<Locale>(Locale.class, Locale::forLanguageTag, Locale::toLanguageTag)),
    MAP1(new UnmodifiableMapExternalizer<Map>(Map.of(Boolean.TRUE, Boolean.FALSE).getClass().asSubclass(Map.class), Map::ofEntries)),
    MAPN(new UnmodifiableMapExternalizer<Map>(Map.of().getClass().asSubclass(Map.class), Map::ofEntries)),
    NATURAL_ORDER_COMPARATOR(new ValueExternalizer<Comparator<T>>(Comparator.naturalOrder())),
    OPTIONAL(new ObjectExternalizer<Optional>(Optional.class, Optional::ofNullable, optional -> optional.orElse(null)){

        public OptionalInt size(Optional optional) {
            return optional.isPresent() ? OptionalInt.empty() : OptionalInt.of(1);
        }
    }),
    OPTIONAL_DOUBLE(new OptionalDoubleExternalizer()),
    OPTIONAL_INT(new OptionalIntExternalizer()),
    OPTIONAL_LONG(new OptionalLongExternalizer()),
    REVERSE_ORDER_COMPARATOR(new ValueExternalizer<Comparator<T>>(Collections.reverseOrder())),
    SET12(new UnmodifiableCollectionExternalizer<Set>(Set.of(Boolean.TRUE).getClass().asSubclass(Set.class), Set::of)),
    SETN(new UnmodifiableCollectionExternalizer<Set>(Set.of().getClass().asSubclass(Set.class), Set::of)),
    SIMPLE_ENTRY(new MapEntryExternalizer<AbstractMap.SimpleEntry>(AbstractMap.SimpleEntry.class, AbstractMap.SimpleEntry::new)),
    SIMPLE_IMMUTABLE_ENTRY(new MapEntryExternalizer<AbstractMap.SimpleImmutableEntry>(AbstractMap.SimpleImmutableEntry.class, AbstractMap.SimpleImmutableEntry::new)),
    SINGLETON_LIST(new SingletonCollectionExternalizer<List>(Collections::singletonList)),
    SINGLETON_MAP(new SingletonMapExternalizer()),
    SINGLETON_SET(new SingletonCollectionExternalizer<Set>(Collections::singleton)),
    SYNCHRONIZED_COLLECTION(new SynchronizedDecoratorExternalizer<List<T>>(Collection.class, Collections::synchronizedCollection, Collections.emptyList())),
    SYNCHRONIZED_LIST(new SynchronizedDecoratorExternalizer<LinkedList<E>>(List.class, Collections::synchronizedList, new LinkedList<E>())),
    SYNCHRONIZED_MAP(new SynchronizedDecoratorExternalizer<Map<K, V>>(Map.class, Collections::synchronizedMap, Collections.emptyMap())),
    SYNCHRONIZED_NAVIGABLE_MAP(new SynchronizedDecoratorExternalizer<NavigableMap<K, V>>(NavigableMap.class, Collections::synchronizedNavigableMap, Collections.emptyNavigableMap())),
    SYNCHRONIZED_NAVIGABLE_SET(new SynchronizedDecoratorExternalizer<NavigableSet<E>>(NavigableSet.class, Collections::synchronizedNavigableSet, Collections.emptyNavigableSet())),
    SYNCHRONIZED_RANDOM_ACCESS_LIST(new SynchronizedDecoratorExternalizer<List<T>>(List.class, Collections::synchronizedList, Collections.emptyList())),
    SYNCHRONIZED_SET(new SynchronizedDecoratorExternalizer<Set<T>>(Set.class, Collections::synchronizedSet, Collections.emptySet())),
    SYNCHRONIZED_SORTED_MAP(new SynchronizedDecoratorExternalizer<SortedMap<K, V>>(SortedMap.class, Collections::synchronizedSortedMap, Collections.emptySortedMap())),
    SYNCHRONIZED_SORTED_SET(new SynchronizedDecoratorExternalizer<SortedSet<E>>(SortedSet.class, Collections::synchronizedSortedSet, Collections.emptySortedSet())),
    TIME_ZONE(new StringExternalizer<TimeZone>(TimeZone.class, TimeZone::getTimeZone, TimeZone::getID)),
    TREE_MAP(new SortedMapExternalizer<TreeMap>(TreeMap.class, TreeMap::new)),
    TREE_SET(new SortedSetExternalizer<TreeSet>(TreeSet.class, TreeSet::new)),
    UNMODIFIABLE_COLLECTION(new DecoratorExternalizer<List<T>>(Collection.class, Collections::unmodifiableCollection, Collections.emptyList())),
    UNMODIFIABLE_LIST(new DecoratorExternalizer<LinkedList<E>>(List.class, Collections::unmodifiableList, new LinkedList<E>())),
    UNMODIFIABLE_MAP(new DecoratorExternalizer<Map<K, V>>(Map.class, Collections::unmodifiableMap, Collections.emptyMap())),
    UNMODIFIABLE_NAVIGABLE_MAP(new DecoratorExternalizer<NavigableMap<K, V>>(NavigableMap.class, Collections::unmodifiableNavigableMap, Collections.emptyNavigableMap())),
    UNMODIFIABLE_NAVIGABLE_SET(new DecoratorExternalizer<NavigableSet<E>>(NavigableSet.class, Collections::unmodifiableNavigableSet, Collections.emptyNavigableSet())),
    UNMODIFIABLE_RANDOM_ACCESS_LIST(new DecoratorExternalizer<List<T>>(List.class, Collections::unmodifiableList, Collections.emptyList())),
    UNMODIFIABLE_SET(new DecoratorExternalizer<Set<T>>(Set.class, Collections::unmodifiableSet, Collections.emptySet())),
    UNMODIFIABLE_SORTED_MAP(new DecoratorExternalizer<SortedMap<K, V>>(SortedMap.class, Collections::unmodifiableSortedMap, Collections.emptySortedMap())),
    UNMODIFIABLE_SORTED_SET(new DecoratorExternalizer<SortedSet<E>>(SortedSet.class, Collections::unmodifiableSortedSet, Collections.emptySortedSet())),
    UUID(new UUIDExternalizer());

    private final Externalizer<?> externalizer;

    private UtilExternalizerProvider(Externalizer<?> externalizer) {
        this.externalizer = externalizer;
    }

    @Override
    public Externalizer<?> getExternalizer() {
        return this.externalizer;
    }
}

