/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.LongFunction;
import java.util.function.ToLongFunction;
import org.wildfly.clustering.marshalling.Externalizer;

public class LongExternalizer<T>
implements Externalizer<T> {
    private final LongFunction<T> reader;
    private final ToLongFunction<T> writer;
    private final Class<T> targetClass;

    public LongExternalizer(Class<T> targetClass, LongFunction<T> reader, ToLongFunction<T> writer) {
        this.reader = reader;
        this.writer = writer;
        this.targetClass = targetClass;
    }

    public void writeObject(ObjectOutput output, T object) throws IOException {
        output.writeLong(this.writer.applyAsLong(object));
    }

    public T readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        return this.reader.apply(input.readLong());
    }

    public Class<T> getTargetClass() {
        return this.targetClass;
    }
}

