/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.wildfly.clustering.marshalling.spi.IntSerializer;

public enum IndexSerializer implements IntSerializer
{
    UNSIGNED_BYTE{

        @Override
        public int readInt(DataInput input) throws IOException {
            return input.readUnsignedByte();
        }

        @Override
        public void writeInt(DataOutput output, int index) throws IOException {
            if (index > 255) {
                throw new IndexOutOfBoundsException(Integer.toString(index));
            }
            output.writeByte(index);
        }
    }
    ,
    UNSIGNED_SHORT{

        @Override
        public int readInt(DataInput input) throws IOException {
            return input.readUnsignedShort();
        }

        @Override
        public void writeInt(DataOutput output, int index) throws IOException {
            if (index > 65535) {
                throw new IndexOutOfBoundsException(Integer.toString(index));
            }
            output.writeShort(index);
        }
    }
    ,
    INTEGER,
    VARIABLE{

        @Override
        public int readInt(DataInput input) throws IOException {
            byte b = input.readByte();
            int i = b & 0x7F;
            int shift = 7;
            while ((b & 0x80) != 0) {
                b = input.readByte();
                i = (int)((long)i | ((long)b & 0x7FL) << shift);
                shift += 7;
            }
            return i;
        }

        @Override
        public void writeInt(DataOutput output, int index) throws IOException {
            int i = index;
            while ((i & 0xFFFFFF80) != 0) {
                output.writeByte((byte)(i & 0x7F | 0x80));
                i >>>= 7;
            }
            output.writeByte((byte)i);
        }
    };


    public static final IntSerializer select(int size) {
        if (size < 256) {
            return UNSIGNED_BYTE;
        }
        if (size < 65536) {
            return UNSIGNED_SHORT;
        }
        if (size < 0x10000000) {
            return VARIABLE;
        }
        return INTEGER;
    }
}

