/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.jgroups.subsystem.AuthTokenResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ChannelResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.CipherAuthTokenResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.DigestAuthTokenResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.EncryptProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ForkResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.PlainAuthTokenResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolRegistration;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RelayResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RemoteSiteResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.PathElement;

public enum XMLElement {
    UNKNOWN(""),
    AUTH_PROTOCOL("auth-protocol"),
    CIPHER_TOKEN("cipher-token"),
    CHANNEL(ChannelResourceDefinition.WILDCARD_PATH),
    CHANNELS("channels"),
    DEFAULT_THREAD_POOL("default-thread-pool"),
    DIGEST_TOKEN("digest-token"),
    ENCRYPT_PROTOCOL("encrypt-protocol"),
    FORK(ForkResourceDefinition.WILDCARD_PATH),
    INTERNAL_THREAD_POOL("internal-thread-pool"),
    JDBC_PROTOCOL("jdbc-protocol"),
    KEY_CREDENTIAL_REFERENCE(EncryptProtocolResourceDefinition.Attribute.KEY_CREDENTIAL),
    OOB_THREAD_POOL("oob-thread-pool"),
    PLAIN_TOKEN("plain-token"),
    PROPERTY("property"),
    PROTOCOL(ProtocolResourceDefinition.WILDCARD_PATH),
    RELAY(RelayResourceDefinition.WILDCARD_PATH),
    REMOTE_SITE(RemoteSiteResourceDefinition.WILDCARD_PATH),
    SHARED_SECRET_CREDENTIAL_REFERENCE(AuthTokenResourceDefinition.Attribute.SHARED_SECRET),
    SOCKET_PROTOCOL("socket-protocol"),
    SOCKET_DISCOVERY_PROTOCOL("socket-discovery-protocol"),
    STACK(StackResourceDefinition.WILDCARD_PATH),
    STACKS("stacks"),
    TIMER_THREAD_POOL("timer-thread-pool"),
    TRANSPORT(TransportResourceDefinition.WILDCARD_PATH);

    private final String name;
    private static final Map<String, XMLElement> elements;
    private static final Map<String, XMLElement> protocols;
    private static final Map<String, XMLElement> tokens;

    private XMLElement(PathElement path) {
        this.name = path.isWildcard() ? path.getKey() : path.getValue();
    }

    private XMLElement(Attribute attribute) {
        this.name = attribute.getName();
    }

    private XMLElement(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static XMLElement forName(String localName) {
        XMLElement element = elements.get(localName);
        return element != null ? element : UNKNOWN;
    }

    public static XMLElement forProtocolName(String protocol) {
        XMLElement element = protocols.get(protocol);
        return element != null ? element : PROTOCOL;
    }

    public static XMLElement forAuthTokenName(String token) {
        XMLElement element = tokens.get(token);
        if (element == null) {
            throw new IllegalArgumentException(token);
        }
        return element;
    }

    static {
        elements = new HashMap<String, XMLElement>();
        protocols = new HashMap<String, XMLElement>();
        tokens = new HashMap<String, XMLElement>();
        for (XMLElement element : XMLElement.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            elements.put(name, element);
        }
        ProtocolRegistration.ProtocolType.MULTICAST_SOCKET.forEach(protocol -> protocols.put((String)protocol, SOCKET_PROTOCOL));
        ProtocolRegistration.ProtocolType.JDBC.forEach(protocol -> protocols.put((String)protocol, JDBC_PROTOCOL));
        ProtocolRegistration.ProtocolType.ENCRYPT.forEach(protocol -> protocols.put((String)protocol, ENCRYPT_PROTOCOL));
        ProtocolRegistration.ProtocolType.SOCKET_DISCOVERY.forEach(protocol -> protocols.put((String)protocol, SOCKET_DISCOVERY_PROTOCOL));
        ProtocolRegistration.ProtocolType.AUTH.forEach(protocol -> protocols.put((String)protocol, AUTH_PROTOCOL));
        tokens.put(PlainAuthTokenResourceDefinition.PATH.getValue(), PLAIN_TOKEN);
        tokens.put(DigestAuthTokenResourceDefinition.PATH.getValue(), DIGEST_TOKEN);
        tokens.put(CipherAuthTokenResourceDefinition.PATH.getValue(), CIPHER_TOKEN);
    }
}

