/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.io.File;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.management.MBeanServer;
import org.infinispan.Cache;
import org.infinispan.commands.module.ModuleCommandExtensions;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.AggregatedClassLoader;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.ShutdownHookBehavior;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.configuration.global.UncleanShutdownAction;
import org.infinispan.configuration.internal.PrivateGlobalConfigurationBuilder;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.jboss.as.clustering.controller.EnumAttributeDefinition;
import org.jboss.as.clustering.controller.MBeanServerResolver;
import org.jboss.as.clustering.controller.ModuleListAttributeDefinition;
import org.jboss.as.clustering.controller.StatisticsEnabledAttributeDefinition;
import org.jboss.as.clustering.infinispan.jmx.MBeanServerProvider;
import org.jboss.as.clustering.infinispan.logging.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerMetric;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerMetricExecutor;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerServiceConfigurator;
import org.jboss.as.clustering.infinispan.subsystem.CacheRuntimeResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanCacheBindingFactory;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanMarshallerFactory;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.InvalidationCacheResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.JGroupsTransportResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.LazyCacheServiceInstaller;
import org.jboss.as.clustering.infinispan.subsystem.LocalCacheResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.NoTransportResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.ReplicatedCacheResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.ScatteredCacheResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.ScheduledThreadPool;
import org.jboss.as.clustering.infinispan.subsystem.ScheduledThreadPoolResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPool;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.TransportResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.TransportResourceRegistration;
import org.jboss.as.clustering.naming.BinderServiceInstaller;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.ServiceNameFactory;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.cache.infinispan.embedded.lifecycle.WildFlyClusteringModuleLifecycle;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.clustering.server.service.ClusteringServiceDescriptor;
import org.wildfly.clustering.server.service.DefaultCacheServiceInstallerProvider;
import org.wildfly.clustering.server.service.LegacyClusteringServiceDescriptor;
import org.wildfly.clustering.server.service.ProvidedBinaryServiceInstallerProvider;
import org.wildfly.clustering.singleton.SingletonServiceBuilderFactory;
import org.wildfly.clustering.singleton.service.SingletonServiceConfiguratorFactory;
import org.wildfly.clustering.singleton.service.SingletonServiceTargetFactory;
import org.wildfly.service.Installer;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.ChildResourceDefinitionRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.capability.CapabilityReference;
import org.wildfly.subsystem.resource.capability.CapabilityReferenceAttributeDefinition;
import org.wildfly.subsystem.resource.executor.MetricExecutor;
import org.wildfly.subsystem.resource.executor.MetricOperationStepHandler;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;
import org.wildfly.subsystem.service.capture.FunctionExecutorRegistry;
import org.wildfly.subsystem.service.capture.ServiceValueExecutorRegistry;
import org.wildfly.subsystem.service.capture.ServiceValueRegistry;

public class CacheContainerResourceDefinitionRegistrar
implements ChildResourceDefinitionRegistrar,
ResourceServiceConfigurator,
BiPredicate<OperationContext, Resource> {
    static final ResourceRegistration REGISTRATION = ResourceRegistration.of((PathElement)PathElement.pathElement((String)"cache-container"));
    private static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of((UnaryServiceDescriptor)InfinispanServiceDescriptor.CACHE_CONTAINER_CONFIGURATION).build();
    static final CapabilityReferenceAttributeDefinition<Configuration> DEFAULT_CACHE = ((CapabilityReferenceAttributeDefinition.Builder)new CapabilityReferenceAttributeDefinition.Builder("default-cache", CapabilityReference.builder(CAPABILITY, (BinaryServiceDescriptor)InfinispanServiceDescriptor.CACHE_CONFIGURATION).withParentPath(REGISTRATION.getPathElement()).build()).setRequired(false)).build();
    static final StatisticsEnabledAttributeDefinition STATISTICS_ENABLED = new StatisticsEnabledAttributeDefinition.Builder().build();
    static final EnumAttributeDefinition<InfinispanMarshallerFactory> MARSHALLER = new EnumAttributeDefinition.Builder("marshaller", (Enum)InfinispanMarshallerFactory.LEGACY).setValidator(new ParameterValidator(){

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            if (!value.isDefined() || value.asString().equals(InfinispanMarshallerFactory.LEGACY.name())) {
                InfinispanLogger.ROOT_LOGGER.marshallerEnumValueDeprecated(parameterName, InfinispanMarshallerFactory.LEGACY, EnumSet.complementOf(EnumSet.of(InfinispanMarshallerFactory.LEGACY)));
            }
        }
    }).build();
    static final StringListAttributeDefinition ALIASES = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("aliases").setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final ModuleListAttributeDefinition MODULES = ((ModuleListAttributeDefinition.Builder)new ModuleListAttributeDefinition.Builder().setRequired(false)).setDefaultValue(Module.forClass(WildFlyClusteringModuleLifecycle.class)).build();

    public ManagementResourceRegistration register(ManagementResourceRegistration parent, ManagementResourceRegistrationContext context) {
        RuntimeCapability defaultRegistryFactory = RuntimeCapability.Builder.of((UnaryServiceDescriptor)ClusteringServiceDescriptor.DEFAULT_REGISTRY_FACTORY).build();
        RuntimeCapability defaultLegacyRegistryFactory = RuntimeCapability.Builder.of((UnaryServiceDescriptor)LegacyClusteringServiceDescriptor.DEFAULT_REGISTRY_FACTORY).build();
        RuntimeCapability defaultServiceProviderRegistrar = RuntimeCapability.Builder.of((UnaryServiceDescriptor)ClusteringServiceDescriptor.DEFAULT_SERVICE_PROVIDER_REGISTRAR).build();
        RuntimeCapability defaultLegacyServiceProviderRegistry = RuntimeCapability.Builder.of((UnaryServiceDescriptor)LegacyClusteringServiceDescriptor.DEFAULT_SERVICE_PROVIDER_REGISTRY).build();
        RuntimeCapability defaultSingletonServiceTargetFactory = RuntimeCapability.Builder.of((UnaryServiceDescriptor)SingletonServiceTargetFactory.DEFAULT_SERVICE_DESCRIPTOR).build();
        RuntimeCapability defaultSingletonServiceConfiguratorFactory = RuntimeCapability.Builder.of((UnaryServiceDescriptor)SingletonServiceConfiguratorFactory.DEFAULT_SERVICE_DESCRIPTOR).build();
        RuntimeCapability defaultSingletonServiceBuilderFactory = RuntimeCapability.Builder.of((UnaryServiceDescriptor)SingletonServiceBuilderFactory.DEFAULT_SERVICE_DESCRIPTOR).build();
        ServiceValueExecutorRegistry containerExecutors = ServiceValueExecutorRegistry.newInstance();
        ServiceValueExecutorRegistry cacheExecutors = ServiceValueExecutorRegistry.newInstance();
        ParentResourceDescriptionResolver resolver = InfinispanSubsystemResourceDefinitionRegistrar.RESOLVER.createChildResolver(REGISTRATION.getPathElement());
        ResourceDescriptor descriptor = ((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)ResourceDescriptor.builder((ResourceDescriptionResolver)resolver).addAttributes(List.of(DEFAULT_CACHE, STATISTICS_ENABLED, MARSHALLER, ALIASES, MODULES))).addCapabilities(List.of(CAPABILITY, CacheContainerServiceConfigurator.CAPABILITY))).provideCapabilities(EnumSet.allOf(DefaultCacheCapability.class), (BiPredicate)this)).addCapabilities(List.of(defaultRegistryFactory, defaultLegacyRegistryFactory, defaultServiceProviderRegistrar, defaultLegacyServiceProviderRegistry, defaultSingletonServiceTargetFactory, defaultSingletonServiceConfiguratorFactory, defaultSingletonServiceBuilderFactory), (BiPredicate)this)).requireChildResources(EnumSet.allOf(ThreadPool.class))).requireChildResources(EnumSet.allOf(ScheduledThreadPool.class))).requireSingletonChildResource((ResourceRegistration)TransportResourceRegistration.NONE)).withResourceTransformation(CacheContainerResource::new)).withRuntimeHandler(ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)ResourceServiceConfigurator.combine((ResourceServiceConfigurator[])new ResourceServiceConfigurator[]{this, new CacheContainerServiceConfigurator((ServiceValueRegistry<EmbeddedCacheManager>)containerExecutors, (ServiceValueRegistry<Cache<?, ?>>)cacheExecutors)})))).build();
        ManagementResourceRegistration registration = parent.registerSubModel(ResourceDefinition.builder((ResourceRegistration)REGISTRATION, (ResourceDescriptionResolver)resolver).build());
        ManagementResourceRegistrar.of((ResourceDescriptor)descriptor).register(registration);
        if (context.isRuntimeOnlyRegistrationValid()) {
            new MetricOperationStepHandler((MetricExecutor)new CacheContainerMetricExecutor((FunctionExecutorRegistry<EmbeddedCacheManager>)containerExecutors), CacheContainerMetric.class).register(registration);
            new CacheRuntimeResourceDefinitionRegistrar((FunctionExecutorRegistry<Cache<?, ?>>)cacheExecutors).register(registration, context);
        }
        new NoTransportResourceDefinitionRegistrar().register(registration, context);
        new JGroupsTransportResourceDefinitionRegistrar().register(registration, context);
        for (ThreadPool threadPool : EnumSet.allOf(ThreadPool.class)) {
            new ThreadPoolResourceDefinitionRegistrar(threadPool).register(registration, context);
        }
        for (ScheduledThreadPool scheduledThreadPool : EnumSet.allOf(ScheduledThreadPool.class)) {
            new ScheduledThreadPoolResourceDefinitionRegistrar(scheduledThreadPool).register(registration, context);
        }
        new LocalCacheResourceDefinitionRegistrar().register(registration, context);
        new InvalidationCacheResourceDefinitionRegistrar().register(registration, context);
        new ReplicatedCacheResourceDefinitionRegistrar((FunctionExecutorRegistry<Cache<?, ?>>)cacheExecutors).register(registration, context);
        new DistributedCacheResourceDefinitionRegistrar((FunctionExecutorRegistry<Cache<?, ?>>)cacheExecutors).register(registration, context);
        new ScatteredCacheResourceDefinitionRegistrar((FunctionExecutorRegistry<Cache<?, ?>>)cacheExecutors).register(registration, context);
        return registration;
    }

    @Override
    public boolean test(OperationContext context, Resource resource) {
        return resource.getModel().hasDefined(DEFAULT_CACHE.getName());
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final String name = context.getCurrentAddressValue();
        LinkedList<Object> installers = new LinkedList<Object>();
        List<String> aliases = ALIASES.resolveModelAttribute(context, model).asListOrEmpty().stream().map(ModelNode::asString).toList();
        final String defaultCacheName = DEFAULT_CACHE.resolveModelAttribute(context, model).asStringOrNull();
        final boolean statisticsEnabled = STATISTICS_ENABLED.resolve(context, model);
        final InfinispanMarshallerFactory marshallerFactory = (InfinispanMarshallerFactory)MARSHALLER.resolve(context, model);
        final ServiceDependency loader = ServiceDependency.on((ServiceName)Services.JBOSS_SERVICE_MODULE_LOADER);
        final ServiceDependency containerModules = MODULES.resolve(context, model);
        final ServiceDependency transport = ServiceDependency.on(TransportResourceDefinitionRegistrar.SERVICE_DESCRIPTOR, (String)name);
        final ServiceDependency environment = ServiceDependency.on((NullaryServiceDescriptor)ServerEnvironment.SERVICE_DESCRIPTOR);
        final ServiceDependency mbeanServer = new MBeanServerResolver(CAPABILITY).resolve(context, model);
        final EnumMap<ThreadPool, ServiceDependency> pools = new EnumMap<ThreadPool, ServiceDependency>(ThreadPool.class);
        final EnumMap<ScheduledThreadPool, ServiceDependency> scheduledPools = new EnumMap<ScheduledThreadPool, ServiceDependency>(ScheduledThreadPool.class);
        for (ThreadPool threadPool : EnumSet.allOf(ThreadPool.class)) {
            pools.put(threadPool, ServiceDependency.on(threadPool.getServiceDescriptor(), (String)name));
        }
        for (ScheduledThreadPool scheduledThreadPool : EnumSet.allOf(ScheduledThreadPool.class)) {
            scheduledPools.put(scheduledThreadPool, ServiceDependency.on(scheduledThreadPool.getServiceDescriptor(), (String)name));
        }
        Supplier<GlobalConfiguration> factory = new Supplier<GlobalConfiguration>(){

            @Override
            public GlobalConfiguration get() {
                GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder();
                builder.cacheManagerName(name).defaultCacheName(defaultCacheName).cacheContainer().statistics(statisticsEnabled);
                builder.transport().read((Object)((TransportConfiguration)transport.get()));
                List modules = (List)containerModules.get();
                Marshaller marshaller = (Marshaller)marshallerFactory.apply((ModuleLoader)loader.get(), modules);
                InfinispanLogger.ROOT_LOGGER.debugf("%s cache-container will use %s", name, marshaller.getClass().getName());
                builder.serialization().marshaller(marshaller).addContextInitializer(new SerializationContextInitializer(){

                    @Deprecated
                    public String getProtoFile() {
                        return null;
                    }

                    @Deprecated
                    public String getProtoFileName() {
                        return null;
                    }

                    public void registerMarshallers(SerializationContext context) {
                    }

                    public void registerSchema(SerializationContext context) {
                    }
                });
                AggregatedClassLoader loader2 = modules.size() > 1 ? new AggregatedClassLoader((Collection)modules.stream().map(Module::getClassLoader).collect(Collectors.toList())) : ((Module)modules.get(0)).getClassLoader();
                builder.classLoader((ClassLoader)loader2);
                builder.blockingThreadPool().read((Object)((ThreadPoolConfiguration)((ServiceDependency)pools.get(ThreadPool.BLOCKING)).get()));
                builder.listenerThreadPool().read((Object)((ThreadPoolConfiguration)((ServiceDependency)pools.get(ThreadPool.LISTENER)).get()));
                builder.nonBlockingThreadPool().read((Object)((ThreadPoolConfiguration)((ServiceDependency)pools.get(ThreadPool.NON_BLOCKING)).get()));
                builder.expirationThreadPool().read((Object)((ThreadPoolConfiguration)((ServiceDependency)scheduledPools.get(ScheduledThreadPool.EXPIRATION)).get()));
                builder.shutdown().hookBehavior(ShutdownHookBehavior.DONT_REGISTER);
                builder.metrics().gauges(false).histograms(false).accurateSize(true);
                MBeanServerLookup mbeanServerProvider = Optional.ofNullable((MBeanServer)mbeanServer.get()).map(MBeanServerProvider::new).orElse(null);
                builder.jmx().domain("org.wildfly.clustering.infinispan").mBeanServerLookup(mbeanServerProvider).enabled(mbeanServerProvider != null);
                ((PrivateGlobalConfigurationBuilder)builder.addModule(PrivateGlobalConfigurationBuilder.class)).serverMode(!ServiceLoader.load(ModuleCommandExtensions.class, (ClassLoader)loader2).iterator().hasNext());
                String path = InfinispanSubsystemResourceDefinitionRegistrar.REGISTRATION.getName() + File.separatorChar + name;
                builder.globalState().enable().configurationStorage(ConfigurationStorage.VOLATILE).persistentLocation(path, ((ServerEnvironment)environment.get()).getServerDataDir().getPath()).temporaryLocation(path, ((ServerEnvironment)environment.get()).getServerTempDir().getPath()).uncleanShutdownAction(UncleanShutdownAction.PURGE);
                return builder.build();
            }
        };
        CapabilityServiceInstaller.Builder builder = CapabilityServiceInstaller.builder(CAPABILITY, (Supplier)factory);
        for (String alias : aliases) {
            builder.provides(ServiceNameFactory.resolveServiceName((UnaryServiceDescriptor)InfinispanServiceDescriptor.CACHE_CONTAINER_CONFIGURATION, (String)alias));
        }
        installers.add((ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)builder.blocking()).requires(List.of(mbeanServer, loader, containerModules, transport, environment))).requires(pools.values())).requires(scheduledPools.values())).startWhen(Installer.StartWhen.AVAILABLE)).build());
        String defaultCache = DEFAULT_CACHE.resolveModelAttribute(context, model).asString(null);
        if (defaultCache != null) {
            BinaryServiceConfiguration configuration = BinaryServiceConfiguration.of((String)name, (String)defaultCache);
            installers.add((ResourceServiceInstaller)CapabilityServiceInstaller.builder(DefaultCacheCapability.CACHE_CONFIGURATION.get(), (ServiceDependency)configuration.getServiceDependency(InfinispanServiceDescriptor.CACHE_CONFIGURATION)).build());
            installers.add((ResourceServiceInstaller)CapabilityServiceInstaller.builder(DefaultCacheCapability.CACHE.get(), (ServiceDependency)configuration.getServiceDependency(InfinispanServiceDescriptor.CACHE)).build());
            if (!defaultCache.equals("default")) {
                BinaryServiceConfiguration defaultConfiguration = configuration.withChildName("default");
                installers.add(new BinderServiceInstaller(InfinispanCacheBindingFactory.CACHE.apply(defaultConfiguration), configuration.resolveServiceName(LazyCacheServiceInstaller.SERVICE_DESCRIPTOR)));
                installers.add(new BinderServiceInstaller(InfinispanCacheBindingFactory.CACHE_CONFIGURATION.apply(defaultConfiguration), configuration.resolveServiceName(InfinispanServiceDescriptor.CACHE_CONFIGURATION)));
            }
            new ProvidedBinaryServiceInstallerProvider(DefaultCacheServiceInstallerProvider.class, DefaultCacheServiceInstallerProvider.class.getClassLoader()).apply(configuration).forEach(installers::add);
        }
        return ResourceServiceInstaller.combine(installers);
    }

    static enum DefaultCacheCapability implements Supplier<RuntimeCapability<?>>
    {
        CACHE(InfinispanServiceDescriptor.DEFAULT_CACHE),
        CACHE_CONFIGURATION(InfinispanServiceDescriptor.DEFAULT_CACHE_CONFIGURATION);

        private final RuntimeCapability<Void> capability;

        private DefaultCacheCapability(UnaryServiceDescriptor<?> descriptor) {
            this.capability = RuntimeCapability.Builder.of(descriptor).build();
        }

        @Override
        public RuntimeCapability<Void> get() {
            return this.capability;
        }
    }
}

