/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem.remote;

import java.util.function.ToIntFunction;
import org.infinispan.client.hotrod.jmx.RemoteCacheManagerMXBean;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.subsystem.resource.executor.Metric;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum RemoteCacheContainerMetric implements Metric<RemoteCacheManagerMXBean>,
ToIntFunction<RemoteCacheManagerMXBean>
{
    ACTIVE_CONNECTIONS("active-connections"){

        @Override
        public int applyAsInt(RemoteCacheManagerMXBean manager) {
            return manager.getActiveConnectionCount();
        }
    }
    ,
    CONNECTIONS("connections"){

        @Override
        public int applyAsInt(RemoteCacheManagerMXBean manager) {
            return manager.getConnectionCount();
        }
    }
    ,
    IDLE_CONNECTIONS("idle-connections"){

        @Override
        public int applyAsInt(RemoteCacheManagerMXBean manager) {
            return manager.getIdleConnectionCount();
        }
    };

    private final AttributeDefinition definition;

    private RemoteCacheContainerMetric(String name) {
        this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, ModelType.INT).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.GAUGE_METRIC})).setStorageRuntime()).build();
    }

    public AttributeDefinition get() {
        return this.definition;
    }

    public ModelNode execute(RemoteCacheManagerMXBean manager) throws OperationFailedException {
        return new ModelNode(this.applyAsInt(manager));
    }
}

