/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.bean;

import io.github.resilience4j.retry.RetryConfig;
import java.time.Duration;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.TimeoutException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.Flag;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.ClusterAffinity;
import org.jboss.ejb.client.NodeAffinity;
import org.wildfly.clustering.cache.CacheProperties;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.infinispan.embedded.distribution.CacheStreamFilter;
import org.wildfly.clustering.cache.infinispan.embedded.listener.ListenerRegistration;
import org.wildfly.clustering.ejb.bean.Bean;
import org.wildfly.clustering.ejb.bean.BeanExpirationConfiguration;
import org.wildfly.clustering.ejb.bean.BeanInstance;
import org.wildfly.clustering.ejb.bean.BeanManager;
import org.wildfly.clustering.ejb.cache.bean.BeanFactory;
import org.wildfly.clustering.ejb.cache.bean.BeanMetaDataKey;
import org.wildfly.clustering.ejb.cache.bean.MutableBean;
import org.wildfly.clustering.ejb.cache.bean.OnCloseBean;
import org.wildfly.clustering.ejb.infinispan.bean.BeanExpirationScheduler;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanManagerConfiguration;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanMetaDataFilter;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;
import org.wildfly.clustering.server.expiration.ExpirationMetaData;
import org.wildfly.clustering.server.infinispan.CacheContainerGroup;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMember;
import org.wildfly.clustering.server.infinispan.affinity.UnaryGroupMemberAffinity;
import org.wildfly.clustering.server.infinispan.dispatcher.CacheContainerCommandDispatcherFactory;
import org.wildfly.clustering.server.infinispan.expiration.ScheduleWithExpirationMetaDataCommand;
import org.wildfly.clustering.server.infinispan.manager.AffinityIdentifierFactory;
import org.wildfly.clustering.server.infinispan.scheduler.CacheEntriesTask;
import org.wildfly.clustering.server.infinispan.scheduler.CacheEntryScheduler;
import org.wildfly.clustering.server.infinispan.scheduler.PrimaryOwnerScheduler;
import org.wildfly.clustering.server.infinispan.scheduler.PrimaryOwnerSchedulerConfiguration;
import org.wildfly.clustering.server.infinispan.scheduler.ScheduleCommand;
import org.wildfly.clustering.server.infinispan.scheduler.ScheduleWithTransientMetaDataCommand;
import org.wildfly.clustering.server.infinispan.scheduler.Scheduler;
import org.wildfly.clustering.server.infinispan.scheduler.SchedulerTopologyChangeListener;
import org.wildfly.clustering.server.manager.IdentifierFactory;

public class InfinispanBeanManager<K, V extends BeanInstance<K>, M>
implements BeanManager<K, V> {
    private final Cache<BeanMetaDataKey<K>, M> cache;
    private final CacheProperties properties;
    private final RetryConfig retryConfig;
    private final BeanFactory<K, V, M> beanFactory;
    private final IdentifierFactory<K> identifierFactory;
    private final CacheContainerCommandDispatcherFactory dispatcherFactory;
    private final BeanExpirationConfiguration<K, V> expiration;
    private final org.wildfly.clustering.function.Supplier<Batch> batchFactory;
    private final Predicate<Map.Entry<? super BeanMetaDataKey<K>, ? super M>> filter;
    private final Function<K, CacheContainerGroupMember> primaryOwnerLocator;
    private final Affinity strongAffinity;
    private volatile Scheduler<K, ExpirationMetaData> scheduler;
    private volatile ListenerRegistration schedulerListenerRegistration;
    private volatile UnaryOperator<Bean<K, V>> transformer;

    public InfinispanBeanManager(InfinispanBeanManagerConfiguration<K, V, M> configuration) {
        this.beanFactory = configuration.getBeanFactory();
        this.cache = configuration.getCache();
        this.properties = configuration.getCacheProperties();
        this.retryConfig = configuration.getRetryConfig();
        this.batchFactory = configuration.getBatchFactory();
        this.identifierFactory = new AffinityIdentifierFactory((Supplier)configuration.getIdentifierFactory(), this.cache);
        this.dispatcherFactory = configuration.getCommandDispatcherFactory();
        this.expiration = configuration.getExpiration();
        CacheContainerGroup group = this.dispatcherFactory.getGroup();
        this.primaryOwnerLocator = new UnaryGroupMemberAffinity(configuration.getCache(), group);
        this.strongAffinity = this.cache.getCacheConfiguration().clustering().cacheMode().isClustered() ? new ClusterAffinity(group.getName()) : new NodeAffinity(((CacheContainerGroupMember)group.getLocalMember()).getName());
        this.filter = new InfinispanBeanMetaDataFilter(configuration.getBeanName());
    }

    public boolean isStarted() {
        return this.identifierFactory.isStarted();
    }

    public void start() {
        this.identifierFactory.start();
        Duration stopTimeout = Duration.ofMillis(this.cache.getCacheConfiguration().transaction().cacheStopTimeout());
        PrimaryOwnerScheduler localScheduler = this.expiration != null && !this.expiration.getTimeout().isZero() ? new BeanExpirationScheduler(this.cache.getName(), this.dispatcherFactory.getGroup(), (Supplier<Batch>)this.batchFactory, this.beanFactory, this.expiration, stopTimeout) : null;
        final String dispatcherName = String.join((CharSequence)"/", this.cache.getName(), this.filter.toString());
        this.scheduler = localScheduler != null ? (this.dispatcherFactory.getGroup().isSingleton() ? localScheduler : new PrimaryOwnerScheduler(new PrimaryOwnerSchedulerConfiguration<K, ExpirationMetaData>((BeanExpirationScheduler)localScheduler){
            final /* synthetic */ BeanExpirationScheduler val$localScheduler;
            {
                this.val$localScheduler = beanExpirationScheduler;
            }

            public String getName() {
                return dispatcherName;
            }

            public CacheContainerCommandDispatcherFactory getCommandDispatcherFactory() {
                return InfinispanBeanManager.this.dispatcherFactory;
            }

            public Scheduler<K, ExpirationMetaData> getScheduler() {
                return this.val$localScheduler;
            }

            public Function<K, CacheContainerGroupMember> getAffinity() {
                return InfinispanBeanManager.this.primaryOwnerLocator;
            }

            public BiFunction<K, ExpirationMetaData, ScheduleCommand<K, ExpirationMetaData>> getScheduleCommandFactory() {
                return InfinispanBeanManager.this.properties.isTransactional() ? ScheduleWithExpirationMetaDataCommand::new : ScheduleWithTransientMetaDataCommand::new;
            }

            public RetryConfig getRetryConfig() {
                return InfinispanBeanManager.this.retryConfig;
            }
        })) : null;
        CacheEntriesTask scheduleTask = localScheduler != null ? CacheEntriesTask.schedule(this.cache, this.filter, (CacheEntryScheduler)localScheduler) : null;
        CacheEntriesTask cancelTask = localScheduler != null ? CacheEntriesTask.cancel(this.cache, this.filter, (CacheEntryScheduler)localScheduler) : null;
        ListenerRegistration listenerRegistration = this.schedulerListenerRegistration = localScheduler != null ? new SchedulerTopologyChangeListener(this.cache, (Consumer)scheduleTask, (Consumer)cancelTask).register() : null;
        if (scheduleTask != null) {
            scheduleTask.accept(CacheStreamFilter.local(this.cache));
        }
        Consumer<Bean> closeTask = this.expiration != null ? bean -> {
            if (bean.isValid()) {
                if (this.scheduler != null) {
                    this.scheduler.schedule(bean.getId(), (Object)bean.getMetaData());
                } else {
                    bean.remove(this.expiration.getExpirationListener());
                }
            }
        } : null;
        this.transformer = closeTask != null ? bean -> new OnCloseBean(bean, closeTask) : UnaryOperator.identity();
    }

    public void stop() {
        if (this.schedulerListenerRegistration != null) {
            this.schedulerListenerRegistration.close();
        }
        if (this.scheduler != null) {
            this.scheduler.close();
        }
        this.identifierFactory.stop();
    }

    public boolean isRemotable(Throwable throwable) {
        for (Throwable subject = throwable; subject != null; subject = subject.getCause()) {
            if (!(subject instanceof CacheException)) continue;
            return false;
        }
        return true;
    }

    public Affinity getStrongAffinity() {
        return this.strongAffinity;
    }

    public Affinity getWeakAffinity(K id) {
        Configuration config = this.cache.getCacheConfiguration();
        CacheMode mode = config.clustering().cacheMode();
        if (mode.isClustered()) {
            CacheContainerGroupMember member = this.primaryOwnerLocator.apply(id);
            return new NodeAffinity(member.getName());
        }
        return Affinity.NONE;
    }

    public Bean<K, V> createBean(V instance, K groupId) {
        Object id = instance.getId();
        InfinispanEjbLogger.ROOT_LOGGER.tracef("Creating bean %s associated with group %s", id, groupId);
        MutableBean bean = this.beanFactory.createBean(id, this.beanFactory.createValue(instance, groupId));
        bean.setInstance(instance);
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bean<K, V> findBean(K id) throws java.util.concurrent.TimeoutException {
        InfinispanEjbLogger.ROOT_LOGGER.tracef("Locating bean %s", id);
        Object value = this.beanFactory.findValue(id);
        if (value == null) {
            InfinispanEjbLogger.ROOT_LOGGER.debugf("Could not find bean %s", id);
            return null;
        }
        if (this.scheduler != null) {
            this.scheduler.cancel(id);
        }
        try {
            MutableBean bean = this.beanFactory.createBean(id, value);
            if (bean.getInstance() == null) {
                InfinispanEjbLogger.ROOT_LOGGER.tracef("Bean %s metadata was found, but bean instance was not, most likely due to passivation failure.", id);
                try {
                    this.beanFactory.purge(id);
                }
                finally {
                    bean.close();
                }
                return null;
            }
            if (bean.getMetaData().isExpired()) {
                InfinispanEjbLogger.ROOT_LOGGER.debugf("Bean %s found, but was expired", id);
                try {
                    bean.remove(this.expiration.getExpirationListener());
                }
                finally {
                    bean.close();
                }
                return null;
            }
            return (Bean)this.transformer.apply((Bean<K, V>)bean);
        }
        catch (TimeoutException e) {
            throw new java.util.concurrent.TimeoutException(e.getLocalizedMessage());
        }
    }

    public org.wildfly.clustering.function.Supplier<K> getIdentifierFactory() {
        return this.identifierFactory;
    }

    public org.wildfly.clustering.function.Supplier<Batch> getBatchFactory() {
        return this.batchFactory;
    }

    public int getActiveCount() {
        return this.count(EnumSet.of(Flag.SKIP_CACHE_LOAD));
    }

    public int getPassiveCount() {
        return this.count(Set.of()) - this.getActiveCount();
    }

    private int count(Set<Flag> flags) {
        CacheStreamFilter filter = CacheStreamFilter.local(this.cache);
        try (Stream entries = (Stream)filter.apply((Object)this.cache.getAdvancedCache().withFlags(flags).entrySet().stream());){
            int n = (int)entries.filter(this.filter).count();
            return n;
        }
    }
}

