/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.cache.bean;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import org.wildfly.clustering.ejb.bean.BeanMetaData;
import org.wildfly.clustering.ejb.cache.bean.BeanMetaDataEntry;
import org.wildfly.clustering.ejb.cache.bean.DefaultImmutableBeanMetaData;

public class DefaultBeanMetaData<K>
extends DefaultImmutableBeanMetaData<K>
implements BeanMetaData<K> {
    private final BeanMetaDataEntry<K> entry;
    private final Runnable mutator;

    public DefaultBeanMetaData(BeanMetaDataEntry<K> entry, Optional<Duration> maxIdle, Runnable mutator) {
        super(entry, maxIdle);
        this.entry = entry;
        this.mutator = mutator;
    }

    public void setLastAccessTime(Instant lastAccessTime) {
        Instant previousAccessTime = (Instant)this.entry.getLastAccessTime().get();
        if (previousAccessTime.isBefore(lastAccessTime)) {
            Duration duration = Duration.between(previousAccessTime, lastAccessTime);
            long seconds = duration.getSeconds();
            if (duration.getNano() > 0) {
                ++seconds;
            }
            Duration normalizedDuration = seconds > 1L ? Duration.ofSeconds(seconds) : ChronoUnit.SECONDS.getDuration();
            this.entry.getLastAccessTime().set((Object)previousAccessTime.plus(normalizedDuration));
        }
    }

    public void close() {
        this.mutator.run();
    }
}

