/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.cache.bean;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.wildfly.clustering.cache.CacheEntryMutator;
import org.wildfly.clustering.ejb.bean.BeanExpiration;
import org.wildfly.clustering.ejb.bean.BeanMetaData;
import org.wildfly.clustering.ejb.cache.bean.BeanMetaDataEntry;
import org.wildfly.clustering.ejb.cache.bean.DefaultImmutableBeanMetaData;

public class DefaultBeanMetaData<K>
extends DefaultImmutableBeanMetaData<K>
implements BeanMetaData<K> {
    private final BeanMetaDataEntry<K> entry;
    private final CacheEntryMutator mutator;

    public DefaultBeanMetaData(BeanMetaDataEntry<K> entry, BeanExpiration expiration, CacheEntryMutator mutator) {
        super(entry, expiration);
        this.entry = entry;
        this.mutator = mutator;
    }

    @Override
    public Instant getLastAccessTime() {
        return (Instant)this.entry.getLastAccess().get();
    }

    public void setLastAccessTime(Instant lastAccessTime) {
        Instant previousAccessTime = (Instant)this.entry.getLastAccess().get();
        if (previousAccessTime.isBefore(lastAccessTime)) {
            Duration duration = Duration.between(previousAccessTime, lastAccessTime);
            long seconds = duration.getSeconds();
            if (duration.getNano() > 0) {
                ++seconds;
            }
            Duration normalizedDuration = seconds > 1L ? Duration.ofSeconds(seconds) : ChronoUnit.SECONDS.getDuration();
            this.entry.getLastAccess().set((Object)previousAccessTime.plus(normalizedDuration));
        }
    }

    public void close() {
        this.mutator.mutate();
    }
}

