/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.retry;

import java.time.Duration;
import org.jboss.logging.Logger;
import org.wildfly.clustering.ee.Invoker;
import org.wildfly.common.function.ExceptionRunnable;
import org.wildfly.common.function.ExceptionSupplier;

public class RetryingInvoker
implements Invoker {
    private static final Logger LOGGER = Logger.getLogger(RetryingInvoker.class);
    private final Duration[] backOffIntervals;

    public RetryingInvoker(Duration ... backOffIntervals) {
        this.backOffIntervals = backOffIntervals;
    }

    @Override
    public <R, E extends Exception> R invoke(ExceptionSupplier<R, E> task) throws E {
        for (int i = 0; i < this.backOffIntervals.length && !Thread.currentThread().isInterrupted(); ++i) {
            try {
                return (R)task.get();
            }
            catch (Exception e) {
                LOGGER.debugf((Throwable)e, "Attempt #%d failed", i + 1);
                Duration delay = this.backOffIntervals[i];
                if (delay.isZero() || delay.isNegative()) {
                    Thread.yield();
                    continue;
                }
                try {
                    Thread.sleep(delay.toMillis(), delay.getNano() % 1000000);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
        }
        return (R)task.get();
    }

    @Override
    public <E extends Exception> void invoke(final ExceptionRunnable<E> action) throws E {
        ExceptionSupplier adapter = new ExceptionSupplier<Void, E>(){

            public Void get() throws Exception {
                action.run();
                return null;
            }
        };
        this.invoke(adapter);
    }
}

