/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.cache;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.security.Permission;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Chronology;
import java.time.chrono.Era;
import java.time.format.DateTimeFormatter;
import java.time.format.DecimalStyle;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;
import java.time.temporal.WeekFields;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneOffsetTransitionRule;
import java.time.zone.ZoneRules;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.function.Predicate;
import net.jcip.annotations.Immutable;
import org.wildfly.clustering.ee.cache.CollectionImmutability;

public enum Immutability implements Predicate<Object>
{
    OBJECT{
        private final Set<Object> immutableObjects = 1.createIdentitySet(Arrays.asList(null, Collections.emptyEnumeration(), Collections.emptyIterator(), Collections.emptyList(), Collections.emptyListIterator(), Collections.emptyMap(), Collections.emptyNavigableMap(), Collections.emptyNavigableSet(), Collections.emptySet(), Collections.emptySortedMap(), Collections.emptySortedSet()));

        @Override
        public boolean test(Object object) {
            return this.immutableObjects.contains(object);
        }
    }
    ,
    CLASS{
        private final Set<Class<?>> immutableClasses = 2.createIdentitySet(Arrays.asList(BigDecimal.class, BigInteger.class, Boolean.class, Byte.class, Character.class, Class.class, Currency.class, DateTimeFormatter.class, DecimalStyle.class, Double.class, Duration.class, File.class, Float.class, Inet4Address.class, Inet6Address.class, InetSocketAddress.class, Instant.class, Integer.class, Locale.class, LocalDate.class, LocalDateTime.class, LocalTime.class, Long.class, MathContext.class, MonthDay.class, Period.class, Short.class, StackTraceElement.class, String.class, URI.class, URL.class, UUID.class, ValueRange.class, WeekFields.class, Year.class, YearMonth.class, ZoneOffset.class, ZoneOffsetTransition.class, ZoneOffsetTransitionRule.class, ZoneRules.class, ZonedDateTime.class));

        @Override
        public boolean test(Object object) {
            return this.immutableClasses.contains(object.getClass());
        }
    }
    ,
    ABSTRACT_CLASS{
        private final List<Class<?>> immutableClasses = Arrays.asList(Chronology.class, ChronoLocalDate.class, Clock.class, Enum.class, Era.class, Path.class, Permission.class, TemporalField.class, TemporalUnit.class, TimeZone.class, ZoneId.class);

        @Override
        public boolean test(Object object) {
            for (Class<?> immutableClass : this.immutableClasses) {
                if (!immutableClass.isInstance(object)) continue;
                return true;
            }
            return false;
        }
    }
    ,
    COLLECTION{

        @Override
        public boolean test(Object object) {
            return COLLECTION_INSTANCE.test(object);
        }
    }
    ,
    ANNOTATION{

        @Override
        public boolean test(Object object) {
            return object.getClass().isAnnotationPresent(Immutable.class);
        }
    };

    public static final Predicate<Object> INSTANCE;
    static final Predicate<Object> COLLECTION_INSTANCE;

    static <T> Set<T> createIdentitySet(Collection<T> list) {
        Set result = Collections.newSetFromMap(new IdentityHashMap(list.size()));
        result.addAll(list);
        return Collections.unmodifiableSet(result);
    }

    static {
        INSTANCE = object -> {
            for (Predicate predicate : EnumSet.allOf(Immutability.class)) {
                if (!predicate.test(object)) continue;
                return true;
            }
            return false;
        };
        COLLECTION_INSTANCE = new CollectionImmutability(INSTANCE);
    }
}

