/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.cache;

import java.util.AbstractMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.wildfly.clustering.ee.Manager;

public class SimpleManager<K, V>
implements Manager<K, V> {
    private final Consumer<V> createTask;
    private final Consumer<V> closeTask;

    public SimpleManager(Consumer<V> createTask, Consumer<V> closeTask) {
        this.createTask = createTask;
        this.closeTask = closeTask;
    }

    public V apply(K key, Function<Runnable, V> factory) {
        final Consumer<V> closeTask = this.closeTask;
        final AbstractMap.SimpleEntry<K, Object> entry = new AbstractMap.SimpleEntry<K, Object>(key, null);
        V value = factory.apply(new Runnable(){

            @Override
            public void run() {
                closeTask.accept(entry.getValue());
            }
        });
        if (value != null) {
            entry.setValue(value);
            this.createTask.accept(value);
        }
        return value;
    }
}

