/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Condition;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jgroups.Message;
import org.jgroups.util.AverageMinMax;
import org.jgroups.util.Buffer;
import org.jgroups.util.LongTuple;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Tuple;

public class FixedBuffer<T>
extends Buffer<T> {
    protected T[] buf;
    protected final Condition buffer_full;
    protected boolean open;
    protected final LongAdder num_blockings;
    protected final AverageMinMax avg_time_blocked;
    protected final LongAdder num_dropped_msgs;

    public FixedBuffer() {
        this(0L);
    }

    public FixedBuffer(long offset) {
        this(32, offset);
    }

    public FixedBuffer(int capacity, long offset) {
        this.buffer_full = this.lock.newCondition();
        this.open = true;
        this.num_blockings = new LongAdder();
        this.avg_time_blocked = (AverageMinMax)new AverageMinMax(512).unit(TimeUnit.NANOSECONDS);
        this.num_dropped_msgs = new LongAdder();
        if (capacity < 1) {
            throw new IllegalArgumentException("incorrect capacity of " + capacity);
        }
        this.buf = new Object[capacity];
        this.high = this.offset = offset;
        this.hd = this.offset;
        this.low = this.offset;
    }

    @Override
    public int capacity() {
        return this.buf.length;
    }

    public long numBlockings() {
        return this.num_blockings.sum();
    }

    public AverageMinMax avgTimeBlocked() {
        return this.avg_time_blocked;
    }

    public long numDroppedMessages() {
        return this.num_dropped_msgs.sum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(long seqno, T element, Predicate<T> remove_filter) {
        this.lock.lock();
        try {
            long dist = seqno - this.low;
            if (dist <= 0L) {
                boolean bl = false;
                return bl;
            }
            if (dist > (long)this.capacity() && !this.block(seqno)) {
                this.num_dropped_msgs.increment();
                boolean bl = false;
                return bl;
            }
            int index = this.index(seqno);
            if (this.buf[index] != null) {
                boolean bl = false;
                return bl;
            }
            this.buf[index] = element;
            ++this.size;
            if (seqno - this.high > 0L) {
                this.high = seqno;
            }
            if (remove_filter != null && seqno - this.hd > 0L) {
                Buffer.Visitor<Object> v = (seq, msg) -> {
                    if (msg == null || !remove_filter.test(msg)) {
                        return false;
                    }
                    if (seq - this.hd > 0L) {
                        this.hd = seq;
                    }
                    this.size = Math.max(this.size - 1, 0);
                    return true;
                };
                this.forEach(this.highestDelivered() + 1L, this.high(), v, false, true);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(MessageBatch batch, Function<T, Long> seqno_getter, boolean remove_from_batch, T const_value) {
        if (batch == null || batch.isEmpty()) {
            return false;
        }
        Objects.requireNonNull(seqno_getter);
        boolean retval = false;
        this.lock.lock();
        try {
            Iterator<Message> it = batch.iterator();
            while (it.hasNext()) {
                Message msg = it.next();
                long seqno = seqno_getter.apply(msg);
                if (seqno < 0L) continue;
                Object element = const_value != null ? const_value : msg;
                boolean added = this.add(seqno, element, null);
                boolean bl = retval = retval || added;
                if (added && !remove_from_batch) continue;
                it.remove();
            }
            boolean bl = retval;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(List<LongTuple<T>> list, boolean remove_added_elements, T const_value) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        boolean added = false;
        this.lock.lock();
        try {
            Iterator<LongTuple<T>> it = list.iterator();
            while (it.hasNext()) {
                T element;
                LongTuple<T> tuple = it.next();
                long seqno = tuple.getVal1();
                T t = element = const_value != null ? const_value : tuple.getVal2();
                if (this.add(seqno, element, null)) {
                    added = true;
                    continue;
                }
                if (!remove_added_elements) continue;
                it.remove();
            }
            boolean bl = added;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T remove(boolean nullify) {
        this.lock.lock();
        try {
            long tmp = this.hd + 1L;
            if (tmp - this.high > 0L) {
                T t = null;
                return t;
            }
            int index = this.index(tmp);
            T element = this.buf[index];
            if (element != null) {
                this.hd = tmp;
                this.size = Math.max(this.size - 1, 0);
                if (nullify) {
                    this.buf[index] = null;
                    if (this.hd - this.low > 0L) {
                        this.low = this.hd;
                    }
                }
                this.buffer_full.signalAll();
            }
            T t = element;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<T> removeMany(boolean nullify, int max_results, Predicate<T> filter) {
        return this.removeMany(nullify, max_results, filter, LinkedList::new, LinkedList::add);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R removeMany(boolean nullify, int max_results, Predicate<T> filter, Supplier<R> result_creator, BiConsumer<R, T> accumulator) {
        Buffer.Remover<R> remover = new Buffer.Remover<R>(max_results, filter, result_creator, accumulator);
        this.lock.lock();
        try {
            this.forEach(remover, nullify);
            R r = remover.getResult();
            return r;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long seqno) {
        this.lock.lock();
        try {
            if (seqno - this.low <= 0L || seqno - this.high > 0L) {
                T t = null;
                return t;
            }
            int index = this.index(seqno);
            T t = this.buf[index];
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T _get(long seqno) {
        int index = this.index(seqno);
        this.lock.lock();
        try {
            T t = index < 0 ? null : (T)this.buf[index];
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int purge(long seqno, boolean force) {
        int purged = 0;
        this.lock.lock();
        try {
            if (seqno - this.low <= 0L) {
                int n = 0;
                return n;
            }
            if (force) {
                if (seqno - this.high > 0L) {
                    seqno = this.high;
                }
            } else if (seqno - this.hd > 0L) {
                seqno = this.hd;
            }
            long tmp = this.low;
            long from = this.low + 1L;
            int distance = (int)(seqno - from + 1L);
            for (int i = 0; i < distance; ++i) {
                int index = this.index(from);
                if (this.buf[index] != null) {
                    this.buf[index] = null;
                    ++purged;
                }
                ++this.low;
                ++from;
                this.hd = Math.max(this.hd, this.low);
            }
            if (force) {
                this.size = this.computeSize();
            }
            if (this.low - tmp > 0L) {
                this.buffer_full.signalAll();
            }
            int n = purged;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void changeCapacity(int new_capacity) {
        if (new_capacity == this.buf.length) {
            return;
        }
        this.lock.lock();
        try {
            if (new_capacity < this.buf.length) {
                this.decreaseCapacity(new_capacity);
            } else {
                this.increaseCapacity(new_capacity);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void forEach(long from, long to, Buffer.Visitor<T> visitor, boolean nullify) {
        this.forEach(from, to, visitor, nullify, false);
    }

    public void forEach(long from, long to, Buffer.Visitor<T> visitor, boolean nullify, boolean respect_stop) {
        if (from - to > 0L) {
            return;
        }
        int distance = (int)(to - from + 1L);
        long start = this.low;
        for (int i = 0; i < distance; ++i) {
            boolean stop;
            int index = this.index(from);
            T element = this.buf[index];
            boolean bl = stop = visitor != null && !visitor.visit(from, element);
            if (stop && respect_stop) break;
            if (nullify && element != null) {
                this.buf[index] = null;
                if (from - this.low > 0L) {
                    this.low = from;
                }
            }
            if (stop) break;
            ++from;
        }
        if (this.low - start > 0L) {
            this.buffer_full.signalAll();
        }
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_blockings.reset();
        this.num_dropped_msgs.reset();
        this.avg_time_blocked.clear();
    }

    @Override
    public void open(boolean b) {
        this.lock.lock();
        try {
            this.open = b;
            this.buffer_full.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new FixedBufferIterator(this.buf);
    }

    @Override
    public Iterator<T> iterator(long from, long to) {
        return new FixedBufferIterator(this.buf);
    }

    @Override
    public Stream<T> stream() {
        Spliterator<T> sp = Spliterators.spliterator(this.iterator(), (long)this.size(), 0);
        return StreamSupport.stream(sp, false);
    }

    @Override
    public Stream<T> stream(long from, long to) {
        Spliterator<T> sp = Spliterators.spliterator(this.iterator(), (long)this.size(), 0);
        return StreamSupport.stream(sp, false);
    }

    protected int index(long seqno) {
        return (int)((seqno - this.offset - 1L) % (long)this.capacity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean block(long seqno) {
        while (this.open && seqno - this.low > (long)this.capacity()) {
            this.num_blockings.increment();
            long start = System.nanoTime();
            try {
                this.buffer_full.await();
            }
            catch (InterruptedException time) {}
            continue;
            finally {
                long time = System.nanoTime() - start;
                this.avg_time_blocked.add(time);
            }
        }
        return this.open;
    }

    protected void increaseCapacity(int new_cap) {
        Object[] tmp = new Object[new_cap];
        System.arraycopy(this.buf, 0, tmp, 0, this.buf.length);
        this.buf = tmp;
    }

    protected void decreaseCapacity(int new_cap) {
        if (this.size > new_cap) {
            throw new IllegalStateException(String.format("size (%d) is > new capacity (%d)", this.size, new_cap));
        }
        ArrayList list = new ArrayList(this.size);
        Buffer.Visitor<Object> v = (seqno, el) -> list.add(new Tuple<Long, Object>(seqno, el));
        this.forEach(v, false);
        this.buf = new Object[new_cap];
        list.forEach(t -> this.add((Long)t.getVal1(), t.getVal2()));
        this.size = this.computeSize();
    }

    protected class FixedBufferIterator
    implements Iterator<T> {
        protected final T[] buffer;
        protected long current;

        public FixedBufferIterator(T[] buffer) {
            this.current = FixedBuffer.this.hd + 1L;
            this.buffer = buffer;
        }

        @Override
        public boolean hasNext() {
            return FixedBuffer.this.high - this.current >= 0L;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (FixedBuffer.this.hd - this.current >= 0L) {
                this.current = FixedBuffer.this.hd + 1L;
            }
            return this.buffer[FixedBuffer.this.index(this.current++)];
        }

        @Override
        public void remove() {
        }
    }
}

