/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.net.ssl.SSLSession;
import org.wildfly.common.Assert;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.sasl.SaslMechanismPredicate;
import org.wildfly.security.sasl._private.ElytronMessages;

public abstract class SaslMechanismSelector {
    private static final SaslMechanismPredicate[] NO_PREDICATES = new SaslMechanismPredicate[0];
    final SaslMechanismSelector prev;
    private int hashCode;
    public static final SaslMechanismSelector NONE = new EmptySelector();
    public static final SaslMechanismSelector ALL = NONE.addAllRemaining();
    public static final SaslMechanismSelector DEFAULT = ALL.forbidMatching(SaslMechanismPredicate.matchAny(SaslMechanismPredicate.matchFamily("IEC-ISO-9798"), SaslMechanismPredicate.matchExact("OTP"), SaslMechanismPredicate.matchExact("NTLM"), SaslMechanismPredicate.matchExact("CRAM-MD5")));
    private static final int TOK_INVALID = 0;
    private static final int TOK_FAMILY = 1;
    private static final int TOK_TLS = 2;
    private static final int TOK_PLUS = 3;
    private static final int TOK_MUTUAL = 4;
    private static final int TOK_HASH = 5;
    private static final int TOK_MINUS = 6;
    private static final int TOK_ALL = 7;
    private static final int TOK_LPAREN = 8;
    private static final int TOK_RPAREN = 9;
    private static final int TOK_OR = 10;
    private static final int TOK_AND = 11;
    private static final int TOK_EQ = 12;
    private static final int TOK_Q = 13;
    private static final int TOK_COLON = 14;
    private static final int TOK_NOT = 15;
    private static final int TOK_NAME = 16;
    private static final int TOK_END = -1;

    SaslMechanismSelector(SaslMechanismSelector prev) {
        this.prev = prev;
    }

    public Supplier<String> createMechanismSupplier(String[] mechNames) {
        return this.createMechanismSupplier(mechNames, null);
    }

    public Supplier<String> createMechanismSupplier(String[] mechNames, SSLSession sslSession) {
        Assert.checkNotNullParam("mechNames", mechNames);
        LinkedHashSet<String> set = new LinkedHashSet<String>(mechNames.length);
        Collections.addAll(set, mechNames);
        this.preprocess(set, sslSession);
        return this.doCreateSupplier(set, sslSession);
    }

    public Supplier<String> createMechanismSupplier(Collection<String> mechNames) {
        Assert.checkNotNullParam("mechNames", mechNames);
        return this.createMechanismSupplier(mechNames, null);
    }

    public Supplier<String> createMechanismSupplier(Collection<String> mechNames, SSLSession sslSession) {
        Assert.checkNotNullParam("mechNames", mechNames);
        LinkedHashSet<String> set = new LinkedHashSet<String>(mechNames);
        this.preprocess(set, sslSession);
        return this.doCreateSupplier(set, sslSession);
    }

    public List<String> apply(Collection<String> mechNames, SSLSession sslSession) {
        Assert.checkNotNullParam("mechNames", mechNames);
        Supplier<String> supplier = this.createMechanismSupplier(mechNames, sslSession);
        String first = supplier.get();
        if (first == null) {
            return Collections.emptyList();
        }
        String second = supplier.get();
        if (second == null) {
            return Collections.singletonList(first);
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(first);
        list.add(second);
        String name;
        while ((name = supplier.get()) != null) {
            list.add(name);
        }
        return list;
    }

    abstract Supplier<String> doCreateSupplier(LinkedHashSet<String> var1, SSLSession var2);

    void preprocess(Set<String> mechNames, SSLSession sslSession) {
        if (this.prev != null) {
            this.prev.preprocess(mechNames, sslSession);
        }
    }

    public SaslMechanismSelector addMechanism(String mechName) {
        Assert.checkNotNullParam("mechName", mechName);
        return new AddSelector(this, mechName);
    }

    public SaslMechanismSelector addMechanisms(String ... mechNames) {
        Assert.checkNotNullParam("mechNames", mechNames);
        SaslMechanismSelector selector = this;
        for (String mechName : mechNames) {
            selector = new AddSelector(selector, mechName);
        }
        return selector;
    }

    public SaslMechanismSelector forbidMechanism(String mechName) {
        Assert.checkNotNullParam("mechName", mechName);
        return new ForbidSelector(this, mechName);
    }

    public SaslMechanismSelector forbidMechanisms(String ... mechNames) {
        Assert.checkNotNullParam("mechNames", mechNames);
        SaslMechanismSelector selector = this;
        for (String mechName : mechNames) {
            selector = new ForbidSelector(selector, mechName);
        }
        return selector;
    }

    public SaslMechanismSelector addMatching(SaslMechanismPredicate predicate) {
        Assert.checkNotNullParam("predicate", predicate);
        return new AddMatchingSelector(this, predicate);
    }

    public SaslMechanismSelector forbidMatching(SaslMechanismPredicate predicate) {
        Assert.checkNotNullParam("predicate", predicate);
        return new ForbidMatchingSelector(this, predicate);
    }

    public SaslMechanismSelector addAllRemaining() {
        return this.addMatching(SaslMechanismPredicate.matchTrue());
    }

    public final String toString() {
        StringBuilder b = new StringBuilder();
        this.toString(b);
        return b.toString();
    }

    public int hashCode() {
        int hashCode = this.hashCode;
        if (hashCode == 0) {
            hashCode = this.forbidHashCode() * 19 + this.addHashCode();
            this.hashCode = hashCode == 0 ? 1 : hashCode;
            return this.hashCode;
        }
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return obj instanceof SaslMechanismSelector && this.equals((SaslMechanismSelector)obj);
    }

    public final boolean equals(SaslMechanismSelector selector) {
        return this == selector || selector != null && this.hashCode() == selector.hashCode() && this.forbidHalfEquals(selector) && selector.forbidHalfEquals(this) && this.addHalfEquals(selector) && selector.addHalfEquals(this);
    }

    static String tokToString(Tokenizer t) {
        switch (t.current()) {
            case 0: {
                return "<<invalid>>";
            }
            case 1: {
                return "#FAMILY";
            }
            case 2: {
                return "#TLS";
            }
            case 3: {
                return "#PLUS";
            }
            case 4: {
                return "#MUTUAL";
            }
            case 5: {
                return "#HASH";
            }
            case 6: {
                return "-";
            }
            case 7: {
                return "#ALL";
            }
            case 8: {
                return "(";
            }
            case 9: {
                return ")";
            }
            case 10: {
                return "||";
            }
            case 11: {
                return "&&";
            }
            case 12: {
                return "==";
            }
            case 13: {
                return "?";
            }
            case 14: {
                return ":";
            }
            case 15: {
                return "!";
            }
            case 16: {
                return "<name>";
            }
            case -1: {
                return "<<end>>";
            }
        }
        return "<<unknown>>";
    }

    public static SaslMechanismSelector fromString(String string) {
        Assert.checkNotNullParam("string", string);
        Tokenizer t = new Tokenizer(string);
        SaslMechanismSelector current = NONE;
        block8: while (t.hasNext()) {
            int tok = t.next();
            switch (tok) {
                case 16: {
                    current = current.addMechanism(t.getStringVal());
                    continue block8;
                }
                case 7: {
                    current = current.addAllRemaining();
                    continue block8;
                }
                case 6: {
                    if (!t.hasNext()) {
                        throw ElytronMessages.sasl.mechSelectorTokenNotAllowed(SaslMechanismSelector.tokToString(t), t.offset(), string);
                    }
                    tok = t.next();
                    switch (tok) {
                        case 16: {
                            current = current.forbidMechanism(t.getStringVal());
                            continue block8;
                        }
                    }
                    current = current.forbidMatching(SaslMechanismSelector.parseTopLevelPredicate(t, string, tok));
                    continue block8;
                }
            }
            current = current.addMatching(SaslMechanismSelector.parseTopLevelPredicate(t, string, tok));
        }
        return current;
    }

    private static SaslMechanismPredicate parseTopLevelPredicate(Tokenizer t, String string, int tok) {
        switch (tok) {
            case 8: {
                if (!t.hasNext()) {
                    throw ElytronMessages.sasl.mechSelectorUnexpectedEnd(string);
                }
                SaslMechanismPredicate result = SaslMechanismSelector.parseIfPredicate(t, string);
                if (!t.hasNext()) {
                    throw ElytronMessages.sasl.mechSelectorUnexpectedEnd(string);
                }
                if (t.next() != 9) {
                    throw ElytronMessages.sasl.mechSelectorTokenNotAllowed(SaslMechanismSelector.tokToString(t), t.offset(), string);
                }
                return result;
            }
            case 1: {
                return SaslMechanismPredicate.matchFamily(SaslMechanismSelector.parseSpecialWithName(string, t));
            }
            case 5: {
                return SaslMechanismPredicate.matchHashFunction(SaslMechanismSelector.parseSpecialWithName(string, t));
            }
            case 3: {
                return SaslMechanismPredicate.matchPlus();
            }
            case 2: {
                return SaslMechanismPredicate.matchTLSActive();
            }
            case 4: {
                return SaslMechanismPredicate.matchMutual();
            }
            case 16: {
                return SaslMechanismPredicate.matchExact(t.getStringVal());
            }
            case 15: {
                return SaslMechanismSelector.parseTopLevelPredicate(t, string).not();
            }
        }
        throw ElytronMessages.sasl.mechSelectorTokenNotAllowed(SaslMechanismSelector.tokToString(t), t.offset(), string);
    }

    private static SaslMechanismPredicate parseIfPredicate(Tokenizer t, String string) {
        SaslMechanismPredicate query = SaslMechanismSelector.parseEqPredicate(t, string);
        if (!t.hasNext() || t.peekNext() != 13) {
            return query;
        }
        t.next();
        SaslMechanismPredicate ifTrue = SaslMechanismSelector.parseIfPredicate(t, string);
        if (!t.hasNext()) {
            throw ElytronMessages.sasl.mechSelectorUnexpectedEnd(string);
        }
        if (t.next() != 14) {
            throw ElytronMessages.sasl.mechSelectorTokenNotAllowed(SaslMechanismSelector.tokToString(t), t.offset(), string);
        }
        SaslMechanismPredicate ifFalse = SaslMechanismSelector.parseIfPredicate(t, string);
        return SaslMechanismPredicate.matchIf(query, ifTrue, ifFalse);
    }

    private static SaslMechanismPredicate parseEqPredicate(Tokenizer t, String string) {
        SaslMechanismPredicate first = SaslMechanismSelector.parseOrPredicate(t, string);
        if (!t.hasNext() || t.peekNext() != 12) {
            return first;
        }
        ArrayList<SaslMechanismPredicate> list = new ArrayList<SaslMechanismPredicate>();
        list.add(first);
        t.next();
        do {
            list.add(SaslMechanismSelector.parseOrPredicate(t, string));
        } while (t.hasNext() && t.peekNext() == 12);
        return SaslMechanismPredicate.matchAllOrNone(list.toArray(NO_PREDICATES));
    }

    private static SaslMechanismPredicate parseOrPredicate(Tokenizer t, String string) {
        SaslMechanismPredicate first = SaslMechanismSelector.parseAndPredicate(t, string);
        if (!t.hasNext() || t.peekNext() != 10) {
            return first;
        }
        ArrayList<SaslMechanismPredicate> list = new ArrayList<SaslMechanismPredicate>();
        list.add(first);
        t.next();
        do {
            list.add(SaslMechanismSelector.parseAndPredicate(t, string));
        } while (t.hasNext() && t.peekNext() == 10);
        return SaslMechanismPredicate.matchAny(list.toArray(NO_PREDICATES));
    }

    private static SaslMechanismPredicate parseAndPredicate(Tokenizer t, String string) {
        SaslMechanismPredicate first = SaslMechanismSelector.parseTopLevelPredicate(t, string);
        if (!t.hasNext() || t.peekNext() != 11) {
            return first;
        }
        ArrayList<SaslMechanismPredicate> list = new ArrayList<SaslMechanismPredicate>();
        list.add(first);
        t.next();
        do {
            list.add(SaslMechanismSelector.parseTopLevelPredicate(t, string));
        } while (t.hasNext() && t.peekNext() == 10);
        return SaslMechanismPredicate.matchAll(list.toArray(NO_PREDICATES));
    }

    private static SaslMechanismPredicate parseTopLevelPredicate(Tokenizer t, String string) {
        if (!t.hasNext()) {
            throw ElytronMessages.sasl.mechSelectorUnexpectedEnd(string);
        }
        return SaslMechanismSelector.parseTopLevelPredicate(t, string, t.next());
    }

    private static String parseSpecialWithName(String string, Tokenizer t) {
        if (!t.hasNext()) {
            throw ElytronMessages.sasl.mechSelectorTokenNotAllowed(SaslMechanismSelector.tokToString(t), t.offset(), string);
        }
        if (t.next() != 8) {
            throw ElytronMessages.sasl.mechSelectorTokenNotAllowed(SaslMechanismSelector.tokToString(t), t.offset(), string);
        }
        if (!t.hasNext()) {
            throw ElytronMessages.sasl.mechSelectorTokenNotAllowed(SaslMechanismSelector.tokToString(t), t.offset(), string);
        }
        if (t.next() != 16) {
            throw ElytronMessages.sasl.mechSelectorTokenNotAllowed(SaslMechanismSelector.tokToString(t), t.offset(), string);
        }
        String familyName = t.getStringVal();
        if (!t.hasNext()) {
            throw ElytronMessages.sasl.mechSelectorTokenNotAllowed(SaslMechanismSelector.tokToString(t), t.offset(), string);
        }
        if (t.next() != 9) {
            throw ElytronMessages.sasl.mechSelectorTokenNotAllowed(SaslMechanismSelector.tokToString(t), t.offset(), string);
        }
        return familyName;
    }

    int addHashCode() {
        return this.prev == null ? 0 : this.prev.addHashCode();
    }

    int forbidHashCode() {
        return this.prev == null ? 0 : this.prev.forbidHashCode();
    }

    boolean forbidHalfEquals(SaslMechanismSelector selector) {
        SaslMechanismSelector prev = this.prev;
        return prev == null || prev.forbidHalfEquals(selector);
    }

    boolean addHalfEquals(SaslMechanismSelector selector) {
        SaslMechanismSelector prev = this.prev;
        return prev == null || prev.addHalfEquals(selector);
    }

    abstract void toString(StringBuilder var1);

    boolean adds(String mechName) {
        SaslMechanismSelector prev = this.prev;
        return prev != null && prev.adds(mechName);
    }

    boolean adds(SaslMechanismPredicate predicate) {
        SaslMechanismSelector prev = this.prev;
        return prev != null && prev.adds(predicate);
    }

    boolean forbids(String mechName) {
        SaslMechanismSelector prev = this.prev;
        return prev != null && prev.forbids(mechName);
    }

    boolean forbids(SaslMechanismPredicate predicate) {
        SaslMechanismSelector prev = this.prev;
        return prev != null && prev.forbids(predicate);
    }

    static class ForbidMatchingSelector
    extends SaslMechanismSelector {
        private final SaslMechanismPredicate predicate;

        ForbidMatchingSelector(SaslMechanismSelector prev, SaslMechanismPredicate predicate) {
            super(prev);
            this.predicate = predicate;
        }

        @Override
        void preprocess(Set<String> mechNames, SSLSession sslSession) {
            this.prev.preprocess(mechNames, sslSession);
            mechNames.removeIf(mechName -> this.predicate.test((String)mechName, sslSession));
        }

        @Override
        Supplier<String> doCreateSupplier(LinkedHashSet<String> set, SSLSession sslSession) {
            return this.prev.doCreateSupplier(set, sslSession);
        }

        @Override
        int forbidHashCode() {
            return super.forbidHashCode() * 19 + this.predicate.calcHashCode();
        }

        @Override
        boolean forbidHalfEquals(SaslMechanismSelector selector) {
            return super.forbidHalfEquals(selector) && selector.forbids(this.predicate);
        }

        @Override
        boolean forbids(SaslMechanismPredicate predicate) {
            return this.predicate.equals(predicate) || super.forbids(predicate);
        }

        @Override
        void toString(StringBuilder b) {
            this.prev.toString(b);
            if (b.length() > 0) {
                b.append(' ');
            }
            b.append('-').append('(').append(this.predicate).append(')');
        }
    }

    static class AddMatchingSelector
    extends SaslMechanismSelector {
        private final SaslMechanismPredicate predicate;

        AddMatchingSelector(SaslMechanismSelector prev, SaslMechanismPredicate predicate) {
            super(prev);
            this.predicate = predicate;
        }

        @Override
        Supplier<String> doCreateSupplier(LinkedHashSet<String> set, SSLSession sslSession) {
            Supplier<String> prevSupplier = this.prev.doCreateSupplier(set, sslSession);
            return () -> {
                String name = (String)prevSupplier.get();
                if (name != null) {
                    return name;
                }
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    name = (String)iterator.next();
                    if (!this.predicate.test(name, sslSession)) continue;
                    try {
                        String string = name;
                        return string;
                    }
                    finally {
                        iterator.remove();
                    }
                }
                return null;
            };
        }

        @Override
        int addHashCode() {
            return super.addHashCode() * 19 + this.predicate.calcHashCode();
        }

        @Override
        boolean addHalfEquals(SaslMechanismSelector selector) {
            return super.addHalfEquals(selector) && selector.adds(this.predicate);
        }

        @Override
        boolean adds(SaslMechanismPredicate predicate) {
            return this.predicate.equals(predicate) || super.adds(predicate);
        }

        @Override
        void toString(StringBuilder b) {
            this.prev.toString(b);
            if (b.length() > 0) {
                b.append(' ');
            }
            b.append('(').append(this.predicate).append(')');
        }
    }

    static class ForbidSelector
    extends SaslMechanismSelector {
        private final String mechName;

        ForbidSelector(SaslMechanismSelector prev, String mechName) {
            super(prev);
            this.mechName = mechName;
        }

        @Override
        void preprocess(Set<String> mechNames, SSLSession sslSession) {
            this.prev.preprocess(mechNames, sslSession);
            mechNames.remove(this.mechName);
        }

        @Override
        Supplier<String> doCreateSupplier(LinkedHashSet<String> set, SSLSession sslSession) {
            return this.prev.doCreateSupplier(set, sslSession);
        }

        @Override
        int forbidHashCode() {
            return super.forbidHashCode() * 19 + this.mechName.hashCode();
        }

        @Override
        boolean forbidHalfEquals(SaslMechanismSelector selector) {
            return super.forbidHalfEquals(selector) && selector.forbids(this.mechName);
        }

        @Override
        boolean forbids(String mechName) {
            return this.mechName.equals(mechName) || super.forbids(mechName);
        }

        @Override
        void toString(StringBuilder b) {
            this.prev.toString(b);
            if (b.length() > 0) {
                b.append(' ');
            }
            b.append('-').append(this.mechName);
        }
    }

    static class AddSelector
    extends SaslMechanismSelector {
        private final String mechName;

        AddSelector(SaslMechanismSelector prev, String mechName) {
            super(prev);
            this.mechName = mechName;
        }

        @Override
        Supplier<String> doCreateSupplier(LinkedHashSet<String> set, SSLSession sslSession) {
            Supplier<String> prevSupplier = this.prev.doCreateSupplier(set, sslSession);
            return () -> {
                String name = (String)prevSupplier.get();
                if (name != null) {
                    return name;
                }
                if (set.remove(this.mechName)) {
                    return this.mechName;
                }
                return null;
            };
        }

        @Override
        int addHashCode() {
            return super.addHashCode() * 19 + this.mechName.hashCode();
        }

        @Override
        boolean addHalfEquals(SaslMechanismSelector selector) {
            return super.addHalfEquals(selector) && selector.adds(this.mechName);
        }

        @Override
        boolean adds(String mechName) {
            return this.mechName.equals(mechName) || super.adds(mechName);
        }

        @Override
        void toString(StringBuilder b) {
            this.prev.toString(b);
            if (b.length() > 0) {
                b.append(' ');
            }
            b.append(this.mechName);
        }
    }

    static class EmptySelector
    extends SaslMechanismSelector {
        private static final Supplier<String> empty = () -> null;

        EmptySelector() {
            super(null);
        }

        @Override
        protected Supplier<String> doCreateSupplier(LinkedHashSet<String> set, SSLSession sslSession) {
            return empty;
        }

        @Override
        void toString(StringBuilder b) {
        }
    }

    static final class Tokenizer {
        private final String string;
        private final CodePointIterator i;
        private int current = 0;
        private int next;
        private long offs;
        private String stringVal;
        private String nextStringVal;

        Tokenizer(String string) {
            this.string = string;
            this.i = CodePointIterator.ofString(string);
        }

        private static boolean isNameChar(int cp) {
            return Character.isLetterOrDigit(cp) || cp == 45 || cp == 95;
        }

        boolean hasNext() {
            if (this.next == 0) {
                while (this.i.hasNext()) {
                    long offs = this.i.getIndex();
                    int cp = this.i.next();
                    if (Character.isWhitespace(cp)) continue;
                    switch (cp) {
                        case 35: {
                            if (!this.i.hasNext()) {
                                throw ElytronMessages.sasl.mechSelectorUnexpectedChar(cp, this.i.getIndex(), this.string);
                            }
                            offs = this.i.getIndex();
                            cp = this.i.next();
                            switch (cp) {
                                case 70: {
                                    if (!this.i.limitedTo(5L).contentEquals("AMILY")) {
                                        throw ElytronMessages.sasl.mechSelectorUnexpectedChar(cp, this.i.getIndex(), this.string);
                                    }
                                    if (this.i.hasNext() && Tokenizer.isNameChar(this.i.peekNext())) {
                                        throw ElytronMessages.sasl.mechSelectorUnexpectedChar(cp, this.i.getIndex(), this.string);
                                    }
                                    this.offs = offs;
                                    this.next = 1;
                                    return true;
                                }
                                case 84: {
                                    if (!this.i.limitedTo(2L).contentEquals("LS")) {
                                        throw ElytronMessages.sasl.mechSelectorUnexpectedChar(cp, this.i.getIndex(), this.string);
                                    }
                                    if (this.i.hasNext() && Tokenizer.isNameChar(this.i.peekNext())) {
                                        throw ElytronMessages.sasl.mechSelectorUnexpectedChar(cp, this.i.getIndex(), this.string);
                                    }
                                    this.offs = offs;
                                    this.next = 2;
                                    return true;
                                }
                                case 80: {
                                    if (!this.i.limitedTo(3L).contentEquals("LUS")) {
                                        throw ElytronMessages.sasl.mechSelectorUnexpectedChar(cp, this.i.getIndex(), this.string);
                                    }
                                    if (this.i.hasNext() && Tokenizer.isNameChar(this.i.peekNext())) {
                                        throw ElytronMessages.sasl.mechSelectorUnexpectedChar(cp, this.i.getIndex(), this.string);
                                    }
                                    this.offs = offs;
                                    this.next = 3;
                                    return true;
                                }
                                case 77: {
                                    if (!this.i.limitedTo(5L).contentEquals("UTUAL")) {
                                        throw ElytronMessages.sasl.mechSelectorUnexpectedChar(cp, this.i.getIndex(), this.string);
                                    }
                                    if (this.i.hasNext() && Tokenizer.isNameChar(this.i.peekNext())) {
                                        throw ElytronMessages.sasl.mechSelectorUnexpectedChar(cp, this.i.getIndex(), this.string);
                                    }
                                    this.offs = offs;
                                    this.next = 4;
                                    return true;
                                }
                                case 72: {
                                    if (!this.i.limitedTo(3L).contentEquals("ASH")) {
                                        throw ElytronMessages.sasl.mechSelectorUnexpectedChar(cp, this.i.getIndex(), this.string);
                                    }
                                    if (this.i.hasNext() && Tokenizer.isNameChar(this.i.peekNext())) {
                                        throw ElytronMessages.sasl.mechSelectorUnexpectedChar(cp, this.i.getIndex(), this.string);
                                    }
                                    this.offs = offs;
                                    this.next = 5;
                                    return true;
                                }
                                case 65: {
                                    if (!this.i.limitedTo(2L).contentEquals("LL")) {
                                        throw ElytronMessages.sasl.mechSelectorUnexpectedChar(cp, this.i.getIndex(), this.string);
                                    }
                                    if (this.i.hasNext() && Tokenizer.isNameChar(this.i.peekNext())) {
                                        throw ElytronMessages.sasl.mechSelectorUnexpectedChar(cp, this.i.getIndex(), this.string);
                                    }
                                    this.offs = offs;
                                    this.next = 7;
                                    return true;
                                }
                            }
                            throw ElytronMessages.sasl.mechSelectorUnexpectedChar(cp, this.i.getIndex(), this.string);
                        }
                        case 45: {
                            this.offs = offs;
                            this.next = 6;
                            return true;
                        }
                        case 40: {
                            this.offs = offs;
                            this.next = 8;
                            return true;
                        }
                        case 41: {
                            this.offs = offs;
                            this.next = 9;
                            return true;
                        }
                        case 63: {
                            this.offs = offs;
                            this.next = 13;
                            return true;
                        }
                        case 58: {
                            this.offs = offs;
                            this.next = 14;
                            return true;
                        }
                        case 33: {
                            this.offs = offs;
                            this.next = 15;
                            return true;
                        }
                        case 124: {
                            cp = this.i.next();
                            if (cp != 124) {
                                throw ElytronMessages.sasl.mechSelectorUnexpectedChar(cp, this.i.getIndex(), this.string);
                            }
                            this.offs = offs;
                            this.next = 10;
                            return true;
                        }
                        case 38: {
                            cp = this.i.next();
                            if (cp != 38) {
                                throw ElytronMessages.sasl.mechSelectorUnexpectedChar(cp, this.i.getIndex(), this.string);
                            }
                            this.offs = offs;
                            this.next = 11;
                            return true;
                        }
                        case 61: {
                            cp = this.i.next();
                            if (cp != 61) {
                                throw ElytronMessages.sasl.mechSelectorUnexpectedChar(cp, this.i.getIndex(), this.string);
                            }
                            this.offs = offs;
                            this.next = 12;
                            return true;
                        }
                    }
                    if (Character.isLetterOrDigit(cp) || cp == 95) {
                        long start = this.i.getIndex() - 1L;
                        do {
                            if (this.i.hasNext()) continue;
                            this.nextStringVal = this.string.substring((int)start);
                            this.offs = offs;
                            this.next = 16;
                            return true;
                        } while (Tokenizer.isNameChar(cp = this.i.next()));
                        this.nextStringVal = this.string.substring((int)start, (int)this.i.getIndex() - 1);
                        Objects.requireNonNull(this.nextStringVal);
                        this.i.previous();
                        this.offs = offs;
                        this.next = 16;
                        return true;
                    }
                    throw ElytronMessages.sasl.mechSelectorUnexpectedChar(cp, this.i.getIndex(), this.string);
                }
                this.next = -1;
                return false;
            }
            return this.next != -1;
        }

        int peekNext() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.next;
        }

        int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                int n = this.next;
                return n;
            }
            finally {
                this.current = this.next;
                this.stringVal = this.nextStringVal;
                this.next = 0;
                this.nextStringVal = null;
            }
        }

        int current() {
            return this.current;
        }

        int offset() {
            return (int)this.offs;
        }

        String getStringVal() {
            return this.stringVal;
        }
    }
}

