/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.util.AsciiString;
import org.jgroups.util.FastArray;

public class MessageBatch
implements Iterable<Message> {
    protected Address dest;
    protected Address sender;
    protected AsciiString cluster_name;
    protected FastArray<Message> messages;
    protected boolean multicast;
    protected Mode mode;
    protected long timestamp;

    public MessageBatch() {
    }

    public MessageBatch(int capacity) {
        this.messages = new FastArray(capacity);
    }

    public MessageBatch(Collection<Message> msgs) {
        this.messages = new FastArray(msgs.size());
        this.messages.addAll(msgs);
        this.determineMode();
    }

    public MessageBatch(Address dest, Address sender, AsciiString cluster_name, boolean multicast, Collection<Message> msgs) {
        this.messages = new FastArray(msgs.size());
        this.messages.addAll(msgs);
        this.dest = dest;
        this.sender = sender;
        this.cluster_name = cluster_name;
        this.multicast = multicast;
        this.determineMode();
    }

    public MessageBatch(Address dest, Address sender, AsciiString cluster_name, boolean multicast, Mode mode, int capacity) {
        this(capacity);
        this.dest = dest;
        this.sender = sender;
        this.cluster_name = cluster_name;
        this.multicast = multicast;
        this.mode = mode;
    }

    public Address getDest() {
        return this.dest;
    }

    public Address dest() {
        return this.dest;
    }

    public MessageBatch setDest(Address dest) {
        this.dest = dest;
        return this;
    }

    public MessageBatch dest(Address dest) {
        this.dest = dest;
        return this;
    }

    public Address getSender() {
        return this.sender;
    }

    public Address sender() {
        return this.sender;
    }

    public MessageBatch setSender(Address sender) {
        this.sender = sender;
        return this;
    }

    public MessageBatch sender(Address sender) {
        this.sender = sender;
        return this;
    }

    public AsciiString getClusterName() {
        return this.cluster_name;
    }

    public AsciiString clusterName() {
        return this.cluster_name;
    }

    public MessageBatch setClusterName(AsciiString name) {
        this.cluster_name = name;
        return this;
    }

    public MessageBatch clusterName(AsciiString name) {
        this.cluster_name = name;
        return this;
    }

    public MessageBatch cluster(AsciiString name) {
        this.cluster_name = name;
        return this;
    }

    public boolean isMulticast() {
        return this.multicast;
    }

    public boolean multicast() {
        return this.multicast;
    }

    public MessageBatch multicast(boolean flag) {
        this.multicast = flag;
        return this;
    }

    public MessageBatch mcast(boolean flag) {
        this.multicast = flag;
        return this;
    }

    public Mode getMode() {
        return this.mode();
    }

    public Mode mode() {
        return this.mode;
    }

    public MessageBatch setMode(Mode m) {
        return this.mode(m);
    }

    public MessageBatch mode(Mode m) {
        if (this.mode == null) {
            this.mode = m;
        }
        return this;
    }

    public int capacity() {
        return this.messages.capacity();
    }

    public long timestamp() {
        return this.timestamp;
    }

    public MessageBatch timestamp(long ts) {
        this.timestamp = ts;
        return this;
    }

    public MessageBatch increment(int i) {
        this.messages.increment(i);
        return this;
    }

    public MessageBatch incr(int i) {
        return this.increment(i);
    }

    public FastArray<Message> array() {
        return this.messages;
    }

    public <T extends Message> T first() {
        Iterator<Message> it = this.iterator();
        return (T)(it.hasNext() ? it.next() : null);
    }

    public <T extends Message> T last() {
        Iterator<Message> it = this.iterator();
        Message last = null;
        while (it.hasNext()) {
            last = it.next();
        }
        return (T)last;
    }

    public MessageBatch add(Message msg) {
        this.add(msg, true, true);
        return this;
    }

    public MessageBatch add(Message msg, boolean resize) {
        return this.add(msg, resize, true);
    }

    public MessageBatch add(Message msg, boolean resize, boolean determine_mode) {
        boolean added = this.messages.add(msg, resize);
        if (added && determine_mode) {
            this.determineMode();
        }
        return this;
    }

    public MessageBatch add(MessageBatch batch) {
        return this.add(batch, true);
    }

    public MessageBatch add(MessageBatch batch, boolean resize) {
        if (batch == null) {
            return this;
        }
        if (this == batch) {
            throw new IllegalArgumentException("cannot add batch to itself");
        }
        boolean added = this.messages.addAll(batch.array(), resize);
        if (added) {
            this.determineMode();
        }
        return this;
    }

    public MessageBatch add(Message[] msgs, int num_msgs) {
        boolean added = this.messages.addAll((T[])msgs, num_msgs);
        if (added) {
            this.determineMode();
        }
        return this;
    }

    public MessageBatch add(Collection<Message> msgs) {
        boolean added = this.messages.addAll(msgs);
        if (added) {
            this.determineMode();
        }
        return this;
    }

    public MessageBatch set(Address dest, Address sender, Message[] msgs) {
        this.messages.set((Message[])msgs);
        this.dest = dest;
        this.sender = sender;
        this.determineMode();
        return this;
    }

    public MessageBatch removeIf(Predicate<Message> filter, boolean match_all) {
        this.messages.removeIf(filter, match_all);
        return this;
    }

    public int transferFrom(MessageBatch other, boolean clear) {
        if (other == null || this == other) {
            return 0;
        }
        int num = this.messages.transferFrom(other.messages, clear);
        if (num > 0) {
            this.determineMode();
        }
        return num;
    }

    public MessageBatch clear() {
        this.messages.clear(true);
        return this;
    }

    public MessageBatch reset() {
        this.messages.clear(false);
        return this;
    }

    public boolean anyMatch(Predicate<Message> pred) {
        return this.messages.anyMatch(pred);
    }

    public MessageBatch determineMode() {
        if (this.mode != null || this.messages.isEmpty()) {
            return this;
        }
        Message first = this.messages.get(0);
        return this.mode(first.isFlagSet(Message.Flag.OOB) ? Mode.OOB : Mode.REG);
    }

    public int size() {
        return this.messages.size();
    }

    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    public long totalSize() {
        long retval = 0L;
        for (Message msg : this.messages) {
            retval += (long)msg.size();
        }
        return retval;
    }

    public int length() {
        int retval = 0;
        for (Message msg : this.messages) {
            retval += msg.getLength();
        }
        return retval;
    }

    public MessageBatch resize(int new_capacity) {
        this.messages.resize(new_capacity);
        return this;
    }

    @Override
    public Iterator<Message> iterator() {
        return this.messages.iterator();
    }

    public Iterator<Message> iterator(Predicate<Message> filter) {
        return this.messages.iterator(filter);
    }

    public Stream<Message> stream() {
        return this.stream(null, false);
    }

    public Stream<Message> stream(Predicate<Message> p) {
        return this.stream(p, false);
    }

    public Stream<Message> stream(Predicate<Message> p, boolean parallel) {
        Spliterator<Message> sp = Spliterators.spliterator(this.iterator(p), (long)this.size(), 0);
        return StreamSupport.stream(sp, parallel);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("dest=" + this.dest);
        if (this.sender != null) {
            sb.append(", sender=").append(this.sender);
        }
        if (this.mode != null) {
            sb.append(", mode=" + this.mode);
        }
        if (this.cluster_name != null) {
            sb.append(", cluster=").append(this.cluster_name);
        }
        if (sb.length() > 0) {
            sb.append(", ");
        }
        sb.append(this.size() + " messages [capacity=" + this.messages.capacity() + "]");
        return sb.toString();
    }

    public String printHeaders() {
        StringBuilder sb = new StringBuilder().append("dest=" + this.dest);
        if (this.sender != null) {
            sb.append(", sender=").append(this.sender);
        }
        sb.append("\n").append(this.size()).append(":\n");
        int count = 1;
        for (Message msg : this) {
            sb.append("#").append(count++).append(": ").append(msg.printHeaders()).append("\n");
        }
        return sb.toString();
    }

    public static enum Mode {
        OOB,
        REG;

    }
}

