/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import jakarta.jms.IllegalStateException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.InvalidSelectorException;
import jakarta.jms.JMSException;
import jakarta.jms.JMSSecurityException;
import jakarta.jms.TransactionRolledBackException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;

public final class JMSExceptionHelper {
    public static JMSException convertFromActiveMQException(ActiveMQInterruptedException me) {
        IllegalStateException je = new IllegalStateException(me.getMessage());
        je.setStackTrace(me.getStackTrace());
        je.initCause(me);
        return je;
    }

    public static JMSException convertFromActiveMQException(ActiveMQException me) {
        JMSException je = switch (me.getType()) {
            case ActiveMQExceptionType.CONNECTION_TIMEDOUT, ActiveMQExceptionType.INTERNAL_ERROR, ActiveMQExceptionType.NOT_CONNECTED -> new JMSException(me.getMessage());
            case ActiveMQExceptionType.UNSUPPORTED_PACKET, ActiveMQExceptionType.OBJECT_CLOSED, ActiveMQExceptionType.ILLEGAL_STATE -> new IllegalStateException(me.getMessage());
            case ActiveMQExceptionType.QUEUE_DOES_NOT_EXIST, ActiveMQExceptionType.QUEUE_EXISTS -> new InvalidDestinationException(me.getMessage());
            case ActiveMQExceptionType.INVALID_FILTER_EXPRESSION -> new InvalidSelectorException(me.getMessage());
            case ActiveMQExceptionType.SECURITY_EXCEPTION -> new JMSSecurityException(me.getMessage());
            case ActiveMQExceptionType.TRANSACTION_ROLLED_BACK -> new TransactionRolledBackException(me.getMessage());
            default -> new JMSException(me.getMessage());
        };
        je.setStackTrace(me.getStackTrace());
        je.initCause(me);
        return je;
    }
}

