/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.Services;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.batch._private.BatchLogger;

public class BatchServiceNames {
    public static final ServiceName BASE_BATCH_THREAD_POOL_NAME = ThreadsServices.EXECUTOR.append(new String[]{"batch"});
    public static final ServiceName BATCH_THREAD_POOL_NAME = BASE_BATCH_THREAD_POOL_NAME.append(new String[]{"batch"});

    public static ServiceName batchEnvironmentServiceName(DeploymentUnit deploymentUnit) {
        return deploymentUnit.getServiceName().append(new String[]{"batch"}).append(new String[]{"environment"});
    }

    public static ServiceName jobXmlResolverServiceName(DeploymentUnit deploymentUnit) {
        return deploymentUnit.getServiceName().append(new String[]{"batch"}).append(new String[]{"job-xml"});
    }

    public static ServiceName beanManagerServiceName(DeploymentUnit deploymentUnit) {
        return deploymentUnit.getServiceName().append(new String[]{"beanmanager"});
    }

    public static ServiceName jobOperatorServiceName(DeploymentUnit deploymentUnit) {
        return deploymentUnit.getServiceName().append(new String[]{"batch"}).append(new String[]{"job-operator"});
    }

    public static ServiceName jobOperatorServiceName(PathAddress address) {
        String deploymentName = null;
        String subdeploymentName = null;
        for (PathElement element : address) {
            if ("deployment".equals(element.getKey())) {
                deploymentName = element.getValue();
                continue;
            }
            if (!"subdeployment".endsWith(element.getKey())) continue;
            subdeploymentName = element.getValue();
        }
        if (deploymentName == null) {
            throw BatchLogger.LOGGER.couldNotFindDeploymentName(address.toString());
        }
        ServiceName result = subdeploymentName == null ? Services.deploymentUnitName(deploymentName) : Services.deploymentUnitName(deploymentName, subdeploymentName);
        return result.append(new String[]{"batch"}).append(new String[]{"job-operator"});
    }
}

