/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.DefaultAttributeMarshaller;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.threads.ThreadFactoryResolver;
import org.jboss.as.threads.ThreadFactoryResourceDefinition;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.as.threads.UnboundedQueueThreadPoolResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.batch.BatchResourceDescriptionResolver;
import org.wildfly.extension.batch.BatchServiceNames;
import org.wildfly.extension.batch.Element;
import org.wildfly.extension.batch.JobRepositoryDefinition;
import org.wildfly.extension.batch.deployment.BatchDependencyProcessor;
import org.wildfly.extension.batch.deployment.BatchDeploymentResourceProcessor;
import org.wildfly.extension.batch.deployment.BatchEnvironmentProcessor;
import org.wildfly.extension.batch.job.repository.JobRepositoryFactory;
import org.wildfly.extension.batch.job.repository.JobRepositoryType;

public class BatchSubsystemDefinition
extends SimpleResourceDefinition {
    public static final String NAME = "batch";
    public static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"batch");
    static final PathElement THREAD_POOL_PATH = PathElement.pathElement((String)"thread-pool", (String)"batch");
    static final SimpleAttributeDefinition JOB_REPOSITORY_TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"job-repository-type", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(false)).setAttributeMarshaller((AttributeMarshaller)new DefaultAttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, XMLStreamWriter writer) throws XMLStreamException {
            this.marshallAsElement(attribute, resourceModel, true, writer);
        }

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            writer.writeStartElement(Element.JOB_REPOSITORY.getLocalName());
            String value = resourceModel.get(JOB_REPOSITORY_TYPE.getName()).asString();
            if (JobRepositoryType.JDBC.toString().equals(value)) {
                writer.writeStartElement(Element.JDBC.getLocalName());
                PathElement jdbcPath = JobRepositoryDefinition.JDBC.getPathElement();
                ModelNode jdbcModel = resourceModel.clone().get(new String[]{jdbcPath.getKey(), jdbcPath.getValue()});
                if (jdbcModel.isDefined()) {
                    JobRepositoryDefinition.JNDI_NAME.marshallAsAttribute(jdbcModel, false, writer);
                }
                writer.writeEndElement();
            } else {
                writer.writeStartElement(Element.IN_MEMORY.getLocalName());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    })).setDefaultValue(new ModelNode(JobRepositoryType.IN_MEMORY.toString()))).setValidator((ParameterValidator)new EnumValidator(JobRepositoryType.class, true, true))).setRestartJVM()).build();
    public static final BatchSubsystemDefinition INSTANCE = new BatchSubsystemDefinition();

    private BatchSubsystemDefinition() {
        super(SUBSYSTEM_PATH, (ResourceDescriptionResolver)BatchResourceDescriptionResolver.getResourceDescriptionResolver(), (OperationStepHandler)BatchSubsystemAdd.INSTANCE, (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        super.registerChildren(resourceRegistration);
        UnboundedQueueThreadPoolResourceDefinition threadPoolResource = UnboundedQueueThreadPoolResourceDefinition.create((PathElement)THREAD_POOL_PATH, (ThreadFactoryResolver)BatchThreadFactoryResolver.INSTANCE, (ServiceName)BatchServiceNames.BASE_BATCH_THREAD_POOL_NAME, (boolean)false);
        resourceRegistration.registerSubModel((ResourceDefinition)threadPoolResource);
        ThreadFactoryResourceDefinition threadFactoryResource = new ThreadFactoryResourceDefinition();
        resourceRegistration.registerSubModel((ResourceDefinition)threadFactoryResource);
        resourceRegistration.registerSubModel((ResourceDefinition)JobRepositoryDefinition.JDBC);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)JOB_REPOSITORY_TYPE, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{JOB_REPOSITORY_TYPE}));
    }

    static class BatchSubsystemAdd
    extends AbstractAddStepHandler {
        static final BatchSubsystemAdd INSTANCE = new BatchSubsystemAdd();

        private BatchSubsystemAdd() {
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            model.setEmptyObject();
            JOB_REPOSITORY_TYPE.validateAndSet(operation, model);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

                public void execute(DeploymentProcessorTarget processorTarget) {
                    processorTarget.addDeploymentProcessor(BatchSubsystemDefinition.NAME, Phase.DEPENDENCIES, 6912, (DeploymentUnitProcessor)new BatchDependencyProcessor());
                    processorTarget.addDeploymentProcessor(BatchSubsystemDefinition.NAME, Phase.POST_MODULE, 12544, (DeploymentUnitProcessor)new BatchEnvironmentProcessor());
                    processorTarget.addDeploymentProcessor(BatchSubsystemDefinition.NAME, Phase.INSTALL, 8304, (DeploymentUnitProcessor)new BatchDeploymentResourceProcessor());
                }
            }, OperationContext.Stage.RUNTIME);
            String repositoryType = JOB_REPOSITORY_TYPE.resolveModelAttribute(context, model).asString();
            JobRepositoryFactory.getInstance().setJobRepositoryType(repositoryType);
        }
    }

    private static class BatchThreadFactoryResolver
    extends ThreadFactoryResolver.SimpleResolver {
        static final BatchThreadFactoryResolver INSTANCE = new BatchThreadFactoryResolver();

        private BatchThreadFactoryResolver() {
            super(ThreadsServices.FACTORY);
        }

        protected String getThreadGroupName(String threadPoolName) {
            return "Batch Thread";
        }
    }
}

