/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet.deployment;

import jakarta.batch.operations.JobOperator;
import javax.sql.DataSource;
import org.jberet.repository.JobRepository;
import org.jberet.spi.ContextClassLoaderJobOperatorContextSelector;
import org.jberet.spi.JobExecutor;
import org.jberet.spi.JobOperatorContext;
import org.jboss.as.controller.ProcessStateNotifier;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.naming.InjectedEENamespaceContextSelector;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.as.weld.WeldCapability;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.wildfly.extension.batch.jberet.BatchConfiguration;
import org.wildfly.extension.batch.jberet.BatchServiceNames;
import org.wildfly.extension.batch.jberet._private.BatchLogger;
import org.wildfly.extension.batch.jberet._private.Capabilities;
import org.wildfly.extension.batch.jberet.deployment.ArtifactFactoryService;
import org.wildfly.extension.batch.jberet.deployment.BatchAttachments;
import org.wildfly.extension.batch.jberet.deployment.BatchEnvironmentMetaData;
import org.wildfly.extension.batch.jberet.deployment.BatchEnvironmentService;
import org.wildfly.extension.batch.jberet.deployment.JobOperatorService;
import org.wildfly.extension.batch.jberet.deployment.SecurityAwareBatchEnvironment;
import org.wildfly.extension.batch.jberet.deployment.WildFlyArtifactFactory;
import org.wildfly.extension.batch.jberet.deployment.WildFlyJobXmlResolver;
import org.wildfly.extension.batch.jberet.job.repository.JdbcJobRepositoryService;
import org.wildfly.extension.requestcontroller.RequestController;

public class BatchEnvironmentProcessor
implements DeploymentUnitProcessor {
    private final boolean rcPresent;
    private final boolean legacySecurityPresent;
    private final ContextClassLoaderJobOperatorContextSelector selector;

    public BatchEnvironmentProcessor(boolean rcPresent, boolean legacySecurityPresent, ContextClassLoaderJobOperatorContextSelector selector) {
        this.rcPresent = rcPresent;
        this.legacySecurityPresent = legacySecurityPresent;
        this.selector = selector;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.hasAttachment(Attachments.MODULE)) {
            WeldCapability api;
            DeploymentUnit parent;
            BatchLogger.LOGGER.tracef("Processing deployment '%s' for the batch environment.", deploymentUnit.getName());
            WildFlyJobXmlResolver jobXmlResolver = WildFlyJobXmlResolver.forDeployment(deploymentUnit);
            if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)deploymentUnit)) {
                return;
            }
            Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
            ModuleClassLoader moduleClassLoader = module.getClassLoader();
            ServiceTarget serviceTarget = phaseContext.getServiceTarget();
            JobRepository jobRepository = null;
            String jobRepositoryName = null;
            String dataSourceName = null;
            String jobExecutorName = null;
            Boolean restartJobsOnResume = null;
            Integer executionRecordsLimit = null;
            BatchEnvironmentMetaData metaData = (BatchEnvironmentMetaData)deploymentUnit.getAttachment(BatchAttachments.BATCH_ENVIRONMENT_META_DATA);
            if (metaData == null && (parent = deploymentUnit.getParent()) != null) {
                metaData = (BatchEnvironmentMetaData)parent.getAttachment(BatchAttachments.BATCH_ENVIRONMENT_META_DATA);
            }
            if (metaData != null) {
                jobRepository = metaData.getJobRepository();
                jobRepositoryName = metaData.getJobRepositoryName();
                dataSourceName = metaData.getDataSourceName();
                jobExecutorName = metaData.getExecutorName();
                restartJobsOnResume = metaData.getRestartJobsOnResume();
                executionRecordsLimit = metaData.getExecutionRecordsLimit();
            }
            CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
            String deploymentName = deploymentUnit.getName();
            JobOperatorService jobOperatorService = new JobOperatorService(restartJobsOnResume, deploymentName, jobXmlResolver);
            EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
            InjectedEENamespaceContextSelector namespaceContextSelector = eeModuleDescription == null ? null : eeModuleDescription.getNamespaceContextSelector();
            BatchEnvironmentService service = new BatchEnvironmentService((ClassLoader)moduleClassLoader, jobXmlResolver, deploymentName, (NamespaceContextSelector)namespaceContextSelector, this.legacySecurityPresent);
            ServiceBuilder serviceBuilder = serviceTarget.addService(BatchServiceNames.batchEnvironmentServiceName(deploymentUnit), (Service)service);
            if (jobExecutorName != null) {
                serviceBuilder.addDependency(Capabilities.THREAD_POOL_CAPABILITY.getCapabilityServiceName(new String[]{jobExecutorName}), JobExecutor.class, service.getJobExecutorInjector());
            }
            serviceBuilder.addDependency(Capabilities.BATCH_CONFIGURATION_CAPABILITY.getCapabilityServiceName(), BatchConfiguration.class, service.getBatchConfigurationInjector());
            serviceBuilder.requires(support.getCapabilityServiceName("org.wildfly.transactions.global-default-local-provider"));
            ServiceName artifactFactoryServiceName = BatchServiceNames.batchArtifactFactoryServiceName(deploymentUnit);
            ArtifactFactoryService artifactFactoryService = new ArtifactFactoryService();
            ServiceBuilder artifactFactoryServiceBuilder = serviceTarget.addService(artifactFactoryServiceName, (Service)artifactFactoryService);
            if (support.hasCapability("org.wildfly.weld") && (api = (WeldCapability)support.getOptionalCapabilityRuntimeAPI("org.wildfly.weld", WeldCapability.class).get()).isPartOfWeldDeployment(deploymentUnit)) {
                BatchLogger.LOGGER.tracef("Adding BeanManager service dependency for deployment %s", deploymentUnit.getName());
                api.addBeanManagerService(deploymentUnit, artifactFactoryServiceBuilder, artifactFactoryService.getBeanManagerInjector());
            }
            artifactFactoryServiceBuilder.install();
            serviceBuilder.addDependency(artifactFactoryServiceName, WildFlyArtifactFactory.class, service.getArtifactFactoryInjector());
            if (jobRepositoryName != null) {
                serviceBuilder.addDependency(support.getCapabilityServiceName(Capabilities.JOB_REPOSITORY_CAPABILITY.getName(), new String[]{jobRepositoryName}), JobRepository.class, service.getJobRepositoryInjector());
            } else if (dataSourceName != null) {
                JdbcJobRepositoryService jdbcJobRepositoryService = new JdbcJobRepositoryService(executionRecordsLimit);
                ServiceName jobRepositoryServiceName = support.getCapabilityServiceName(Capabilities.JOB_REPOSITORY_CAPABILITY.getName(), new String[]{deploymentName});
                ServiceBuilder jobRepositoryServiceBuilder = Services.addServerExecutorDependency((ServiceBuilder)serviceTarget.addService(jobRepositoryServiceName, (Service)jdbcJobRepositoryService), jdbcJobRepositoryService.getExecutorServiceInjector()).addDependency(support.getCapabilityServiceName("org.wildfly.data-source", new String[]{dataSourceName}), DataSource.class, jdbcJobRepositoryService.getDataSourceInjector());
                jobRepositoryServiceBuilder.install();
                serviceBuilder.addDependency(jobRepositoryServiceName, JobRepository.class, service.getJobRepositoryInjector());
            } else if (jobRepository != null) {
                service.getJobRepositoryInjector().setValue((Value)new ImmediateValue((Object)jobRepository));
            }
            if (this.rcPresent) {
                serviceBuilder.addDependency(RequestController.SERVICE_NAME, RequestController.class, service.getRequestControllerInjector());
            }
            serviceBuilder.install();
            ServiceName jobOperatorServiceName = BatchServiceNames.jobOperatorServiceName(deploymentUnit);
            Services.addServerExecutorDependency((ServiceBuilder)serviceTarget.addService(jobOperatorServiceName, (Service)jobOperatorService).addDependency(support.getCapabilityServiceName(Capabilities.BATCH_CONFIGURATION_CAPABILITY.getName()), BatchConfiguration.class, jobOperatorService.getBatchConfigurationInjector()).addDependency(support.getCapabilityServiceName("org.wildfly.server.suspend-controller"), SuspendController.class, jobOperatorService.getSuspendControllerInjector()).addDependency(support.getCapabilityServiceName("org.wildfly.management.process-state-notifier"), ProcessStateNotifier.class, jobOperatorService.getProcessStateInjector()).addDependency(BatchServiceNames.batchEnvironmentServiceName(deploymentUnit), SecurityAwareBatchEnvironment.class, jobOperatorService.getBatchEnvironmentInjector()), jobOperatorService.getExecutorServiceInjector()).install();
            deploymentUnit.putAttachment(BatchAttachments.JOB_OPERATOR, (Object)jobOperatorService);
            deploymentUnit.addToAttachmentList(Attachments.DEPLOYMENT_COMPLETE_SERVICES, (Object)jobOperatorServiceName);
            this.selector.registerContext((ClassLoader)moduleClassLoader, JobOperatorContext.create((JobOperator)jobOperatorService));
        }
    }

    public void undeploy(DeploymentUnit context) {
        if (context.hasAttachment(Attachments.MODULE)) {
            this.selector.unregisterContext((ClassLoader)((Module)context.getAttachment(Attachments.MODULE)).getClassLoader());
        }
    }
}

