/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.domain.managed;

import java.io.File;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.deployment.Validate;
import org.jboss.as.arquillian.container.domain.CommonDomainContainerConfiguration;

public class ManagedDomainContainerConfiguration
extends CommonDomainContainerConfiguration {
    private String jbossHome = System.getenv("JBOSS_HOME");
    private String javaHome = System.getenv("JAVA_HOME");
    private String modulePath = System.getProperty("module.path");
    private String javaVmArguments = System.getProperty("jboss.options", "-Xmx512m -XX:MaxPermSize=256m");
    private int startupTimeoutInSeconds = 60;
    private int stopTimeoutInSeconds = 60;
    private int autoServerStartupTimeoutInSeconds = 60;
    private boolean outputToConsole = true;
    private String domainConfig = System.getProperty("jboss.domain.default.config", "domain.xml");
    private String hostConfig = System.getProperty("jboss.host.default.config", "host.xml");
    private boolean allowConnectingToRunningServer = false;
    private boolean enableAssertions = true;
    private boolean setupCleanServerBaseDir = false;
    private String cleanServerBaseDir;

    public ManagedDomainContainerConfiguration() {
        if (this.javaHome == null || this.javaHome.isEmpty()) {
            this.javaHome = System.getProperty("java.home");
        }
    }

    public void validate() throws ConfigurationException {
        super.validate();
        Validate.configurationDirectoryExists((String)this.jbossHome, (String)("jbossHome '" + this.jbossHome + "' must exist"));
        if (this.javaHome != null) {
            Validate.configurationDirectoryExists((String)this.javaHome, (String)"javaHome must exist");
        }
    }

    public String getJbossHome() {
        return this.jbossHome;
    }

    public void setJbossHome(String jbossHome) {
        this.jbossHome = new File(jbossHome).getAbsolutePath();
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    public String getJavaVmArguments() {
        return this.javaVmArguments;
    }

    public void setJavaVmArguments(String javaVmArguments) {
        this.javaVmArguments = javaVmArguments;
    }

    public void setStartupTimeoutInSeconds(int startupTimeoutInSeconds) {
        this.startupTimeoutInSeconds = startupTimeoutInSeconds;
    }

    public int getStartupTimeoutInSeconds() {
        return this.startupTimeoutInSeconds;
    }

    public void setStopTimeoutInSeconds(int stopTimeoutInSeconds) {
        this.stopTimeoutInSeconds = stopTimeoutInSeconds;
    }

    public int getStopTimeoutInSeconds() {
        return this.stopTimeoutInSeconds;
    }

    public void setAutoServerStartupTimeoutInSeconds(int autoServerStartupTimeoutInSeconds) {
        this.autoServerStartupTimeoutInSeconds = autoServerStartupTimeoutInSeconds;
    }

    public int getAutoServerStartupTimeoutInSeconds() {
        return this.autoServerStartupTimeoutInSeconds;
    }

    public void setOutputToConsole(boolean outputToConsole) {
        this.outputToConsole = outputToConsole;
    }

    public boolean isOutputToConsole() {
        return this.outputToConsole;
    }

    public String getDomainConfig() {
        return this.domainConfig;
    }

    public void setDomainConfig(String domainConfig) {
        this.domainConfig = domainConfig;
    }

    public String getModulePath() {
        return this.modulePath;
    }

    public String getHostConfig() {
        return this.hostConfig;
    }

    public void setHostConfig(String hostConfig) {
        this.hostConfig = hostConfig;
    }

    public void setModulePath(String modulePath) {
        this.modulePath = modulePath;
    }

    public boolean isAllowConnectingToRunningServer() {
        return this.allowConnectingToRunningServer;
    }

    public void setAllowConnectingToRunningServer(boolean allowConnectingToRunningServer) {
        this.allowConnectingToRunningServer = allowConnectingToRunningServer;
    }

    public boolean isEnableAssertions() {
        return this.enableAssertions;
    }

    public void setEnableAssertions(boolean enableAssertions) {
        this.enableAssertions = enableAssertions;
    }

    public boolean isSetupCleanServerBaseDir() {
        return this.setupCleanServerBaseDir;
    }

    public void setSetupCleanServerBaseDir(boolean setupCleanServerBaseDir) {
        this.setupCleanServerBaseDir = setupCleanServerBaseDir;
    }

    public String getCleanServerBaseDir() {
        return this.cleanServerBaseDir;
    }

    public void setCleanServerBaseDir(String cleanServerBaseDir) {
        this.cleanServerBaseDir = cleanServerBaseDir;
    }
}

