/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.domain.managed;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.as.arquillian.container.domain.CommonDomainDeployableContainer;
import org.jboss.as.arquillian.container.domain.Domain;
import org.jboss.as.arquillian.container.domain.ManagementClient;
import org.jboss.as.arquillian.container.domain.managed.ManagedDomainContainerConfiguration;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.server.ServerMessages;
import org.jboss.dmr.ModelNode;

public class ManagedDomainDeployableContainer
extends CommonDomainDeployableContainer<ManagedDomainContainerConfiguration> {
    static final String TEMP_CONTAINER_DIRECTORY = "arquillian-temp-container";
    static final String SERVER_BASE_DIR = "domain";
    static final String CONFIG_DIR = "configuration";
    static final String LOG_DIR = "log";
    static final String DATA_DIR = "data";
    static final String SERVERS_DIR = "servers";
    private final Logger log = Logger.getLogger(ManagedDomainDeployableContainer.class.getName());
    private Thread shutdownThread;
    private Process process;

    public Class<ManagedDomainContainerConfiguration> getConfigurationClass() {
        return ManagedDomainContainerConfiguration.class;
    }

    protected void startInternal() throws LifecycleException {
        ManagedDomainContainerConfiguration config = (ManagedDomainContainerConfiguration)this.getContainerConfiguration();
        if (this.isServerRunning()) {
            if (config.isAllowConnectingToRunningServer()) {
                return;
            }
            this.failDueToRunning();
        }
        try {
            List<String> additionalJavaOptsCmd = this.createAdditionalJavaOptsCmd(config);
            String jbossHomeDir = config.getJbossHome();
            String serverBaseDir = this.getSystemPropertyValue(additionalJavaOptsCmd, "jboss.server.base.dir", jbossHomeDir + File.separatorChar + SERVER_BASE_DIR);
            if (config.isSetupCleanServerBaseDir() || config.getCleanServerBaseDir() != null) {
                File cleanServerDirectories = ManagedDomainDeployableContainer.setupCleanServerDirectories(serverBaseDir, jbossHomeDir, config.getCleanServerBaseDir());
                this.replaceSystemPropertyValue(additionalJavaOptsCmd, "jboss.server.base.dir", cleanServerDirectories.toString());
            }
            List<String> loggingOptsCmd = this.createLoggingOptsCmd(additionalJavaOptsCmd, jbossHomeDir, serverBaseDir);
            List<String> cmd = this.createCommandLine(config, additionalJavaOptsCmd, loggingOptsCmd);
            this.log.info("Starting container with: " + cmd.toString());
            ProcessBuilder processBuilder = new ProcessBuilder(cmd);
            processBuilder.redirectErrorStream(true);
            this.process = processBuilder.start();
            new Thread(new ConsoleConsumer()).start();
            final Process proc = this.process;
            this.shutdownThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (proc != null) {
                        proc.destroy();
                        try {
                            proc.waitFor();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
            Runtime.getRuntime().addShutdownHook(this.shutdownThread);
            long startupTimeout = ((ManagedDomainContainerConfiguration)this.getContainerConfiguration()).getStartupTimeoutInSeconds();
            long timeout = startupTimeout * 1000L;
            boolean serverAvailable = false;
            long sleep = 1000L;
            while (timeout > 0L && !serverAvailable) {
                serverAvailable = this.getManagementClient().isDomainInRunningState();
                if (serverAvailable) continue;
                if (ManagedDomainDeployableContainer.processHasDied(proc)) break;
                Thread.sleep(sleep);
                timeout -= sleep;
                sleep = Math.max(sleep / 2L, 100L);
            }
            if (!serverAvailable) {
                this.destroyProcess();
                throw new TimeoutException(String.format("Managed Domain server was not started within [%d] s", config.getStartupTimeoutInSeconds()));
            }
        }
        catch (Exception e) {
            throw new LifecycleException("Could not start container", (Throwable)e);
        }
    }

    private List<String> createLoggingOptsCmd(List<String> additionalJavaOptsCmd, String jbossHomeDir, String serverBaseDir) {
        String bootLogFileDefaultValue = serverBaseDir + File.separatorChar + LOG_DIR + File.separatorChar + "process-controller.log";
        String loggingConfigurationDefaultValue = serverBaseDir + File.separatorChar + CONFIG_DIR + File.separatorChar + "logging.properties";
        String bootLogFileValue = this.getSystemPropertyValue(additionalJavaOptsCmd, "org.jboss.boot.log.file", ManagedDomainDeployableContainer.getFile(bootLogFileDefaultValue, jbossHomeDir).getAbsolutePath());
        String loggingConfigurationValue = this.getSystemPropertyValue(additionalJavaOptsCmd, "logging.configuration", ManagedDomainDeployableContainer.getFile(loggingConfigurationDefaultValue, jbossHomeDir).toURI().toString());
        ArrayList<String> relativeJavaOptsCmd = new ArrayList<String>();
        relativeJavaOptsCmd.add("-Dorg.jboss.boot.log.file=" + bootLogFileValue);
        relativeJavaOptsCmd.add("-Dlogging.configuration=" + loggingConfigurationValue);
        return relativeJavaOptsCmd;
    }

    private List<String> createAdditionalJavaOptsCmd(ManagedDomainContainerConfiguration config) {
        String additionalJavaOpts = config.getJavaVmArguments();
        ArrayList<String> additionalJavaOptsCmd = new ArrayList<String>();
        if (additionalJavaOpts != null) {
            for (String opt : additionalJavaOpts.split("\\s+")) {
                additionalJavaOptsCmd.add(opt);
            }
        }
        return additionalJavaOptsCmd;
    }

    protected void waitForStart(Domain domain, ManagementClient client) throws LifecycleException {
        this.waitForAutoStartServersToStart(domain, client);
    }

    protected void stopInternal() throws LifecycleException {
        if (this.shutdownThread != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
            this.shutdownThread = null;
        }
        try {
            if (this.process != null) {
                Thread shutdown = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(((ManagedDomainContainerConfiguration)ManagedDomainDeployableContainer.this.getContainerConfiguration()).getStopTimeoutInSeconds() * 1000);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                        if (ManagedDomainDeployableContainer.this.process != null) {
                            ManagedDomainDeployableContainer.this.process.destroy();
                        }
                    }
                });
                shutdown.start();
                ModelNode op = new ModelNode();
                op.get("operation").set("read-attribute");
                op.get("name").set("local-host-name");
                ModelNode result = this.getManagementClient().getControllerClient().execute(op, null);
                String hostName = result.get("result").asString();
                op = new ModelNode();
                op.get("operation").set("shutdown");
                ModelNode address = op.get("address");
                address.add("host", hostName);
                this.getManagementClient().getControllerClient().executeAsync(op, null);
                this.process.waitFor();
                this.process = null;
                shutdown.interrupt();
            }
        }
        catch (Exception e) {
            throw new LifecycleException("Could not stop container", (Throwable)e);
        }
    }

    private List<String> createCommandLine(ManagedDomainContainerConfiguration config, List<String> additionalJavaOptsCmd, List<String> loggingOptsCmd) throws Exception {
        File modulesDir;
        String jbossHomeDir = config.getJbossHome();
        String modulesPath = config.getModulePath();
        if (modulesPath == null || modulesPath.isEmpty()) {
            modulesPath = jbossHomeDir + File.separatorChar + "modules";
        }
        if (!(modulesDir = new File(modulesPath)).isDirectory()) {
            throw new IllegalStateException("Cannot find: " + modulesDir);
        }
        String bundlesPath = modulesDir.getParent() + File.separator + "bundles";
        File bundlesDir = new File(bundlesPath);
        File modulesJar = new File(jbossHomeDir + File.separatorChar + "jboss-modules.jar");
        if (!modulesJar.exists()) {
            throw new IllegalStateException("Cannot find: " + modulesJar);
        }
        ArrayList<String> cmd = new ArrayList<String>();
        String javaExec = config.getJavaHome() + File.separatorChar + "bin" + File.separatorChar + "java";
        if (config.getJavaHome().contains(" ")) {
            javaExec = "\"" + javaExec + "\"";
        }
        cmd.add(javaExec);
        cmd.addAll(additionalJavaOptsCmd);
        if (config.isEnableAssertions()) {
            cmd.add("-ea");
        }
        cmd.add("-Djboss.home.dir=" + jbossHomeDir);
        cmd.addAll(loggingOptsCmd);
        cmd.add("-Djboss.bundles.dir=" + bundlesDir.getCanonicalPath());
        cmd.add("-Djboss.domain.default.config=" + config.getDomainConfig());
        cmd.add("-Djboss.host.default.config=" + config.getHostConfig());
        cmd.add("-jar");
        cmd.add(modulesJar.getAbsolutePath());
        cmd.add("-mp");
        cmd.add(modulesPath);
        cmd.add("org.jboss.as.process-controller");
        cmd.add("-jboss-home");
        cmd.add(jbossHomeDir);
        cmd.add("-jvm");
        cmd.add(javaExec);
        cmd.add("--");
        cmd.addAll(loggingOptsCmd);
        cmd.add("--");
        cmd.add("-default-jvm");
        cmd.add(javaExec);
        return cmd;
    }

    private static boolean processHasDied(Process process) {
        try {
            process.exitValue();
            return true;
        }
        catch (IllegalThreadStateException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isServerRunning() {
        Socket socket = null;
        try {
            socket = new Socket(((ManagedDomainContainerConfiguration)this.getContainerConfiguration()).getManagementAddress(), ((ManagedDomainContainerConfiguration)this.getContainerConfiguration()).getManagementPort());
        }
        catch (Exception ignored) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not close isServerStarted socket", e);
                }
            }
        }
        return true;
    }

    private void failDueToRunning() throws LifecycleException {
        throw new LifecycleException("The server is already running! Managed containers do not support connecting to running server instances due to the possible harmful effect of connecting to the wrong server. Please stop server before running or change to another type of container.\nTo disable this check and allow Arquillian to connect to a running server, set allowConnectingToRunningServer to true in the container configuration");
    }

    private int destroyProcess() {
        if (this.process == null) {
            return 0;
        }
        this.process.destroy();
        try {
            return this.process.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void waitForAutoStartServersToStart(Domain domain, ManagementClient client) {
        long timeout;
        Set servers = domain.getAutoStartServers();
        long startupTimeout = ((ManagedDomainContainerConfiguration)this.getContainerConfiguration()).getAutoServerStartupTimeoutInSeconds();
        long sleep = 100L;
        for (timeout = startupTimeout * 1000L; timeout > 0L && servers.size() > 0; timeout -= sleep) {
            Iterator serverIterator = servers.iterator();
            while (serverIterator.hasNext()) {
                Domain.Server server = (Domain.Server)serverIterator.next();
                if (!client.isServerStarted(server)) continue;
                serverIterator.remove();
            }
            try {
                Thread.sleep(sleep);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Failed waiting for servers to start", e);
            }
        }
        if (timeout <= 0L) {
            throw new RuntimeException("Auto started servers did not start within set timeout [autoServerStartupTimeoutInSeconds=" + startupTimeout + "]. " + servers);
        }
    }

    private void replaceSystemPropertyValue(List<String> cmdArguments, String systemPropertyName, String newValue) {
        String argument = "-D" + systemPropertyName + "=";
        Iterator<String> cmdArgumentsIterator = cmdArguments.iterator();
        while (cmdArgumentsIterator.hasNext()) {
            String cmdArgument = cmdArgumentsIterator.next();
            if (!cmdArgument.startsWith(argument)) continue;
            cmdArgumentsIterator.remove();
        }
        cmdArguments.add(argument + newValue);
    }

    private String getSystemPropertyValue(List<String> cmdArguments, String systemPropertyName, String defaultValue) {
        String argument = "-D" + systemPropertyName + "=";
        for (String cmdArgument : cmdArguments) {
            if (!cmdArgument.startsWith(argument)) continue;
            return cmdArgument.substring(argument.length());
        }
        return defaultValue;
    }

    private static File getFile(String filePathname, String jbossHome) {
        File relative;
        File result = new File(filePathname);
        if (!result.exists() && !result.isAbsolute() && (relative = new File(jbossHome, filePathname)).exists()) {
            result = relative;
        }
        return result;
    }

    static File setupCleanServerDirectories(String serverBaseDir, String jbossHome, String cleanServerBaseDirPath) throws IOException {
        File cleanServerBaseDir = cleanServerBaseDirPath != null ? new File(cleanServerBaseDirPath) : ManagedDomainDeployableContainer.createTempServerBaseDirectory();
        if (!cleanServerBaseDir.exists()) {
            throw ServerMessages.MESSAGES.serverBaseDirectoryDoesNotExist(cleanServerBaseDir);
        }
        if (!cleanServerBaseDir.isDirectory()) {
            throw ServerMessages.MESSAGES.serverBaseDirectoryIsNotADirectory(cleanServerBaseDir);
        }
        ManagedDomainDeployableContainer.copyOriginalDirectoryToCleanServerBaseDir(CONFIG_DIR, serverBaseDir, jbossHome, cleanServerBaseDir);
        ManagedDomainDeployableContainer.copyOriginalDirectoryToCleanServerBaseDir(DATA_DIR, serverBaseDir, jbossHome, cleanServerBaseDir);
        ManagedDomainDeployableContainer.copyOriginalDirectoryToCleanServerBaseDir(SERVERS_DIR, serverBaseDir, jbossHome, cleanServerBaseDir);
        return cleanServerBaseDir;
    }

    private static void copyOriginalDirectoryToCleanServerBaseDir(String originalDirName, String serverBaseDir, String jbossHome, File cleanServerBaseDir) throws IOException {
        File originalDir = ManagedDomainDeployableContainer.getFile(serverBaseDir + File.separatorChar + originalDirName, jbossHome);
        File cleanDir = new File(cleanServerBaseDir, originalDirName);
        cleanDir.mkdir();
        if (originalDir.exists()) {
            ManagedDomainDeployableContainer.copyDirectory(originalDir, cleanDir);
        }
    }

    private static File createTempServerBaseDirectory() throws IOException {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File tempContainer = new File(tempDir, TEMP_CONTAINER_DIRECTORY);
        if (tempContainer.exists()) {
            ManagedDomainDeployableContainer.deleteRecursively(tempContainer);
        }
        if (!tempContainer.mkdir()) {
            throw new IOException("Could not create temp directory: " + tempContainer.getAbsolutePath());
        }
        return tempContainer;
    }

    private static void copyDirectory(File src, File dest) {
        for (String current : src.list()) {
            File srcFile = new File(src, current);
            File destFile = new File(dest, current);
            if (srcFile.isDirectory()) {
                destFile.mkdir();
                ManagedDomainDeployableContainer.copyDirectory(srcFile, destFile);
                continue;
            }
            try {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(srcFile));
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(destFile));
                try {
                    int i;
                    while ((i = ((InputStream)in).read()) != -1) {
                        ((OutputStream)out).write(i);
                    }
                }
                catch (IOException e) {
                    throw ServerMessages.MESSAGES.errorCopyingFile(srcFile.getAbsolutePath(), destFile.getAbsolutePath(), e);
                }
                finally {
                    StreamUtils.safeClose((Closeable)in);
                    StreamUtils.safeClose((Closeable)out);
                }
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void deleteRecursively(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                for (String name : file.list()) {
                    ManagedDomainDeployableContainer.deleteRecursively(new File(file, name));
                }
            }
            file.delete();
        }
    }

    private class ConsoleConsumer
    implements Runnable {
        private ConsoleConsumer() {
        }

        @Override
        public void run() {
            InputStream stream = ManagedDomainDeployableContainer.this.process.getInputStream();
            boolean writeOutput = ((ManagedDomainContainerConfiguration)ManagedDomainDeployableContainer.this.getContainerConfiguration()).isOutputToConsole();
            try {
                int num;
                byte[] buf = new byte[32];
                while ((num = stream.read(buf)) != -1) {
                    if (!writeOutput) continue;
                    System.out.write(buf, 0, num);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

