/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.tools;

import java.util.Collection;
import org.wildfly.swarm.tools.ArtifactResolver;
import org.wildfly.swarm.tools.ArtifactResolvingHelper;
import org.wildfly.swarm.tools.ArtifactSpec;
import org.wildfly.swarm.tools.BuildException;

public class DefaultArtifactResolver
implements ArtifactResolver {
    private ArtifactResolvingHelper resolver;

    public DefaultArtifactResolver(ArtifactResolvingHelper resolver) {
        this.resolver = resolver;
    }

    @Override
    public ArtifactSpec resolveArtifact(ArtifactSpec spec) throws Exception {
        if (spec.file == null) {
            ArtifactSpec newArtifact = this.resolver.resolve(spec);
            if (newArtifact == null) {
                throw new BuildException("Unable to resolve artifact: " + (Object)((Object)spec));
            }
            spec.file = newArtifact.file;
        }
        return spec;
    }

    @Override
    public Collection<ArtifactSpec> resolveAllArtifactsTransitively(Collection<ArtifactSpec> specs, boolean defaultExcludes) throws Exception {
        return this.resolver.resolveAll(specs, true, defaultExcludes);
    }

    @Override
    public Collection<ArtifactSpec> resolveAllArtifactsNonTransitively(Collection<ArtifactSpec> specs) throws Exception {
        return this.resolver.resolveAll(specs, false, false);
    }
}

