/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.cdi;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleLoadException;
import org.jboss.weld.literal.AnyLiteral;
import org.wildfly.swarm.bootstrap.env.ApplicationEnvironment;
import org.wildfly.swarm.bootstrap.performance.Performance;
import org.wildfly.swarm.container.runtime.ConfigurableManager;
import org.wildfly.swarm.container.runtime.cdi.configurable.ConfigurableFractionBean;
import org.wildfly.swarm.spi.api.Fraction;

public class FractionProducingExtension
implements Extension {
    private final List<Fraction> explicitlyInstalledFractions = new ArrayList<Fraction>();
    private final ConfigurableManager configurableManager;

    public FractionProducingExtension(Collection<Fraction> explicitlyInstalled, ConfigurableManager configurableManager) {
        this.explicitlyInstalledFractions.addAll(explicitlyInstalled);
        this.configurableManager = configurableManager;
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager beanManager) throws Exception {
        try (AutoCloseable handle = Performance.time((String)"FractionProducingExtension.afterBeanDiscovery");){
            HashSet<Type> preExistingFractionClasses = new HashSet<Type>();
            try (AutoCloseable pre = Performance.time((String)"FractionProducingExtension.afterBeanDiscovery - pre-existing");){
                for (Fraction fraction : this.explicitlyInstalledFractions) {
                    try {
                        abd.addBean(new ConfigurableFractionBean<Fraction>(fraction, this.configurableManager));
                    }
                    catch (Exception e2) {
                        throw new RuntimeException(e2);
                    }
                    preExistingFractionClasses.add(fraction.getClass());
                }
                Set availableFractionBeans = beanManager.getBeans(Fraction.class, new Annotation[]{AnyLiteral.INSTANCE});
                preExistingFractionClasses.addAll(availableFractionBeans.stream().flatMap(e -> e.getTypes().stream()).collect(Collectors.toSet()));
            }
            Set<Class<? extends Fraction>> fractionClasses = this.uninstalledFractionClasses(preExistingFractionClasses);
            AutoCloseable defaultHandle = Performance.time((String)"FractionProducingExtension.afterBeanDiscovery - default");
            Object object = null;
            try {
                fractionClasses.forEach(cls -> {
                    try {
                        abd.addBean(new ConfigurableFractionBean(cls, this.configurableManager));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (defaultHandle != null) {
                    if (object != null) {
                        try {
                            defaultHandle.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        defaultHandle.close();
                    }
                }
            }
        }
    }

    private Set<Class<? extends Fraction>> uninstalledFractionClasses(Set<Type> installedClasses) throws ModuleLoadException, IOException, ClassNotFoundException {
        Set installedClassNames = installedClasses.stream().map(Type::getTypeName).collect(Collectors.toSet());
        List moduleNames = ApplicationEnvironment.get().bootstrapModules();
        ModuleClassLoader cl = Module.getBootModuleLoader().loadModule("swarm.container").getClassLoader();
        HashSet<Class<? extends Fraction>> fractionClasses = new HashSet<Class<? extends Fraction>>();
        for (String moduleName : moduleNames) {
            Module module = Module.getBootModuleLoader().loadModule(moduleName);
            InputStream indexStream = module.getClassLoader().getResourceAsStream("META-INF/jandex.idx");
            if (indexStream == null) continue;
            IndexReader reader = new IndexReader(indexStream);
            Index index = reader.read();
            Set impls = index.getAllKnownImplementors(DotName.createSimple((String)Fraction.class.getName()));
            for (ClassInfo impl : impls) {
                if (installedClassNames.contains(impl.name().toString())) continue;
                Class<?> fractionClass = cl.loadClass(impl.name().toString());
                fractionClasses.add(fractionClass);
            }
        }
        return fractionClasses;
    }
}

