/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.token;

import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.util.function.Function;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.token.TokenValidator;
import org.wildfly.security.auth.realm.token._private.ElytronMessages;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.BearerTokenEvidence;
import org.wildfly.security.evidence.Evidence;

public final class TokenSecurityRealm
implements SecurityRealm {
    private final TokenValidator strategy;
    private final String principalClaimName;
    private final Function<Attributes, Principal> claimToPrincipal;
    private final Function<Principal, Principal> principalTransformer;

    public static Builder builder() {
        return new Builder();
    }

    TokenSecurityRealm(Builder configuration) {
        Assert.checkNotNullParam((String)"configuration", (Object)configuration);
        this.principalClaimName = configuration.principalClaimName == null ? "username" : configuration.principalClaimName;
        this.claimToPrincipal = configuration.claimToPrincipal == null ? this::defaultClaimToPrincipal : configuration.claimToPrincipal;
        this.principalTransformer = configuration.principalTransformer;
        this.strategy = (TokenValidator)Assert.checkNotNullParam((String)"tokenValidationStrategy", (Object)configuration.strategy);
    }

    @Override
    public RealmIdentity getRealmIdentity(Evidence evidence) {
        return new TokenRealmIdentity(evidence);
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
        return SupportLevel.UNSUPPORTED;
    }

    @Override
    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        if (this.isBearerTokenEvidence(evidenceType)) {
            return SupportLevel.POSSIBLY_SUPPORTED;
        }
        return SupportLevel.UNSUPPORTED;
    }

    private boolean isBearerTokenEvidence(Evidence evidence) {
        return evidence != null && this.isBearerTokenEvidence(evidence.getClass());
    }

    private boolean isBearerTokenEvidence(Class<?> evidenceType) {
        return BearerTokenEvidence.class.equals(evidenceType);
    }

    private Principal defaultClaimToPrincipal(Attributes claims) {
        NamePrincipal principal = null;
        try {
            if (!claims.containsKey(this.principalClaimName)) {
                throw ElytronMessages.log.tokenRealmFailedToObtainPrincipalWithClaim(this.principalClaimName);
            }
            String principalName = claims.getFirst(this.principalClaimName);
            principal = new NamePrincipal(principalName);
        }
        catch (Exception e) {
            throw ElytronMessages.log.tokenRealmFailedToObtainPrincipal(e);
        }
        return principal;
    }

    public static class Builder {
        private String principalClaimName = "username";
        private Function<Attributes, Principal> claimToPrincipal;
        private TokenValidator strategy;
        private Function<Principal, Principal> principalTransformer;

        private Builder() {
        }

        public Builder principalClaimName(String name) {
            this.principalClaimName = name;
            return this;
        }

        public Builder claimToPrincipal(Function<Attributes, Principal> func) {
            this.claimToPrincipal = func;
            return this;
        }

        public Builder validator(TokenValidator strategy) {
            this.strategy = strategy;
            return this;
        }

        public Builder principalTransformer(Function<Principal, Principal> func) {
            this.principalTransformer = func;
            return this;
        }

        public TokenSecurityRealm build() {
            return new TokenSecurityRealm(this);
        }
    }

    final class TokenRealmIdentity
    implements RealmIdentity {
        private final BearerTokenEvidence evidence;
        private Attributes claims;

        TokenRealmIdentity(Evidence evidence) {
            this.evidence = TokenSecurityRealm.this.isBearerTokenEvidence(evidence) ? (BearerTokenEvidence)BearerTokenEvidence.class.cast(evidence) : null;
        }

        @Override
        public Principal getRealmIdentityPrincipal() {
            Principal principal = null;
            try {
                if (this.exists()) {
                    principal = TokenSecurityRealm.this.claimToPrincipal.apply(this.claims);
                    if (TokenSecurityRealm.this.principalTransformer != null) {
                        principal = TokenSecurityRealm.this.principalTransformer.apply(principal);
                    }
                }
            }
            catch (Exception e) {
                throw ElytronMessages.log.tokenRealmFailedToObtainPrincipal(e);
            }
            return principal;
        }

        @Override
        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            return this.validateToken(evidence) != null;
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return this.getClaims() != null;
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
            if (this.exists()) {
                return new AuthorizationIdentity(){

                    @Override
                    public Attributes getAttributes() {
                        return TokenRealmIdentity.this.claims;
                    }
                };
            }
            return null;
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            return null;
        }

        @Override
        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            if (TokenSecurityRealm.this.isBearerTokenEvidence(evidenceType)) {
                return SupportLevel.SUPPORTED;
            }
            return SupportLevel.UNSUPPORTED;
        }

        private void setClaims(Attributes claims) throws RealmUnavailableException {
            this.claims = claims;
        }

        private Attributes getClaims() throws RealmUnavailableException {
            if (this.claims == null) {
                this.validateToken(this.evidence);
            }
            return this.claims;
        }

        private Attributes validateToken(Evidence evidence) throws RealmUnavailableException {
            if (!TokenSecurityRealm.this.isBearerTokenEvidence(evidence)) {
                return null;
            }
            BearerTokenEvidence tokenEvidence = (BearerTokenEvidence)BearerTokenEvidence.class.cast(evidence);
            try {
                this.setClaims(TokenSecurityRealm.this.strategy.validate(tokenEvidence));
                return this.claims;
            }
            catch (RealmUnavailableException rue) {
                throw rue;
            }
            catch (Exception unknown) {
                ElytronMessages.log.debugf((Throwable)unknown, "Failed to validate token evidence [%s]", (Object)tokenEvidence.getToken());
                return null;
            }
        }
    }
}

