/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import java.security.KeyPair;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Map;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jwk.RsaJsonWebKey;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.jose4j.lang.JoseException;
import org.wildfly.security.http.oidc.ClientCredentialsProvider;
import org.wildfly.security.http.oidc.ElytronMessages;
import org.wildfly.security.http.oidc.JWTSigningUtils;
import org.wildfly.security.http.oidc.Oidc;
import org.wildfly.security.http.oidc.OidcClientConfiguration;

public class JWTClientCredentialsProvider
implements ClientCredentialsProvider {
    private KeyPair keyPair;
    private PublicJsonWebKey publicKeyJwk;
    private int tokenTimeout;

    @Override
    public String getId() {
        return Oidc.ClientCredentialsProviderType.JWT.getValue();
    }

    public void setupKeyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
        if (!(keyPair.getPublic() instanceof RSAPublicKey)) {
            throw ElytronMessages.log.unsupportedPublicKey();
        }
        this.publicKeyJwk = new RsaJsonWebKey((RSAPublicKey)keyPair.getPublic());
    }

    public void setTokenTimeout(int tokenTimeout) {
        this.tokenTimeout = tokenTimeout;
    }

    protected int getTokenTimeout() {
        return this.tokenTimeout;
    }

    public PublicKey getPublicKey() {
        return this.keyPair.getPublic();
    }

    @Override
    public void init(OidcClientConfiguration oidcClientConfiguration, Object credentialsConfig) {
        String clientKeyAlias;
        String clientKeyStorePassword;
        if (!(credentialsConfig instanceof Map)) {
            throw ElytronMessages.log.invalidJwtClientCredentialsConfig(oidcClientConfiguration.getResourceName());
        }
        Map cfg = (Map)credentialsConfig;
        String clientKeyStoreFile = (String)cfg.get("client-keystore-file");
        if (clientKeyStoreFile == null) {
            throw ElytronMessages.log.missingParameterInJwtClientCredentialsConfig("client-keystore-file", oidcClientConfiguration.getResourceName());
        }
        String clientKeyStoreType = (String)cfg.get("client-keystore-type");
        if (clientKeyStoreType == null) {
            clientKeyStoreFile = "JKS";
        }
        if ((clientKeyStorePassword = (String)cfg.get("client-keystore-password")) == null) {
            throw ElytronMessages.log.missingParameterInJwtClientCredentialsConfig("client-keystore-password", oidcClientConfiguration.getResourceName());
        }
        String clientKeyPassword = (String)cfg.get("client-key-password");
        if (clientKeyPassword == null) {
            clientKeyPassword = clientKeyStorePassword;
        }
        if ((clientKeyAlias = (String)cfg.get("client-key-alias")) == null) {
            clientKeyAlias = oidcClientConfiguration.getResourceName();
        }
        KeyPair keyPair = JWTSigningUtils.loadKeyPairFromKeyStore(clientKeyStoreFile, clientKeyStorePassword, clientKeyPassword, clientKeyAlias, clientKeyStoreType);
        this.setupKeyPair(keyPair);
        this.tokenTimeout = Oidc.asInt(cfg, "token-timeout", 10);
    }

    @Override
    public void setClientCredentials(OidcClientConfiguration oidcClientConfiguration, Map<String, String> requestHeaders, Map<String, String> formParams) {
        String signedToken = this.createSignedRequestToken(oidcClientConfiguration.getResourceName(), oidcClientConfiguration.getTokenUrl());
        formParams.put("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
        formParams.put("client_assertion", signedToken);
    }

    public String createSignedRequestToken(String clientId, String tokenUrl) {
        JwtClaims jwtClaims = this.createRequestToken(clientId, tokenUrl);
        JsonWebSignature jws = new JsonWebSignature();
        jws.setKeyIdHeaderValue(this.publicKeyJwk.getKeyId());
        jws.setKey(this.keyPair.getPrivate());
        jws.setAlgorithmHeaderValue("RS256");
        jws.setPayload(jwtClaims.toJson());
        try {
            return jws.getCompactSerialization();
        }
        catch (JoseException e) {
            throw ElytronMessages.log.unableToCreateSignedToken();
        }
    }

    protected JwtClaims createRequestToken(String clientId, String tokenUrl) {
        JwtClaims jwtClaims = new JwtClaims();
        jwtClaims.setJwtId(Oidc.generateId());
        jwtClaims.setIssuer(clientId);
        jwtClaims.setSubject(clientId);
        jwtClaims.setAudience(tokenUrl);
        NumericDate now = NumericDate.now();
        jwtClaims.setIssuedAt(now);
        jwtClaims.setNotBefore(now);
        NumericDate exp = NumericDate.fromSeconds(now.getValue() + (long)this.tokenTimeout);
        jwtClaims.setExpirationTime(exp);
        return jwtClaims;
    }
}

