/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client._private;

import java.io.IOException;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamReader;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.client.config.ConfigurationXMLStreamReader;
import org.wildfly.client.config.XMLLocation;
import org.wildfly.security.auth.client._private.ElytronMessages;

public class ElytronMessages_$logger
extends DelegatingBasicLogger
implements ElytronMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ElytronMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String xmlNoModuleFound$str() {
        return "ELY01001: No module found for identifier \"%s\"";
    }

    @Override
    public final ConfigXMLParseException xmlNoModuleFound(XMLStreamReader reader, Exception e, String moduleIdentifier) {
        ConfigXMLParseException result = new ConfigXMLParseException(String.format(this.getLoggingLocale(), this.xmlNoModuleFound$str(), moduleIdentifier), reader, (Throwable)e);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String xmlInvalidPortNumber$str() {
        return "ELY01002: Invalid port number \"%s\" specified for attribute \"%s\" of element \"%s\"; expected a numerical value between 1 and 65535 (inclusive)";
    }

    @Override
    public final ConfigXMLParseException xmlInvalidPortNumber(XMLStreamReader reader, String attributeValue, String attributeName, QName elementName) {
        ConfigXMLParseException result = new ConfigXMLParseException(String.format(this.getLoggingLocale(), this.xmlInvalidPortNumber$str(), attributeValue, attributeName, elementName), reader);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidPortNumber$str() {
        return "ELY01028: Invalid port number \"%d\"";
    }

    @Override
    public final IllegalArgumentException invalidPortNumber(int port) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidPortNumber$str(), port));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidHostSpec$str() {
        return "ELY01029: Invalid host specification \"%s\"";
    }

    @Override
    public final IllegalArgumentException invalidHostSpec(String hostSpec) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidHostSpec$str(), hostSpec));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToCreateKeyManager$str() {
        return "ELY01035: Unable to create key manager";
    }

    @Override
    public final IOException unableToCreateKeyManager(Exception e) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.unableToCreateKeyManager$str(), new Object[0]), e);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToCreateTrustManager$str() {
        return "ELY01036: Unable to create trust manager";
    }

    @Override
    public final IOException unableToCreateTrustManager(Exception e) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.unableToCreateTrustManager$str(), new Object[0]), e);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotObtainCredential$str() {
        return "ELY01041: Could not obtain credential";
    }

    @Override
    public final RuntimeException couldNotObtainCredential() {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.couldNotObtainCredential$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidName$str() {
        return "ELY01064: Invalid identity name";
    }

    @Override
    public final IllegalArgumentException invalidName() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidName$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void postAssociationFailed(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.postAssociationFailed$str(), new Object[0]);
    }

    protected String postAssociationFailed$str() {
        return "ELY01091: Post-association peer context action failed";
    }

    protected String xmlUnknownSslContextSpecified$str() {
        return "ELY01129: Unknown SSL context \"%s\" specified";
    }

    @Override
    public final ConfigXMLParseException xmlUnknownSslContextSpecified(Location location, String name) {
        ConfigXMLParseException result = new ConfigXMLParseException(String.format(this.getLoggingLocale(), this.xmlUnknownSslContextSpecified$str(), name), location);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String xmlDuplicateSslContextName$str() {
        return "ELY01130: Duplicate SSL context name \"%s\"";
    }

    @Override
    public final ConfigXMLParseException xmlDuplicateSslContextName(String name, ConfigurationXMLStreamReader reader) {
        ConfigXMLParseException result = new ConfigXMLParseException(String.format(this.getLoggingLocale(), this.xmlDuplicateSslContextName$str(), name), (XMLStreamReader)reader);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String xmlUnknownAuthenticationConfigurationSpecified$str() {
        return "ELY01132: Unknown authentication configuration \"%s\" specified";
    }

    @Override
    public final ConfigXMLParseException xmlUnknownAuthenticationConfigurationSpecified(Location location, String name) {
        ConfigXMLParseException result = new ConfigXMLParseException(String.format(this.getLoggingLocale(), this.xmlUnknownAuthenticationConfigurationSpecified$str(), name), location);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String xmlFailedToCreateCredential$str() {
        return "ELY01133: Failed to create credential";
    }

    @Override
    public final ConfigXMLParseException xmlFailedToCreateCredential(Location location, Throwable cause) {
        ConfigXMLParseException result = new ConfigXMLParseException(String.format(this.getLoggingLocale(), this.xmlFailedToCreateCredential$str(), new Object[0]), location, cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String xmlDuplicateAuthenticationConfigurationName$str() {
        return "ELY01134: Duplicate authentication configuration name \"%s\"";
    }

    @Override
    public final ConfigXMLParseException xmlDuplicateAuthenticationConfigurationName(String name, ConfigurationXMLStreamReader reader) {
        ConfigXMLParseException result = new ConfigXMLParseException(String.format(this.getLoggingLocale(), this.xmlDuplicateAuthenticationConfigurationName$str(), name), (XMLStreamReader)reader);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String xmlFailedToLoadKeyStoreData$str() {
        return "ELY01135: Failed to load keystore data";
    }

    @Override
    public final ConfigXMLParseException xmlFailedToLoadKeyStoreData(Location location, Throwable cause) {
        ConfigXMLParseException result = new ConfigXMLParseException(String.format(this.getLoggingLocale(), this.xmlFailedToLoadKeyStoreData$str(), new Object[0]), location, cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String xmlFailedToCreateKeyStore$str() {
        return "ELY01136: Failed to create keystore";
    }

    @Override
    public final ConfigXMLParseException xmlFailedToCreateKeyStore(Location location, Throwable cause) {
        ConfigXMLParseException result = new ConfigXMLParseException(String.format(this.getLoggingLocale(), this.xmlFailedToCreateKeyStore$str(), new Object[0]), location, cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String xmlInvalidKeyStoreEntryType$str() {
        return "ELY01137: Invalid key store entry type for alias \"%s\" (expected %s, got %s)";
    }

    @Override
    public final ConfigXMLParseException xmlInvalidKeyStoreEntryType(Location location, String alias, Class<?> expectedClass, Class<?> actualClass) {
        ConfigXMLParseException result = new ConfigXMLParseException(String.format(this.getLoggingLocale(), this.xmlInvalidKeyStoreEntryType$str(), alias, expectedClass, actualClass), location);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void noKeystorePasswordSpecified(Location location) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.noKeystorePasswordSpecified$str(), (Object)location);
    }

    protected String noKeystorePasswordSpecified$str() {
        return "ELY01138: No Keystore password specified \"%s\"";
    }

    protected String xmlFailedToCreateCredentialStore$str() {
        return "ELY01139: Failed to create credential store";
    }

    @Override
    public final ConfigXMLParseException xmlFailedToCreateCredentialStore(Location location, Throwable cause) {
        ConfigXMLParseException result = new ConfigXMLParseException(String.format(this.getLoggingLocale(), this.xmlFailedToCreateCredentialStore$str(), new Object[0]), location, cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String xmlWrongPemType$str() {
        return "ELY01140: Wrong PEM content type; expected %s, actually was %s";
    }

    @Override
    public final ConfigXMLParseException xmlWrongPemType(ConfigurationXMLStreamReader reader, Class<?> expected, Class<?> actual) {
        ConfigXMLParseException result = new ConfigXMLParseException(String.format(this.getLoggingLocale(), this.xmlWrongPemType$str(), expected, actual), (XMLStreamReader)reader);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String xmlNoPemContent$str() {
        return "ELY01141: No PEM content found";
    }

    @Override
    public final ConfigXMLParseException xmlNoPemContent(ConfigurationXMLStreamReader reader) {
        ConfigXMLParseException result = new ConfigXMLParseException(String.format(this.getLoggingLocale(), this.xmlNoPemContent$str(), new Object[0]), (XMLStreamReader)reader);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String xmlInvalidUrl$str() {
        return "ELY01143: Invalid URL [%s]";
    }

    @Override
    public final ConfigXMLParseException xmlInvalidUrl(String url) {
        ConfigXMLParseException result = new ConfigXMLParseException(String.format(this.getLoggingLocale(), this.xmlInvalidUrl$str(), url));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String keyStoreEntryMissing$str() {
        return "ELY01159: Key store entry for alias \"%s\" is missing.";
    }

    @Override
    public final ConfigXMLParseException keyStoreEntryMissing(Location location, String alias) {
        ConfigXMLParseException result = new ConfigXMLParseException(String.format(this.getLoggingLocale(), this.keyStoreEntryMissing$str(), alias), location);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String xmlInvalidGssMechanismName$str() {
        return "ELY01162: Invalid GSS mechanism name \"%s\" - unable to convert to mechanism OID";
    }

    @Override
    public final ConfigXMLParseException xmlInvalidGssMechanismName(XMLStreamReader reader, String mechanismName) {
        ConfigXMLParseException result = new ConfigXMLParseException(String.format(this.getLoggingLocale(), this.xmlInvalidGssMechanismName$str(), mechanismName), reader);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String xmlGssMechanismOidConversionFailed$str() {
        return "ELY01163: Mechanism OID conversion from string \"%s\" failed";
    }

    @Override
    public final ConfigXMLParseException xmlGssMechanismOidConversionFailed(XMLStreamReader reader, String mechanismOid, Throwable cause) {
        ConfigXMLParseException result = new ConfigXMLParseException(String.format(this.getLoggingLocale(), this.xmlGssMechanismOidConversionFailed$str(), mechanismOid), reader, cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String xmlUnableToIdentifyProvider$str() {
        return "ELY01164: Unable to identify provider name=%s, for service type=%s, algorithm=%s";
    }

    @Override
    public final ConfigXMLParseException xmlUnableToIdentifyProvider(Location location, String providerName, String serviceType, String algorithm) {
        ConfigXMLParseException result = new ConfigXMLParseException(String.format(this.getLoggingLocale(), this.xmlUnableToIdentifyProvider$str(), providerName, serviceType, algorithm), location);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void xmlDeprecatedElement(String name, XMLLocation location) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.xmlDeprecatedElement$str(), (Object)name, (Object)location);
    }

    protected String xmlDeprecatedElement$str() {
        return "ELY01166: %2$s: Element \"%1$s\" is deprecated";
    }

    protected String missingAlias$str() {
        return "ELY02034: Alias must be specified if more than one entry exist in keystore";
    }

    @Override
    public final ConfigXMLParseException missingAlias(Location location) {
        ConfigXMLParseException result = new ConfigXMLParseException(String.format(this.getLoggingLocale(), this.missingAlias$str(), new Object[0]), location);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String xmlUnknownKeyStoreSpecified$str() {
        return "ELY02010: Unknown key store specified";
    }

    @Override
    public final ConfigXMLParseException xmlUnknownKeyStoreSpecified(Location location) {
        ConfigXMLParseException result = new ConfigXMLParseException(String.format(this.getLoggingLocale(), this.xmlUnknownKeyStoreSpecified$str(), new Object[0]), location);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noDefaultTrustManager$str() {
        return "ELY04005: No default trust manager available";
    }

    @Override
    public final NoSuchAlgorithmException noDefaultTrustManager() {
        NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(this.getLoggingLocale(), this.noDefaultTrustManager$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noDefaultKeyManager$str() {
        return "ELY04028: No default key manager available";
    }

    @Override
    public final NoSuchAlgorithmException noDefaultKeyManager() {
        NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(this.getLoggingLocale(), this.noDefaultKeyManager$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateAttributeFound$str() {
        return "ELY09501: Duplicate attribute (\"%s\") found in configuration.";
    }

    @Override
    public final ConfigXMLParseException duplicateAttributeFound(XMLStreamReader reader, String attribute) {
        ConfigXMLParseException result = new ConfigXMLParseException(String.format(this.getLoggingLocale(), this.duplicateAttributeFound$str(), attribute), reader);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateCredentialStoreName$str() {
        return "ELY09502: Duplicate credential store name found in configuration \"%s\"";
    }

    @Override
    public final ConfigXMLParseException duplicateCredentialStoreName(XMLStreamReader reader, String storeName) {
        ConfigXMLParseException result = new ConfigXMLParseException(String.format(this.getLoggingLocale(), this.duplicateCredentialStoreName$str(), storeName), reader);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String xmlCredentialStoreNameNotDefined$str() {
        return "ELY09503: Credential store name \"%s\" not defined";
    }

    @Override
    public final ConfigXMLParseException xmlCredentialStoreNameNotDefined(Location location, String storeName) {
        ConfigXMLParseException result = new ConfigXMLParseException(String.format(this.getLoggingLocale(), this.xmlCredentialStoreNameNotDefined$str(), storeName), location);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String xmlInvalidCredentialStoreRef$str() {
        return "ELY09527: Invalid credential store reference";
    }

    @Override
    public final ConfigXMLParseException xmlInvalidCredentialStoreRef(Location location) {
        ConfigXMLParseException result = new ConfigXMLParseException(String.format(this.getLoggingLocale(), this.xmlInvalidCredentialStoreRef$str(), new Object[0]), location);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String xmlUnsupportedAlgorithmForType$str() {
        return "ELY09529: Unsupported algorithm \"%s\" for %s type";
    }

    @Override
    public final ConfigXMLParseException xmlUnsupportedAlgorithmForType(Location location, String algorithm, String type) {
        ConfigXMLParseException result = new ConfigXMLParseException(String.format(this.getLoggingLocale(), this.xmlUnsupportedAlgorithmForType$str(), algorithm, type), location);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String atLeastOneCipherSuiteAttributeMustBeProvided$str() {
        return "ELY14000: At least one of the '%s' and '%s' cipher-suite attributes must be provided";
    }

    @Override
    public final ConfigXMLParseException atLeastOneCipherSuiteAttributeMustBeProvided(String attribute1, String attribute2) {
        ConfigXMLParseException result = new ConfigXMLParseException(String.format(this.getLoggingLocale(), this.atLeastOneCipherSuiteAttributeMustBeProvided$str(), attribute1, attribute2));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String xmlInvalidOpenSSHKey$str() {
        return "ELY14001: Wrong Key content type; expected OpenSSH private key";
    }

    @Override
    public final ConfigXMLParseException xmlInvalidOpenSSHKey(ConfigurationXMLStreamReader reader) {
        ConfigXMLParseException result = new ConfigXMLParseException(String.format(this.getLoggingLocale(), this.xmlInvalidOpenSSHKey$str(), new Object[0]), (XMLStreamReader)reader);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToObtainSslContext$str() {
        return "ELY14002: Unable to obtain SSLContext";
    }

    @Override
    public final ConfigXMLParseException unableToObtainSslContext() {
        ConfigXMLParseException result = new ConfigXMLParseException(String.format(this.getLoggingLocale(), this.unableToObtainSslContext$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nameCallbackHandlingWasUnsuccessful$str() {
        return "ELY14003: Name callback handling was unsuccessful";
    }

    @Override
    public final ConfigXMLParseException nameCallbackHandlingWasUnsuccessful() {
        ConfigXMLParseException result = new ConfigXMLParseException(String.format(this.getLoggingLocale(), this.nameCallbackHandlingWasUnsuccessful$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String passwordCallbackHandlingWasUnsuccessful$str() {
        return "ELY14004: Password callback handling was unsuccessful";
    }

    @Override
    public final ConfigXMLParseException passwordCallbackHandlingWasUnsuccessful() {
        ConfigXMLParseException result = new ConfigXMLParseException(String.format(this.getLoggingLocale(), this.passwordCallbackHandlingWasUnsuccessful$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String sslContextForSecurityProviderCreatesInfiniteLoop$str() {
        return "ELY14005: Default SSL context in security provider creates infinite loop";
    }

    @Override
    public final NoSuchAlgorithmException sslContextForSecurityProviderCreatesInfiniteLoop() {
        NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(this.getLoggingLocale(), this.sslContextForSecurityProviderCreatesInfiniteLoop$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String clientConfigurationFileNotFound$str() {
        return "ELY14006: Configuration file path passed to WildFlyElytronClientDefaultSSLContextProvider not found";
    }

    @Override
    public final IllegalArgumentException clientConfigurationFileNotFound() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.clientConfigurationFileNotFound$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String clientConfigurationFileNotValid$str() {
        return "ELY14007: Invalid path passed to WildFlyElytronClientDefaultSSLContextProvider";
    }

    @Override
    public final IllegalArgumentException clientConfigurationFileNotValid() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.clientConfigurationFileNotValid$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotObtainClientDefaultSSLContext$str() {
        return "ELY14008: WildFlyElytronClientDefaultSSLContextProvider could not obtain client default SSLContext";
    }

    @Override
    public final NoSuchAlgorithmException couldNotObtainClientDefaultSSLContext() {
        NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(this.getLoggingLocale(), this.couldNotObtainClientDefaultSSLContext$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

