/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.audit;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.wildfly.common.Assert;
import org.wildfly.security.audit.AuditEndpoint;
import org.wildfly.security.audit.ElytronMessages;
import org.wildfly.security.audit.FileAuditEndpoint;

public class SizeRotatingFileAuditEndpoint
extends FileAuditEndpoint {
    private final long rotateSize;
    private final int maxBackupIndex;
    private final boolean rotateOnBoot;
    private long currentSize = 0L;
    private final String suffix;
    private final DateTimeFormatter dateTimeFormatter;

    SizeRotatingFileAuditEndpoint(Builder builder) throws IOException {
        super(builder);
        this.rotateSize = builder.rotateSize;
        this.maxBackupIndex = builder.maxBackupIndex;
        this.rotateOnBoot = builder.rotateOnBoot;
        this.suffix = builder.suffix;
        this.dateTimeFormatter = this.suffix != null ? DateTimeFormatter.ofPattern(this.suffix).withZone(builder.timeZone) : null;
        File file = this.getFile();
        if (this.rotateOnBoot && this.maxBackupIndex > 0 && file != null && file.exists() && file.length() > 0L) {
            this.rotate(file);
        }
    }

    @Override
    protected void write(String toWrite) throws IOException {
        super.write(toWrite);
        this.currentSize += (long)toWrite.getBytes().length;
    }

    @Override
    protected void preWrite(Instant instant) {
        if (this.currentSize > this.rotateSize && this.maxBackupIndex > 0) {
            try {
                File file = this.getFile();
                if (file == null) {
                    return;
                }
                this.rotate(file);
                this.currentSize = 0L;
            }
            catch (IOException e) {
                ElytronMessages.audit.unableToRotateLogFile(e);
            }
        }
    }

    private void rotate(File file) throws IOException {
        this.closeStreams();
        String suffix = this.dateTimeFormatter != null ? this.dateTimeFormatter.format(ZonedDateTime.now(this.clock)) : "";
        Path fileWithSuffix = Paths.get(file.getAbsolutePath() + suffix, new String[0]);
        Files.deleteIfExists(Paths.get(fileWithSuffix + "." + this.maxBackupIndex, new String[0]));
        for (int i = this.maxBackupIndex - 1; i >= 1; --i) {
            Path src = Paths.get(fileWithSuffix + "." + i, new String[0]);
            if (!Files.exists(src, new LinkOption[0])) continue;
            Path target = Paths.get(fileWithSuffix + "." + (i + 1), new String[0]);
            Files.move(src, target, StandardCopyOption.REPLACE_EXISTING);
        }
        Files.move(file.toPath(), Paths.get(fileWithSuffix + ".1", new String[0]), StandardCopyOption.REPLACE_EXISTING);
        this.setFile(file);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends FileAuditEndpoint.Builder {
        private long rotateSize = 655360L;
        private int maxBackupIndex = 1;
        private boolean rotateOnBoot;
        private String suffix;
        ZoneId timeZone = ZoneId.systemDefault();

        Builder() {
        }

        public Builder setRotateSize(long rotateSize) {
            this.rotateSize = rotateSize;
            return this;
        }

        public Builder setSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public Builder setMaxBackupIndex(int maxBackupIndex) {
            this.maxBackupIndex = maxBackupIndex;
            return this;
        }

        public Builder setRotateOnBoot(boolean rotateOnBoot) {
            this.rotateOnBoot = rotateOnBoot;
            return this;
        }

        public Builder setTimeZone(ZoneId timeZone) {
            this.timeZone = (ZoneId)Assert.checkNotNullParam((String)"timeZone", (Object)timeZone);
            return this;
        }

        @Override
        public AuditEndpoint build() throws IOException {
            return new SizeRotatingFileAuditEndpoint(this);
        }
    }
}

