/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.Security;
import java.security.URIParameter;
import java.security.spec.AlgorithmParameterSpec;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.ElytronMessages;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;

public class JaasSecurityRealm
implements SecurityRealm {
    private static final String DEFAULT_CONFIGURATION_POLICY_TYPE = "JavaLoginConfig";
    private final URI jaasConfigFilePath;
    private final String entry;
    private final CallbackHandler handler;
    private final ClassLoader classLoader;

    public JaasSecurityRealm(String entry) {
        this(entry, (String)null);
    }

    public JaasSecurityRealm(String entry, ClassLoader classLoader) {
        this(entry, null, classLoader);
    }

    public JaasSecurityRealm(String entry, String jaasConfigFilePath) {
        this(entry, jaasConfigFilePath, null);
    }

    public JaasSecurityRealm(String entry, String jaasConfigFilePath, ClassLoader classLoader) {
        this(entry, jaasConfigFilePath, classLoader, null);
    }

    public JaasSecurityRealm(String entry, String jaasConfigFilePath, ClassLoader classLoader, CallbackHandler callbackHandler) {
        Assert.checkNotNullParam((String)"entry", (Object)entry);
        this.jaasConfigFilePath = jaasConfigFilePath != null ? Paths.get(jaasConfigFilePath, new String[0]).toUri() : null;
        this.entry = entry;
        this.handler = callbackHandler;
        this.classLoader = classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
    }

    @Override
    public RealmIdentity getRealmIdentity(Principal principal) {
        if (principal instanceof NamePrincipal) {
            return new JaasRealmIdentity(principal);
        }
        NamePrincipal namePrincipal = NamePrincipal.from(principal);
        return namePrincipal != null ? new JaasRealmIdentity(namePrincipal) : RealmIdentity.NON_EXISTENT;
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"credentialType", credentialType);
        return SupportLevel.UNSUPPORTED;
    }

    @Override
    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"evidenceType", evidenceType);
        return SupportLevel.POSSIBLY_SUPPORTED;
    }

    private static class JaasAuthorizationIdentity
    implements AuthorizationIdentity {
        private MapAttributes attributes;

        private static JaasAuthorizationIdentity fromSubject(Subject subject) {
            MapAttributes attributes = new MapAttributes();
            if (subject != null) {
                for (Principal principal : subject.getPrincipals()) {
                    attributes.addLast(principal.getClass().getSimpleName(), principal.getName());
                }
            }
            return new JaasAuthorizationIdentity(attributes);
        }

        private JaasAuthorizationIdentity(MapAttributes attributes) {
            this.attributes = attributes;
        }

        @Override
        public Attributes getAttributes() {
            return this.attributes;
        }
    }

    private static class JaasSecurityRealmDefaultCallbackHandler
    implements CallbackHandler {
        private final Principal principal;
        private final Object evidence;

        private JaasSecurityRealmDefaultCallbackHandler(Principal principal, Evidence evidence) {
            this.principal = principal;
            this.evidence = evidence;
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            Assert.checkNotNullParam((String)"callbacks", (Object)callbacks);
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callback;
                    if (this.principal == null) continue;
                    nc.setName(this.principal.getName());
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    if (this.evidence instanceof PasswordGuessEvidence) {
                        ((PasswordCallback)callback).setPassword(((PasswordGuessEvidence)this.evidence).getGuess());
                        continue;
                    }
                    PasswordCallback pc = (PasswordCallback)callback;
                    char[] password = this.getPassword();
                    if (password == null) continue;
                    pc.setPassword(password);
                    continue;
                }
                if (callback instanceof CredentialCallback && this.evidence instanceof Credential) {
                    CredentialCallback credentialCallback = (CredentialCallback)callback;
                    Credential credential = (Credential)this.evidence;
                    if (!credentialCallback.isCredentialSupported(credential)) continue;
                    credentialCallback.setCredential(credential);
                    continue;
                }
                throw ElytronMessages.log.unableToHandleCallback(callback, this.getClass().getName(), callback.getClass().getCanonicalName());
            }
        }

        private char[] getPassword() {
            char[] password;
            block6: {
                password = null;
                if (this.evidence instanceof char[]) {
                    password = (char[])this.evidence;
                } else if (this.evidence instanceof String) {
                    String s = (String)this.evidence;
                    password = s.toCharArray();
                } else {
                    try {
                        Class[] types = new Class[]{};
                        Method m = this.evidence.getClass().getMethod("toCharArray", types);
                        Object[] args = new Object[]{};
                        password = (char[])m.invoke(this.evidence, args);
                    }
                    catch (Exception e) {
                        if (this.evidence == null) break block6;
                        String s = this.evidence.toString();
                        password = s.toCharArray();
                    }
                }
            }
            return password;
        }
    }

    private class JaasRealmIdentity
    implements RealmIdentity {
        private final Principal principal;
        private LoginContext loginContext;
        private Subject subject;

        private JaasRealmIdentity(Principal principal) {
            this.principal = principal;
        }

        @Override
        public Principal getRealmIdentityPrincipal() {
            return this.principal;
        }

        public Subject getSubject() {
            return this.subject;
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            return JaasSecurityRealm.this.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            return this.getCredential(credentialType, null);
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
            return this.getCredential(credentialType, algorithmName, null);
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            return null;
        }

        @Override
        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"evidenceType", evidenceType);
            return JaasSecurityRealm.this.getEvidenceVerifySupport(evidenceType, algorithmName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            boolean successfulLogin;
            Assert.checkNotNullParam((String)"evidence", (Object)evidence);
            this.subject = null;
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                if (JaasSecurityRealm.this.classLoader != null) {
                    Thread.currentThread().setContextClassLoader(JaasSecurityRealm.this.classLoader);
                }
                CallbackHandler callbackHandler = this.createCallbackHandler(this.principal, evidence);
                Subject subject = new Subject();
                this.loginContext = this.createLoginContext(JaasSecurityRealm.this.entry, subject, callbackHandler);
                ElytronMessages.log.tracef("Trying to authenticate subject %s using LoginContext %s using JaasSecurityRealm", (Object)this.principal, (Object)this.loginContext);
                try {
                    this.loginContext.login();
                    successfulLogin = true;
                    this.subject = this.loginContext.getSubject();
                }
                catch (LoginException loginException) {
                    successfulLogin = false;
                    ElytronMessages.log.debugInfoJaasAuthenticationFailure(this.principal, loginException);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
            return successfulLogin;
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
            return JaasAuthorizationIdentity.fromSubject(this.subject);
        }

        @Override
        public void dispose() {
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    if (JaasSecurityRealm.this.classLoader != null) {
                        Thread.currentThread().setContextClassLoader(JaasSecurityRealm.this.classLoader);
                    }
                    if (this.loginContext != null) {
                        this.loginContext.logout();
                    }
                }
                catch (LoginException e) {
                    ElytronMessages.log.debugInfoJaasLogoutFailure(this.principal, e);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }

        private LoginContext createLoginContext(String entry, Subject subject, CallbackHandler callbackHandler) throws RealmUnavailableException {
            File file;
            if (JaasSecurityRealm.this.jaasConfigFilePath != null && !(file = new File(JaasSecurityRealm.this.jaasConfigFilePath)).exists() && !file.isDirectory()) {
                throw ElytronMessages.log.failedToLoadJaasConfigFile();
            }
            try {
                if (JaasSecurityRealm.this.jaasConfigFilePath == null) {
                    return new LoginContext(entry, subject, callbackHandler);
                }
                return new LoginContext(entry, subject, callbackHandler, Configuration.getInstance(JaasSecurityRealm.DEFAULT_CONFIGURATION_POLICY_TYPE, new URIParameter(JaasSecurityRealm.this.jaasConfigFilePath)));
            }
            catch (NoSuchAlgorithmException | LoginException le) {
                throw ElytronMessages.log.failedToCreateLoginContext(le);
            }
        }

        private CallbackHandler createCallbackHandler(Principal principal, Evidence evidence) {
            if (JaasSecurityRealm.this.handler != null) {
                try {
                    CallbackHandler callbackHandler = (CallbackHandler)JaasSecurityRealm.this.handler.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                    Method setSecurityInfo = JaasSecurityRealm.this.handler.getClass().getMethod("setSecurityInfo", Principal.class, Object.class);
                    setSecurityInfo.invoke((Object)callbackHandler, principal, evidence);
                    return callbackHandler;
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    return JaasSecurityRealm.this.handler;
                }
            }
            if (Security.getProperty("auth.login.defaultCallbackHandler") != null) {
                return null;
            }
            return new JaasSecurityRealmDefaultCallbackHandler(principal, evidence);
        }
    }
}

