/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500.cert.acme;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.security.x500.cert.acme.AcmeException;
import org.wildfly.security.x500.cert.acme.ElytronMessages;

public class ElytronMessages_$logger
extends DelegatingBasicLogger
implements ElytronMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String unableToDetermineKeySize = "ELY10016: Unable to determine key size";
    private static final String unableToDetermineDefaultCompatibleSignatureAlgorithmName = "ELY10019: Unable to determine default compatible signature algorithm name for key algorithm name \"%s\"";
    private static final String acmeAccountKeyPairGenerationFailed = "ELY10029: Failed to generate ACME account key pair";
    private static final String noAcmeServerUrlGiven = "ELY10030: No ACME server URL given";
    private static final String unsupportedAcmeAccountSignatureAlgorithm = "ELY10031: Unsupported ACME account signature algorithm \"%s\"";
    private static final String unableToCreateAcmeSignature = "ELY10032: Unable to create ACME signature";
    private static final String unableToRetrieveAcmeServerDirectoryUrls = "ELY10033: Unable to retrieve ACME server directory URLs";
    private static final String noNonceProvidedByAcmeServer = "ELY10034: No nonce provided by ACME server";
    private static final String noAccountLocationUrlProvidedByAcmeServer = "ELY10035: No account location URL provided by ACME server";
    private static final String unableToObtainNewNonceFromAcmeServer = "ELY10036: Unable to obtain new nonce from ACME server";
    private static final String unableToObtainJsonResponseFromAcmeServer = "ELY10037: Unable to obtain JSON response from ACME server";
    private static final String unexpectedResponseCodeFromAcmeServer = "ELY10038: Unexpected HTTP status code in response from ACME server \"%d\": \"%s\"";
    private static final String badAcmeNonce = "ELY10039: Bad ACME replay nonce, maximum retries attempted";
    private static final String unexpectedContentTypeFromAcmeServer = "ELY10040: Unexpected content type in response from ACME server \"%s\"";
    private static final String invalidContentTypeFromAcmeServer = "ELY10041: Invalid content type in response from ACME server";
    private static final String domainNameIsNull = "ELY10042: Domain name is null";
    private static final String domainNamesIsEmpty = "ELY10043: Domain names is empty";
    private static final String noCertificateUrlProvidedByAcmeServer = "ELY10044: No certificate URL provided by ACME server";
    private static final String noCertificateWillBeIssuedByAcmeServer = "ELY10045: No certificate will be issued by the ACME server";
    private static final String unableToGetEncodedFormOfCertificateToBeRevoked = "ELY10046: Unable to get encoded form of certificate to be revoked";
    private static final String unableToDetermineKeyAuthorizationString = "ELY10047: Unable to determine key authorization string";
    private static final String challengeResponseFailedValidationByAcmeServer = "ELY10048: Challenge response failed validation by the ACME server";
    private static final String unableToDownloadCertificateChainFromAcmeServer = "ELY10049: Unable to download certificate chain from ACME server";
    private static final String acmeAccountDoesNotExist = "ELY10050: ACME account does not exist";
    private static final String userActionRequired = "ELY10051: User action required since the ACME server's terms of service have changed, visit \"%s\" for details";
    private static final String rateLimitExceededTryAgainLater = "ELY10052: Rate limit has been exceeded, try again after \"%s\"";
    private static final String rateLimitExceeded = "ELY10053: Rate limit has been exceeded";
    private static final String resourceNotSupportedByAcmeServer = "ELY10054: Resource not supported by the ACME server \"%s\"";
    private static final String unsupportedAcmeAccountPublicKeyType = "ELY10055: Unsupported ACME account public key type \"%s\"";
    private static final String unableToDetermineCurveParameterFromAlgHeader = "ELY10056: Unable to determine curve parameter from alg header \"%s\"";

    public ElytronMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String unableToDetermineKeySize$str() {
        return unableToDetermineKeySize;
    }

    @Override
    public final IllegalArgumentException unableToDetermineKeySize() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unableToDetermineKeySize$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToDetermineDefaultCompatibleSignatureAlgorithmName$str() {
        return unableToDetermineDefaultCompatibleSignatureAlgorithmName;
    }

    @Override
    public final IllegalArgumentException unableToDetermineDefaultCompatibleSignatureAlgorithmName(String keyAlgorithmName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unableToDetermineDefaultCompatibleSignatureAlgorithmName$str(), keyAlgorithmName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String acmeAccountKeyPairGenerationFailed$str() {
        return acmeAccountKeyPairGenerationFailed;
    }

    @Override
    public final IllegalArgumentException acmeAccountKeyPairGenerationFailed(Exception cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.acmeAccountKeyPairGenerationFailed$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noAcmeServerUrlGiven$str() {
        return noAcmeServerUrlGiven;
    }

    @Override
    public final IllegalArgumentException noAcmeServerUrlGiven() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noAcmeServerUrlGiven$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedAcmeAccountSignatureAlgorithm$str() {
        return unsupportedAcmeAccountSignatureAlgorithm;
    }

    @Override
    public final IllegalArgumentException unsupportedAcmeAccountSignatureAlgorithm(String signatureAlgorithm) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unsupportedAcmeAccountSignatureAlgorithm$str(), signatureAlgorithm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToCreateAcmeSignature$str() {
        return unableToCreateAcmeSignature;
    }

    @Override
    public final IllegalArgumentException unableToCreateAcmeSignature(Exception cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unableToCreateAcmeSignature$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToRetrieveAcmeServerDirectoryUrls$str() {
        return unableToRetrieveAcmeServerDirectoryUrls;
    }

    @Override
    public final AcmeException unableToRetrieveAcmeServerDirectoryUrls(Exception cause) {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.unableToRetrieveAcmeServerDirectoryUrls$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noNonceProvidedByAcmeServer$str() {
        return noNonceProvidedByAcmeServer;
    }

    @Override
    public final AcmeException noNonceProvidedByAcmeServer() {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.noNonceProvidedByAcmeServer$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noAccountLocationUrlProvidedByAcmeServer$str() {
        return noAccountLocationUrlProvidedByAcmeServer;
    }

    @Override
    public final AcmeException noAccountLocationUrlProvidedByAcmeServer() {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.noAccountLocationUrlProvidedByAcmeServer$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToObtainNewNonceFromAcmeServer$str() {
        return unableToObtainNewNonceFromAcmeServer;
    }

    @Override
    public final AcmeException unableToObtainNewNonceFromAcmeServer() {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.unableToObtainNewNonceFromAcmeServer$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToObtainJsonResponseFromAcmeServer$str() {
        return unableToObtainJsonResponseFromAcmeServer;
    }

    @Override
    public final AcmeException unableToObtainJsonResponseFromAcmeServer(Exception cause) {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.unableToObtainJsonResponseFromAcmeServer$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedResponseCodeFromAcmeServer$str() {
        return unexpectedResponseCodeFromAcmeServer;
    }

    @Override
    public final AcmeException unexpectedResponseCodeFromAcmeServer(int responseCode, String responseMessage) {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.unexpectedResponseCodeFromAcmeServer$str(), responseCode, responseMessage));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String badAcmeNonce$str() {
        return badAcmeNonce;
    }

    @Override
    public final AcmeException badAcmeNonce() {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.badAcmeNonce$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedContentTypeFromAcmeServer$str() {
        return unexpectedContentTypeFromAcmeServer;
    }

    @Override
    public final AcmeException unexpectedContentTypeFromAcmeServer(String contentType) {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.unexpectedContentTypeFromAcmeServer$str(), contentType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidContentTypeFromAcmeServer$str() {
        return invalidContentTypeFromAcmeServer;
    }

    @Override
    public final AcmeException invalidContentTypeFromAcmeServer() {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.invalidContentTypeFromAcmeServer$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String domainNameIsNull$str() {
        return domainNameIsNull;
    }

    @Override
    public final AcmeException domainNameIsNull() {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.domainNameIsNull$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String domainNamesIsEmpty$str() {
        return domainNamesIsEmpty;
    }

    @Override
    public final AcmeException domainNamesIsEmpty() {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.domainNamesIsEmpty$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noCertificateUrlProvidedByAcmeServer$str() {
        return noCertificateUrlProvidedByAcmeServer;
    }

    @Override
    public final AcmeException noCertificateUrlProvidedByAcmeServer() {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.noCertificateUrlProvidedByAcmeServer$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noCertificateWillBeIssuedByAcmeServer$str() {
        return noCertificateWillBeIssuedByAcmeServer;
    }

    @Override
    public final AcmeException noCertificateWillBeIssuedByAcmeServer() {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.noCertificateWillBeIssuedByAcmeServer$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToGetEncodedFormOfCertificateToBeRevoked$str() {
        return unableToGetEncodedFormOfCertificateToBeRevoked;
    }

    @Override
    public final AcmeException unableToGetEncodedFormOfCertificateToBeRevoked(Exception cause) {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.unableToGetEncodedFormOfCertificateToBeRevoked$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToDetermineKeyAuthorizationString$str() {
        return unableToDetermineKeyAuthorizationString;
    }

    @Override
    public final AcmeException unableToDetermineKeyAuthorizationString(Exception cause) {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.unableToDetermineKeyAuthorizationString$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String challengeResponseFailedValidationByAcmeServer$str() {
        return challengeResponseFailedValidationByAcmeServer;
    }

    @Override
    public final AcmeException challengeResponseFailedValidationByAcmeServer() {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.challengeResponseFailedValidationByAcmeServer$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToDownloadCertificateChainFromAcmeServer$str() {
        return unableToDownloadCertificateChainFromAcmeServer;
    }

    @Override
    public final AcmeException unableToDownloadCertificateChainFromAcmeServer(Exception cause) {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.unableToDownloadCertificateChainFromAcmeServer$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String acmeAccountDoesNotExist$str() {
        return acmeAccountDoesNotExist;
    }

    @Override
    public final AcmeException acmeAccountDoesNotExist() {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.acmeAccountDoesNotExist$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String userActionRequired$str() {
        return userActionRequired;
    }

    @Override
    public final AcmeException userActionRequired(String url) {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.userActionRequired$str(), url));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String rateLimitExceededTryAgainLater$str() {
        return rateLimitExceededTryAgainLater;
    }

    @Override
    public final AcmeException rateLimitExceededTryAgainLater(Instant instant) {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.rateLimitExceededTryAgainLater$str(), instant));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String rateLimitExceeded$str() {
        return rateLimitExceeded;
    }

    @Override
    public final AcmeException rateLimitExceeded() {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.rateLimitExceeded$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String resourceNotSupportedByAcmeServer$str() {
        return resourceNotSupportedByAcmeServer;
    }

    @Override
    public final AcmeException resourceNotSupportedByAcmeServer(String resource) {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.resourceNotSupportedByAcmeServer$str(), resource));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedAcmeAccountPublicKeyType$str() {
        return unsupportedAcmeAccountPublicKeyType;
    }

    @Override
    public final IllegalArgumentException unsupportedAcmeAccountPublicKeyType(String keyAlgorithmName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unsupportedAcmeAccountPublicKeyType$str(), keyAlgorithmName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToDetermineCurveParameterFromAlgHeader$str() {
        return unableToDetermineCurveParameterFromAlgHeader;
    }

    @Override
    public final IllegalArgumentException unableToDetermineCurveParameterFromAlgHeader(String algHeader) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unableToDetermineCurveParameterFromAlgHeader$str(), algHeader));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

