/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.util.TransformationMapper;
import org.wildfly.security.util.TransformationSpec;

public class DefaultTransformationMapper
implements TransformationMapper {
    protected HashMap<String, TransformationSpec[]> transformations = new HashMap();

    public DefaultTransformationMapper() {
        this.transformations.put("DIGEST-MD5", new TransformationSpec[]{new TransformationSpec("3des", "DESede/CBC/NoPadding", TransformationSpec.NO_KEY, TransformationSpec.HIGH_STRENGTH + 1, "SunJCA"), new TransformationSpec("rc4", "RC4", 128, TransformationSpec.HIGH_STRENGTH, "SunJCA"), new TransformationSpec("des", "DES/CBC/NoPadding", TransformationSpec.NO_KEY, TransformationSpec.MEDIUM_STRENGTH + 1, "SunJCA"), new TransformationSpec("rc4-56", "RC4", 56, TransformationSpec.MEDIUM_STRENGTH, "SunJCA"), new TransformationSpec("rc4-40", "RC4", 40, TransformationSpec.LOW_STRENGTH, "SunJCA")});
        for (String mech : this.transformations.keySet()) {
            Arrays.sort(this.transformations.get(mech), (o1, o2) -> {
                if (o1.getStrength() < o2.getStrength()) {
                    return 1;
                }
                if (o1.getStrength() > o2.getStrength()) {
                    return -1;
                }
                return 0;
            });
        }
    }

    @Override
    public TransformationSpec getTransformationSpec(String mechanism, String token) throws IllegalArgumentException {
        return this.getTransformationSpec(null, mechanism, token);
    }

    @Override
    public TransformationSpec getTransformationSpec(String provider, String mechanism, String token) throws IllegalArgumentException {
        Assert.checkNotNullParam((String)"token", (Object)token);
        TransformationSpec[] ts = this.transformations.get(mechanism);
        if (ts == null) {
            throw ElytronMessages.log.mechanismNotSupported(mechanism);
        }
        for (TransformationSpec t : ts) {
            if (!token.equals(t.getToken()) || provider != null && !provider.equals(t.getProvider())) continue;
            return t;
        }
        return null;
    }

    @Override
    public TransformationSpec[] getTransformationSpecByStrength(String mechanism, String ... tokens) throws IllegalArgumentException {
        return this.getTransformationSpecByStrength((String)null, mechanism, tokens);
    }

    @Override
    public TransformationSpec[] getTransformationSpecByStrength(String provider, String mechanism, String ... tokens) throws IllegalArgumentException {
        Assert.checkNotNullParam((String)"tokens", (Object)tokens);
        TransformationSpec[] ts = this.transformations.get(mechanism);
        if (ts == null) {
            throw ElytronMessages.log.mechanismNotSupported(mechanism);
        }
        ArrayList<TransformationSpec> tf = new ArrayList<TransformationSpec>(ts.length);
        for (TransformationSpec t : ts) {
            for (String token : tokens) {
                if (!token.equals(t.getToken()) || provider != null && !provider.equals(t.getProvider())) continue;
                tf.add(t);
            }
        }
        return tf.toArray(new TransformationSpec[tf.size()]);
    }

    @Override
    public TransformationSpec[] getTransformationSpecWithStrength(String mechanism, int strength, String ... tokens) throws IllegalArgumentException {
        return this.getTransformationSpecWithStrength(null, mechanism, strength, tokens);
    }

    @Override
    public TransformationSpec[] getTransformationSpecWithStrength(String provider, String mechanism, int strength, String ... tokens) throws IllegalArgumentException {
        Assert.checkNotNullParam((String)"tokens", (Object)tokens);
        TransformationSpec[] ts = this.transformations.get(mechanism);
        if (ts == null) {
            throw ElytronMessages.log.mechanismNotSupported(mechanism);
        }
        ArrayList<TransformationSpec> tf = new ArrayList<TransformationSpec>(ts.length);
        for (TransformationSpec t : ts) {
            for (String token : tokens) {
                if (!token.equals(t.getToken()) || provider != null && (!provider.equals(t.getProvider()) || strength > t.getStrength())) continue;
                tf.add(t);
            }
        }
        return tf.toArray(new TransformationSpec[tf.size()]);
    }
}

