/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.jaspi.impl;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.security.auth.message.config.ServerAuthContext;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.jaspi.impl.AuthenticationModuleDefinition;
import org.wildfly.security.auth.jaspi.impl.ElytronServerAuthContext;

class ElytronServerAuthConfig
implements ServerAuthConfig {
    private final String messageLayer;
    private final String appContext;
    private final CallbackHandler callbackHandler;
    private final List<AuthenticationModuleDefinition> serverAuthModuleDefinitions;
    private final Map<String, ElytronServerAuthContext> contextMap = new ConcurrentHashMap<String, ElytronServerAuthContext>();

    ElytronServerAuthConfig(String messageLayer, String appContext, CallbackHandler callbackHander, List<AuthenticationModuleDefinition> serverAuthModuleDefinitions) {
        this.messageLayer = messageLayer;
        this.appContext = appContext;
        this.callbackHandler = callbackHander;
        this.serverAuthModuleDefinitions = serverAuthModuleDefinitions;
    }

    public String getMessageLayer() {
        return this.messageLayer;
    }

    public String getAppContext() {
        return this.appContext;
    }

    public String getAuthContextID(MessageInfo messageInfo) {
        Assert.checkNotNullParam((String)"messageInfo", (Object)messageInfo);
        Assert.checkNotNullParam((String)"messageInfo.requestMessage", (Object)messageInfo.getRequestMessage());
        Assert.checkNotNullParam((String)"messageInfo.responseMessage", (Object)messageInfo.getResponseMessage());
        ElytronServerAuthContext serverAuthContext = new ElytronServerAuthContext(this.serverAuthModuleDefinitions);
        serverAuthContext.testMessageInfo(messageInfo);
        String identifier = UUID.randomUUID().toString();
        this.contextMap.put(identifier, serverAuthContext);
        return identifier;
    }

    public ServerAuthContext getAuthContext(String authContextId, Subject serviceSubject, Map properties) throws AuthException {
        ElytronServerAuthContext serverAuthContext = this.contextMap.remove(authContextId);
        if (serverAuthContext == null) {
            throw ElytronMessages.log.unrecognisedAuthContextId(authContextId);
        }
        serverAuthContext.initialise(serviceSubject, this.callbackHandler, properties);
        return serverAuthContext;
    }

    public boolean isProtected() {
        return true;
    }

    public void refresh() {
    }
}

