/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.util.EnumSet;
import org.wildfly.security._private.ElytronMessages;

public enum Encryption {
    NULL,
    AES256GCM,
    AES256,
    AES128GCM,
    AES128,
    CAMELLIA256,
    CAMELLIA128,
    _3DES,
    DES,
    IDEA,
    GOST2814789CNT,
    SEED,
    FZA,
    RC4,
    RC2;

    static final int fullSize;

    static Encryption forName(String name) {
        switch (name) {
            case "NULL": {
                return NULL;
            }
            case "AES256GCM": {
                return AES256GCM;
            }
            case "AES256": {
                return AES256;
            }
            case "AES128GCM": {
                return AES128GCM;
            }
            case "AES128": {
                return AES128;
            }
            case "CAMELLIA256": {
                return CAMELLIA256;
            }
            case "CAMELLIA128": {
                return CAMELLIA128;
            }
            case "3DES": {
                return _3DES;
            }
            case "DES": {
                return DES;
            }
            case "IDEA": {
                return IDEA;
            }
            case "GOST2814789CNT": {
                return GOST2814789CNT;
            }
            case "SEED": {
                return SEED;
            }
            case "FZA": {
                return FZA;
            }
            case "RC4": {
                return RC4;
            }
            case "RC2": {
                return RC2;
            }
        }
        return null;
    }

    static Encryption require(String name) {
        Encryption encryption = Encryption.forName(name);
        if (encryption == null) {
            throw ElytronMessages.log.unknownEncryptionName(name);
        }
        return null;
    }

    public static boolean isFull(EnumSet<Encryption> encryptions) {
        return encryptions != null && encryptions.size() == fullSize;
    }

    public boolean in(Encryption value1, Encryption value2) {
        return this == value1 || this == value2;
    }

    public boolean in(Encryption value1, Encryption value2, Encryption value3) {
        return this == value1 || this == value2 || this == value3;
    }

    public boolean in(Encryption ... values) {
        if (values != null) {
            for (Encryption value : values) {
                if (this != value) continue;
                return true;
            }
        }
        return false;
    }

    static {
        fullSize = Encryption.values().length;
    }
}

