/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamReader;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import org.wildfly.client.config.ClientConfiguration;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.client.config.ConfigurationXMLStreamReader;
import org.wildfly.client.config.XMLLocation;
import org.wildfly.common.Assert;
import org.wildfly.common.function.ExceptionBiFunction;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.common.function.ExceptionUnaryOperator;
import org.wildfly.security.FixedSecurityFactory;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.asn1.OidsUtil;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.ConfigurationKeyManager;
import org.wildfly.security.auth.client.CredentialStoreFactory;
import org.wildfly.security.auth.client.LegacyConfiguration;
import org.wildfly.security.auth.client.MatchRule;
import org.wildfly.security.auth.client.ModuleLoader;
import org.wildfly.security.auth.client.RuleNode;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.util.ElytronAuthenticator;
import org.wildfly.security.auth.util.GSSCredentialSecurityFactory;
import org.wildfly.security.auth.util.RegexNameRewriter;
import org.wildfly.security.credential.BearerTokenCredential;
import org.wildfly.security.credential.KeyPairCredential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.PublicKeyCredential;
import org.wildfly.security.credential.X509CertificateChainPrivateCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.source.CredentialStoreCredentialSource;
import org.wildfly.security.credential.source.KeyStoreCredentialSource;
import org.wildfly.security.credential.source.LocalKerberosCredentialSource;
import org.wildfly.security.credential.source.OAuth2CredentialSource;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.keystore.PasswordEntry;
import org.wildfly.security.keystore.WrappingPasswordKeyStore;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.pem.Pem;
import org.wildfly.security.pem.PemEntry;
import org.wildfly.security.sasl.SaslMechanismSelector;
import org.wildfly.security.sasl.util.ServiceLoaderSaslClientFactory;
import org.wildfly.security.ssl.CipherSuiteSelector;
import org.wildfly.security.ssl.ProtocolSelector;
import org.wildfly.security.ssl.SSLContextBuilder;
import org.wildfly.security.ssl.X509CRLExtendedTrustManager;
import org.wildfly.security.util.CodePointIterator;
import org.wildfly.security.util.ProviderUtil;
import org.wildfly.security.util.ServiceLoaderSupplier;
import org.wildfly.security.x500.X500;

public final class ElytronXmlParser {
    private static final Supplier<Provider[]> ELYTRON_PROVIDER_SUPPLIER = WildFlySecurityManager.isChecking() ? (Supplier)AccessController.doPrivileged(() -> new ServiceLoaderSupplier<Provider>(Provider.class, ElytronXmlParser.class.getClassLoader())) : new ServiceLoaderSupplier<Provider>(Provider.class, ElytronXmlParser.class.getClassLoader());
    private static final Supplier<Provider[]> DEFAULT_PROVIDER_SUPPLIER = ProviderUtil.aggregate(ELYTRON_PROVIDER_SUPPLIER, Security::getProviders);
    static final Map<String, Version> KNOWN_NAMESPACES;

    private ElytronXmlParser() {
    }

    public static SecurityFactory<AuthenticationContext> parseAuthenticationClientConfiguration() throws ConfigXMLParseException {
        ClientConfiguration clientConfiguration = ClientConfiguration.getInstance();
        if (clientConfiguration != null) {
            try (ConfigurationXMLStreamReader streamReader = clientConfiguration.readConfiguration(KNOWN_NAMESPACES.keySet());){
                if (streamReader != null) {
                    SecurityFactory<AuthenticationContext> securityFactory = ElytronXmlParser.parseAuthenticationClientConfiguration(streamReader);
                    return securityFactory;
                }
            }
        }
        return ElytronXmlParser.parseLegacyConfiguration();
    }

    public static SecurityFactory<AuthenticationContext> parseAuthenticationClientConfiguration(URI uri) throws ConfigXMLParseException {
        ClientConfiguration clientConfiguration = ClientConfiguration.getInstance((URI)uri);
        if (clientConfiguration != null) {
            try (ConfigurationXMLStreamReader streamReader = clientConfiguration.readConfiguration(KNOWN_NAMESPACES.keySet());){
                if (streamReader != null) {
                    SecurityFactory<AuthenticationContext> securityFactory = ElytronXmlParser.parseAuthenticationClientConfiguration(streamReader);
                    return securityFactory;
                }
            }
        }
        return ElytronXmlParser.parseLegacyConfiguration();
    }

    static SecurityFactory<AuthenticationContext> parseAuthenticationClientConfiguration(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        if (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 1: {
                    Version xmlVersion = KNOWN_NAMESPACES.get(ElytronXmlParser.checkGetElementNamespace(reader));
                    switch (reader.getLocalName()) {
                        case "authentication-client": {
                            return ElytronXmlParser.parseAuthenticationClientType(reader, xmlVersion);
                        }
                    }
                    throw reader.unexpectedElement();
                }
            }
            throw reader.unexpectedContent();
        }
        return AuthenticationContext::empty;
    }

    private static SecurityFactory<AuthenticationContext> parseLegacyConfiguration() {
        ServiceLoader<LegacyConfiguration> loader = ServiceLoader.load(LegacyConfiguration.class, ElytronXmlParser.class.getClassLoader());
        Iterator<LegacyConfiguration> iterator = loader.iterator();
        ArrayList<LegacyConfiguration> configs = new ArrayList<LegacyConfiguration>();
        while (true) {
            try {
                while (iterator.hasNext()) {
                    configs.add(iterator.next());
                }
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
                continue;
            }
            break;
        }
        return () -> {
            for (LegacyConfiguration config : configs) {
                AuthenticationContext context = config.getConfiguredAuthenticationContext();
                if (context == null) continue;
                return context;
            }
            return AuthenticationContext.empty();
        };
    }

    static SecurityFactory<AuthenticationContext> parseAuthenticationClientType(ConfigurationXMLStreamReader reader, Version xmlVersion) throws ConfigXMLParseException {
        ElytronXmlParser.requireNoAttributes(reader);
        ExceptionSupplier authFactory = () -> null;
        ExceptionSupplier sslFactory = () -> null;
        HashMap<String, ExceptionSupplier<KeyStore, ConfigXMLParseException>> keyStoresMap = new HashMap<String, ExceptionSupplier<KeyStore, ConfigXMLParseException>>();
        HashMap<String, ExceptionSupplier<CredentialStore, ConfigXMLParseException>> credentialStoresMap = new HashMap<String, ExceptionSupplier<CredentialStore, ConfigXMLParseException>>();
        HashMap<String, ExceptionSupplier<SecurityFactory<SSLContext>, ConfigXMLParseException>> sslContextsMap = new HashMap<String, ExceptionSupplier<SecurityFactory<SSLContext>, ConfigXMLParseException>>();
        HashMap<String, ExceptionSupplier<AuthenticationConfiguration, ConfigXMLParseException>> authenticationConfigurationsMap = new HashMap<String, ExceptionSupplier<AuthenticationConfiguration, ConfigXMLParseException>>();
        DeferredSupplier<Provider[]> providersSupplier = new DeferredSupplier<Provider[]>(DEFAULT_PROVIDER_SUPPLIER);
        boolean netAuthenticator = false;
        int foundBits = 0;
        block20: while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                ElytronXmlParser.checkElementNamespace(reader, xmlVersion);
                switch (reader.getLocalName()) {
                    case "authentication-rules": {
                        if (ElytronXmlParser.isSet(foundBits, 0)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 0);
                        authFactory = ElytronXmlParser.parseRulesType(reader, xmlVersion, authenticationConfigurationsMap, (r, m) -> ElytronXmlParser.parseAuthenticationRuleType(r, xmlVersion, m));
                        break;
                    }
                    case "ssl-context-rules": {
                        if (ElytronXmlParser.isSet(foundBits, 1)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 1);
                        sslFactory = ElytronXmlParser.parseRulesType(reader, xmlVersion, sslContextsMap, (r, m) -> ElytronXmlParser.parseSslContextRuleType(r, xmlVersion, m));
                        break;
                    }
                    case "authentication-configurations": {
                        if (ElytronXmlParser.isSet(foundBits, 2)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 2);
                        ElytronXmlParser.parseAuthenticationConfigurationsType(reader, xmlVersion, authenticationConfigurationsMap, keyStoresMap, credentialStoresMap, providersSupplier);
                        break;
                    }
                    case "ssl-contexts": {
                        if (ElytronXmlParser.isSet(foundBits, 3)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 3);
                        ElytronXmlParser.parseSslContextsType(reader, xmlVersion, sslContextsMap, keyStoresMap, credentialStoresMap, providersSupplier);
                        break;
                    }
                    case "key-stores": {
                        if (ElytronXmlParser.isSet(foundBits, 4)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 4);
                        ElytronXmlParser.parseKeyStoresType(reader, xmlVersion, keyStoresMap, credentialStoresMap, providersSupplier);
                        break;
                    }
                    case "net-authenticator": {
                        if (ElytronXmlParser.isSet(foundBits, 5)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 5);
                        netAuthenticator = true;
                        ElytronXmlParser.parseEmptyType(reader);
                        break;
                    }
                    case "credential-stores": {
                        if (ElytronXmlParser.isSet(foundBits, 6)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 6);
                        ElytronXmlParser.parseCredentialStoresType(reader, xmlVersion, keyStoresMap, credentialStoresMap, providersSupplier);
                        break;
                    }
                    case "providers": {
                        if (ElytronXmlParser.isSet(foundBits, 7)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 7);
                        Supplier<Provider[]> supplier = ElytronXmlParser.parseProvidersType(reader, xmlVersion);
                        if (supplier == null) continue block20;
                        providersSupplier.setSupplier(supplier);
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                assert (reader.getLocalName().equals("authentication-client"));
                if (netAuthenticator) {
                    Authenticator.setDefault(new ElytronAuthenticator());
                }
                for (ExceptionSupplier supplier : keyStoresMap.values()) {
                    supplier.get();
                }
                for (ExceptionSupplier supplier : credentialStoresMap.values()) {
                    supplier.get();
                }
                RuleNode authNode = (RuleNode)authFactory.get();
                RuleNode sslNode = (RuleNode)sslFactory.get();
                return () -> new AuthenticationContext(authNode, sslNode);
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    private static void parseAuthenticationConfigurationsType(ConfigurationXMLStreamReader reader, Version xmlVersion, Map<String, ExceptionSupplier<AuthenticationConfiguration, ConfigXMLParseException>> authenticationConfigurationsMap, Map<String, ExceptionSupplier<KeyStore, ConfigXMLParseException>> keyStoresMap, Map<String, ExceptionSupplier<CredentialStore, ConfigXMLParseException>> credentialStoresMap, Supplier<Provider[]> providers) throws ConfigXMLParseException {
        ElytronXmlParser.requireNoAttributes(reader);
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                ElytronXmlParser.checkElementNamespace(reader, xmlVersion);
                switch (reader.getLocalName()) {
                    case "configuration": {
                        ElytronXmlParser.parseAuthenticationConfigurationType(reader, xmlVersion, authenticationConfigurationsMap, keyStoresMap, credentialStoresMap, providers);
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                return;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    private static void parseSslContextsType(ConfigurationXMLStreamReader reader, Version xmlVersion, Map<String, ExceptionSupplier<SecurityFactory<SSLContext>, ConfigXMLParseException>> sslContextsMap, Map<String, ExceptionSupplier<KeyStore, ConfigXMLParseException>> keyStoresMap, Map<String, ExceptionSupplier<CredentialStore, ConfigXMLParseException>> credentialStoresMap, Supplier<Provider[]> providers) throws ConfigXMLParseException {
        ElytronXmlParser.requireNoAttributes(reader);
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                ElytronXmlParser.checkElementNamespace(reader, xmlVersion);
                switch (reader.getLocalName()) {
                    case "ssl-context": {
                        ElytronXmlParser.parseSslContextType(reader, xmlVersion, sslContextsMap, keyStoresMap, credentialStoresMap, providers);
                        break;
                    }
                    case "default-ssl-context": {
                        String name = ElytronXmlParser.parseNameType(reader);
                        sslContextsMap.put(name, (ExceptionSupplier<SecurityFactory<SSLContext>, ConfigXMLParseException>)((ExceptionSupplier)() -> SSLContext::getDefault));
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                return;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    private static void parseSslContextType(ConfigurationXMLStreamReader reader, Version xmlVersion, Map<String, ExceptionSupplier<SecurityFactory<SSLContext>, ConfigXMLParseException>> sslContextsMap, Map<String, ExceptionSupplier<KeyStore, ConfigXMLParseException>> keyStoresMap, Map<String, ExceptionSupplier<CredentialStore, ConfigXMLParseException>> credentialStoresMap, Supplier<Provider[]> providers) throws ConfigXMLParseException {
        String name = ElytronXmlParser.requireSingleAttribute(reader, "name");
        if (sslContextsMap.containsKey(name)) {
            throw ElytronMessages.xmlLog.xmlDuplicateSslContextName(name, reader);
        }
        XMLLocation location = reader.getLocation();
        int foundBits = 0;
        String providerName = null;
        CipherSuiteSelector cipherSuiteSelector = null;
        ProtocolSelector protocolSelector = null;
        PrivateKeyKeyStoreEntryCredentialFactory credentialFactory = null;
        ExceptionSupplier<KeyStore, ConfigXMLParseException> trustStoreSupplier = null;
        DeferredSupplier<Provider[]> providersSupplier = new DeferredSupplier<Provider[]>(providers);
        TrustManagerBuilder trustManagerBuilder = new TrustManagerBuilder();
        block18: while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                ElytronXmlParser.checkElementNamespace(reader, xmlVersion);
                switch (reader.getLocalName()) {
                    case "key-store-ssl-certificate": {
                        if (ElytronXmlParser.isSet(foundBits, 0)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 0);
                        credentialFactory = new PrivateKeyKeyStoreEntryCredentialFactory(ElytronXmlParser.parseKeyStoreRefType(reader, xmlVersion, keyStoresMap, credentialStoresMap, providersSupplier), location);
                        break;
                    }
                    case "cipher-suite": {
                        if (ElytronXmlParser.isSet(foundBits, 1)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 1);
                        cipherSuiteSelector = ElytronXmlParser.parseCipherSuiteSelectorType(reader);
                        break;
                    }
                    case "protocol": {
                        if (ElytronXmlParser.isSet(foundBits, 2)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 2);
                        protocolSelector = ElytronXmlParser.parseProtocolSelectorNamesType(reader);
                        break;
                    }
                    case "provider-name": {
                        if (ElytronXmlParser.isSet(foundBits, 3)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 3);
                        providerName = ElytronXmlParser.parseNameType(reader);
                        break;
                    }
                    case "providers": {
                        if (ElytronXmlParser.isSet(foundBits, 4)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 4);
                        Supplier<Provider[]> supplier = ElytronXmlParser.parseProvidersType(reader, xmlVersion);
                        if (supplier == null) continue block18;
                        providersSupplier.setSupplier(supplier);
                        break;
                    }
                    case "trust-store": {
                        if (ElytronXmlParser.isSet(foundBits, 5)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 5);
                        trustStoreSupplier = ElytronXmlParser.parseTrustStoreRefType(reader, keyStoresMap);
                        break;
                    }
                    case "certificate-revocation-list": {
                        if (ElytronXmlParser.isSet(foundBits, 6)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 6);
                        ElytronXmlParser.parseCertificateRevocationList(reader, trustManagerBuilder);
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag != 2) {
                throw reader.unexpectedContent();
            }
            DeferredSupplier<Provider[]> finalProvidersSupplier = providersSupplier;
            ProtocolSelector finalProtocolSelector = protocolSelector;
            CipherSuiteSelector finalCipherSuiteSelector = cipherSuiteSelector;
            String finalProviderName = providerName;
            PrivateKeyKeyStoreEntryCredentialFactory finalCredentialFactory = credentialFactory;
            ExceptionSupplier<KeyStore, ConfigXMLParseException> finalTrustStoreSupplier = trustStoreSupplier;
            sslContextsMap.putIfAbsent(name, (ExceptionSupplier<SecurityFactory<SSLContext>, ConfigXMLParseException>)((ExceptionSupplier)() -> {
                SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
                sslContextBuilder.setClientMode(true);
                if (finalCipherSuiteSelector != null) {
                    sslContextBuilder.setCipherSuiteSelector(finalCipherSuiteSelector);
                }
                if (finalProtocolSelector != null) {
                    sslContextBuilder.setProtocolSelector(finalProtocolSelector);
                }
                if (finalCredentialFactory != null) {
                    ConfigurationKeyManager.Builder builder = new ConfigurationKeyManager.Builder();
                    X509CertificateChainPrivateCredential privateCredential = finalCredentialFactory.get();
                    builder.addCredential(privateCredential);
                    sslContextBuilder.setKeyManager(builder.build());
                }
                if (finalTrustStoreSupplier != null) {
                    trustManagerBuilder.setTrustStore((KeyStore)finalTrustStoreSupplier.get());
                    try {
                        sslContextBuilder.setTrustManager(trustManagerBuilder.build());
                    }
                    catch (GeneralSecurityException e) {
                        throw new ConfigXMLParseException((Throwable)e);
                    }
                }
                sslContextBuilder.setProviderName(finalProviderName);
                sslContextBuilder.setProviderSupplier(finalProvidersSupplier);
                sslContextBuilder.setUseCipherSuitesOrder(true);
                return sslContextBuilder.build();
            }));
            return;
        }
        throw reader.unexpectedDocumentEnd();
    }

    private static void parseCertificateRevocationList(ConfigurationXMLStreamReader reader, TrustManagerBuilder builder) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        String path = null;
        int maxCertPath = 0;
        block10: for (int i = 0; i < attributeCount; ++i) {
            ElytronXmlParser.checkAttributeNamespace(reader, i);
            switch (reader.getAttributeLocalName(i)) {
                case "path": {
                    if (path != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    path = reader.getAttributeValueResolved(i);
                    continue block10;
                }
                case "maximum-cert-path": {
                    if (maxCertPath != 0) {
                        throw reader.unexpectedAttribute(i);
                    }
                    maxCertPath = reader.getIntAttributeValueResolved(i, 1, Integer.MAX_VALUE);
                    continue block10;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                builder.setCrl();
                if (path != null) {
                    try {
                        builder.setCrlStream(new FileInputStream(path));
                    }
                    catch (FileNotFoundException e) {
                        throw new ConfigXMLParseException((Throwable)e);
                    }
                }
                if (maxCertPath != 0) {
                    builder.setMaxCertPath(maxCertPath);
                }
                return;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static ExceptionUnaryOperator<RuleNode<SecurityFactory<SSLContext>>, ConfigXMLParseException> parseSslContextRuleType(ConfigurationXMLStreamReader reader, Version xmlVersion, Map<String, ExceptionSupplier<SecurityFactory<SSLContext>, ConfigXMLParseException>> sslContextsMap) throws ConfigXMLParseException {
        String attributeName = "use-ssl-context";
        String name = ElytronXmlParser.requireSingleAttribute(reader, "use-ssl-context");
        XMLLocation location = reader.getLocation();
        MatchRule rule = ElytronXmlParser.parseAbstractMatchRuleType(reader, xmlVersion);
        return next -> {
            ExceptionSupplier factory = (ExceptionSupplier)sslContextsMap.get(name);
            if (factory == null) {
                throw ElytronMessages.xmlLog.xmlUnknownSslContextSpecified((Location)location, name);
            }
            return new RuleNode<Object>((RuleNode<Object>)next, rule, factory.get());
        };
    }

    static ExceptionUnaryOperator<RuleNode<AuthenticationConfiguration>, ConfigXMLParseException> parseAuthenticationRuleType(ConfigurationXMLStreamReader reader, Version xmlVersion, Map<String, ExceptionSupplier<AuthenticationConfiguration, ConfigXMLParseException>> authenticationConfigurationsMap) throws ConfigXMLParseException {
        String attributeName = "use-configuration";
        String name = ElytronXmlParser.requireSingleAttribute(reader, "use-configuration");
        XMLLocation location = reader.getLocation();
        MatchRule rule = ElytronXmlParser.parseAbstractMatchRuleType(reader, xmlVersion);
        return next -> {
            ExceptionSupplier factory = (ExceptionSupplier)authenticationConfigurationsMap.get(name);
            if (factory == null) {
                throw ElytronMessages.xmlLog.xmlUnknownAuthenticationConfigurationSpecified((Location)location, name);
            }
            return new RuleNode<Object>((RuleNode<Object>)next, rule, factory.get());
        };
    }

    static <C> ExceptionSupplier<RuleNode<C>, ConfigXMLParseException> parseRulesType(ConfigurationXMLStreamReader reader, Version xmlVersion, Map<String, ExceptionSupplier<C, ConfigXMLParseException>> configurations, ExceptionBiFunction<ConfigurationXMLStreamReader, Map<String, ExceptionSupplier<C, ConfigXMLParseException>>, ExceptionUnaryOperator<RuleNode<C>, ConfigXMLParseException>, ConfigXMLParseException> ruleParseFunction) throws ConfigXMLParseException {
        ElytronXmlParser.requireNoAttributes(reader);
        ArrayList<Object> rulesList = new ArrayList<Object>();
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                ElytronXmlParser.checkElementNamespace(reader, xmlVersion);
                switch (reader.getLocalName()) {
                    case "rule": {
                        rulesList.add(ruleParseFunction.apply((Object)reader, configurations));
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                return () -> {
                    RuleNode node = null;
                    ListIterator iterator = rulesList.listIterator(rulesList.size());
                    while (iterator.hasPrevious()) {
                        node = (RuleNode)((ExceptionUnaryOperator)iterator.previous()).apply(node);
                    }
                    return node;
                };
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static void parseAuthenticationConfigurationType(ConfigurationXMLStreamReader reader, Version xmlVersion, Map<String, ExceptionSupplier<AuthenticationConfiguration, ConfigXMLParseException>> authenticationConfigurationsMap, Map<String, ExceptionSupplier<KeyStore, ConfigXMLParseException>> keyStoresMap, Map<String, ExceptionSupplier<CredentialStore, ConfigXMLParseException>> credentialStoresMap, Supplier<Provider[]> providers) throws ConfigXMLParseException {
        String name = ElytronXmlParser.requireSingleAttribute(reader, "name");
        if (authenticationConfigurationsMap.containsKey(name)) {
            throw ElytronMessages.xmlLog.xmlDuplicateAuthenticationConfigurationName(name, reader);
        }
        ExceptionUnaryOperator configuration = ignored -> AuthenticationConfiguration.empty();
        DeferredSupplier<Provider[]> providerSupplier = new DeferredSupplier<Provider[]>(providers);
        configuration = ElytronXmlParser.andThenOp(configuration, parent -> parent.useProviders(providerSupplier));
        int foundBits = 0;
        if (!reader.hasNext()) {
            throw reader.unexpectedDocumentEnd();
        }
        block32: while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                ElytronXmlParser.checkElementNamespace(reader, xmlVersion);
                switch (reader.getLocalName()) {
                    case "set-host": {
                        if (ElytronXmlParser.isSet(foundBits, 0)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 0);
                        String hostName = ElytronXmlParser.parseNameType(reader);
                        configuration = ElytronXmlParser.andThenOp(configuration, parentConfig -> parentConfig.useHost(hostName));
                        break;
                    }
                    case "set-port": {
                        if (ElytronXmlParser.isSet(foundBits, 1)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 1);
                        int port = ElytronXmlParser.parsePortType(reader);
                        configuration = ElytronXmlParser.andThenOp(configuration, parentConfig -> parentConfig.usePort(port));
                        break;
                    }
                    case "set-user-name": {
                        if (ElytronXmlParser.isSet(foundBits, 2)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 2);
                        String userName = ElytronXmlParser.parseNameType(reader);
                        configuration = ElytronXmlParser.andThenOp(configuration, parentConfig -> parentConfig.useName(userName));
                        break;
                    }
                    case "set-anonymous": {
                        if (ElytronXmlParser.isSet(foundBits, 2)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 2);
                        ElytronXmlParser.parseEmptyType(reader);
                        configuration = ElytronXmlParser.andThenOp(configuration, AuthenticationConfiguration::useAnonymous);
                        break;
                    }
                    case "set-mechanism-realm": {
                        if (ElytronXmlParser.isSet(foundBits, 3)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 3);
                        String realm = ElytronXmlParser.parseNameType(reader);
                        configuration = ElytronXmlParser.andThenOp(configuration, parentConfig -> parentConfig.useRealm(realm));
                        break;
                    }
                    case "rewrite-user-name-regex": {
                        if (ElytronXmlParser.isSet(foundBits, 4)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 4);
                        NameRewriter nameRewriter = ElytronXmlParser.parseRegexSubstitutionType(reader);
                        configuration = ElytronXmlParser.andThenOp(configuration, parentConfig -> parentConfig.rewriteUser(nameRewriter));
                        break;
                    }
                    case "set-mechanism-properties": {
                        if (ElytronXmlParser.isSet(foundBits, 5)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 5);
                        Map<String, String> mechanismProperties = ElytronXmlParser.parsePropertiesType(reader, xmlVersion);
                        configuration = ElytronXmlParser.andThenOp(configuration, parentConfig -> parentConfig.useMechanismProperties(mechanismProperties, true));
                        break;
                    }
                    case "sasl-mechanism-selector": {
                        if (ElytronXmlParser.isSet(foundBits, 6)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 6);
                        SaslMechanismSelector selector = ElytronXmlParser.parseSaslMechanismSelectorType(reader);
                        configuration = ElytronXmlParser.andThenOp(configuration, parentConfig -> parentConfig.setSaslMechanismSelector(selector));
                        break;
                    }
                    case "credentials": {
                        if (ElytronXmlParser.isSet(foundBits, 9)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 9);
                        ExceptionSupplier<CredentialSource, ConfigXMLParseException> credentialSource = ElytronXmlParser.parseCredentialsType(reader, xmlVersion, keyStoresMap, credentialStoresMap, providerSupplier);
                        configuration = ElytronXmlParser.andThenOp(configuration, parentConfig -> parentConfig.useCredentials((CredentialSource)credentialSource.get()));
                        break;
                    }
                    case "set-authorization-name": {
                        if (ElytronXmlParser.isSet(foundBits, 10)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 10);
                        String authName = ElytronXmlParser.parseNameType(reader);
                        configuration = ElytronXmlParser.andThenOp(configuration, parentConfig -> parentConfig.useAuthorizationName(authName));
                        break;
                    }
                    case "providers": {
                        if (ElytronXmlParser.isSet(foundBits, 11)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 11);
                        Supplier<Provider[]> supplier = ElytronXmlParser.parseProvidersType(reader, xmlVersion);
                        if (supplier == null) continue block32;
                        providerSupplier.setSupplier(supplier);
                        break;
                    }
                    case "use-provider-sasl-factory": {
                        if (ElytronXmlParser.isSet(foundBits, 12)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 12);
                        ElytronXmlParser.parseEmptyType(reader);
                        configuration = ElytronXmlParser.andThenOp(configuration, AuthenticationConfiguration::useSaslClientFactoryFromProviders);
                        break;
                    }
                    case "use-service-loader-sasl-factory": {
                        if (ElytronXmlParser.isSet(foundBits, 12)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 12);
                        String moduleName = ElytronXmlParser.parseModuleRefType(reader);
                        ClassLoader classLoader = moduleName == null ? ElytronXmlParser.class.getClassLoader() : ModuleLoader.getClassLoaderFromModule((XMLStreamReader)reader, moduleName);
                        configuration = ElytronXmlParser.andThenOp(configuration, parentConfig -> parentConfig.useSaslClientFactory(new ServiceLoaderSaslClientFactory(classLoader)));
                        break;
                    }
                    case "set-protocol": {
                        if (ElytronXmlParser.isSet(foundBits, 13)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 13);
                        String protocol = ElytronXmlParser.parseNameType(reader);
                        configuration = ElytronXmlParser.andThenOp(configuration, parentConfig -> parentConfig.useProtocol(protocol));
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                ExceptionUnaryOperator finalConfiguration = configuration;
                authenticationConfigurationsMap.put(name, (ExceptionSupplier<AuthenticationConfiguration, ConfigXMLParseException>)((ExceptionSupplier)() -> (AuthenticationConfiguration)finalConfiguration.apply((Object)AuthenticationConfiguration.empty())));
                return;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static Supplier<Provider[]> parseProvidersType(ConfigurationXMLStreamReader reader, Version xmlVersion) throws ConfigXMLParseException {
        ElytronXmlParser.requireNoAttributes(reader);
        Supplier<Provider[]> providerSupplier = null;
        int foundBits = 0;
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                ElytronXmlParser.checkElementNamespace(reader, xmlVersion);
                switch (reader.getLocalName()) {
                    case "global": {
                        if (ElytronXmlParser.isSet(foundBits, 1)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 1);
                        ElytronXmlParser.parseEmptyType(reader);
                        providerSupplier = providerSupplier == null ? Security::getProviders : ProviderUtil.aggregate(providerSupplier, Security::getProviders);
                        break;
                    }
                    case "use-service-loader": {
                        if (ElytronXmlParser.isSet(foundBits, 2)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 2);
                        String moduleName = ElytronXmlParser.parseModuleRefType(reader);
                        ServiceLoaderSupplier<Provider> serviceLoaderSupplier = moduleName == null ? ELYTRON_PROVIDER_SUPPLIER : new ServiceLoaderSupplier<Provider>(Provider.class, ModuleLoader.getClassLoaderFromModule((XMLStreamReader)reader, moduleName));
                        providerSupplier = providerSupplier == null ? serviceLoaderSupplier : ProviderUtil.aggregate(providerSupplier, serviceLoaderSupplier);
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                return providerSupplier;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static MatchRule parseAbstractMatchRuleType(ConfigurationXMLStreamReader reader, Version xmlVersion) throws ConfigXMLParseException {
        MatchRule rule = MatchRule.ALL;
        int foundBits = 0;
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                ElytronXmlParser.checkElementNamespace(reader, xmlVersion);
                switch (reader.getLocalName()) {
                    case "match-no-user": {
                        if (ElytronXmlParser.isSet(foundBits, 0)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 0);
                        ElytronXmlParser.parseEmptyType(reader);
                        rule = rule.matchNoUser();
                        break;
                    }
                    case "match-user": {
                        if (ElytronXmlParser.isSet(foundBits, 0)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 0);
                        rule = rule.matchUser(ElytronXmlParser.parseNameType(reader));
                        break;
                    }
                    case "match-protocol": {
                        if (ElytronXmlParser.isSet(foundBits, 1)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 1);
                        rule = rule.matchProtocol(ElytronXmlParser.parseNameType(reader));
                        break;
                    }
                    case "match-host": {
                        if (ElytronXmlParser.isSet(foundBits, 2)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 2);
                        rule = rule.matchHost(ElytronXmlParser.parseNameType(reader));
                        break;
                    }
                    case "match-path": {
                        if (ElytronXmlParser.isSet(foundBits, 3)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 3);
                        rule = rule.matchPath(ElytronXmlParser.parseNameType(reader));
                        break;
                    }
                    case "match-port": {
                        if (ElytronXmlParser.isSet(foundBits, 4)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 4);
                        rule = rule.matchPort(ElytronXmlParser.parsePortType(reader));
                        break;
                    }
                    case "match-urn": {
                        if (ElytronXmlParser.isSet(foundBits, 5)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 5);
                        rule = rule.matchUrnName(ElytronXmlParser.parseNameType(reader));
                        break;
                    }
                    case "match-domain": {
                        if (ElytronXmlParser.isSet(foundBits, 6)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 6);
                        rule = rule.matchLocalSecurityDomain(ElytronXmlParser.parseNameType(reader));
                        break;
                    }
                    case "match-abstract-type": {
                        if (ElytronXmlParser.isSet(foundBits, 7)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 7);
                        rule = ElytronXmlParser.parseMatchAbstractType(rule, reader);
                        break;
                    }
                    default: {
                        return rule;
                    }
                }
                continue;
            }
            return rule;
        }
        throw reader.unexpectedDocumentEnd();
    }

    private static MatchRule parseMatchAbstractType(MatchRule rule, ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        String name = null;
        String authority = null;
        block8: for (int i = 0; i < attributeCount; ++i) {
            ElytronXmlParser.checkAttributeNamespace(reader, i);
            switch (reader.getAttributeLocalName(i)) {
                case "name": {
                    name = reader.getAttributeValueResolved(i);
                    continue block8;
                }
                case "authority": {
                    authority = reader.getAttributeValueResolved(i);
                    continue block8;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        if (!reader.hasNext()) {
            throw reader.unexpectedDocumentEnd();
        }
        if (reader.nextTag() != 2) {
            throw reader.unexpectedElement();
        }
        return name == null && authority == null ? rule : rule.matchAbstractType(name, authority);
    }

    private static boolean isSet(int var, int bit) {
        return (var & 1 << bit) != 0;
    }

    private static int setBit(int var, int bit) {
        return var | 1 << bit;
    }

    private static <T, E extends Exception> ExceptionUnaryOperator<T, E> andThenOp(ExceptionUnaryOperator<T, E> first, ExceptionUnaryOperator<T, E> second) {
        return t -> second.apply(first.apply(t));
    }

    private static ExceptionSupplier<CredentialSource, ConfigXMLParseException> parseCredentialsType(ConfigurationXMLStreamReader reader, Version xmlVersion, Map<String, ExceptionSupplier<KeyStore, ConfigXMLParseException>> keyStoresMap, Map<String, ExceptionSupplier<CredentialStore, ConfigXMLParseException>> credentialStoresMap, Supplier<Provider[]> providers) throws ConfigXMLParseException {
        ExceptionUnaryOperator function = parent -> CredentialSource.NONE;
        ElytronXmlParser.requireNoAttributes(reader);
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                ElytronXmlParser.checkElementNamespace(reader, xmlVersion);
                switch (reader.getLocalName()) {
                    case "key-store-reference": {
                        Object supplier = ElytronXmlParser.parseKeyStoreRefType(reader, xmlVersion, keyStoresMap, credentialStoresMap, providers);
                        function = ElytronXmlParser.andThenOp(function, credentialSource -> credentialSource.with(new KeyStoreCredentialSource(new FixedSecurityFactory<Object>(supplier.get()))));
                        break;
                    }
                    case "credential-store-reference": {
                        Object supplier = ElytronXmlParser.parseCredentialStoreRefType(reader, credentialStoresMap);
                        function = ElytronXmlParser.andThenOp(function, credentialSource -> credentialSource.with((CredentialSource)supplier.get()));
                        break;
                    }
                    case "clear-password": {
                        ExceptionSupplier<Password, ConfigXMLParseException> password = ElytronXmlParser.parseClearPassword(reader, providers);
                        function = ElytronXmlParser.andThenOp(function, credentialSource -> credentialSource.with(IdentityCredentials.NONE.withCredential(new PasswordCredential((Password)password.get()))));
                        break;
                    }
                    case "key-pair": {
                        KeyPair keyPair = ElytronXmlParser.parseKeyPair(reader, xmlVersion);
                        function = ElytronXmlParser.andThenOp(function, credentialSource -> credentialSource.with(IdentityCredentials.NONE.withCredential(new KeyPairCredential(keyPair))));
                        break;
                    }
                    case "certificate": {
                        X509CertificateChainPrivateCredential credential = ElytronXmlParser.parseCertificateType(reader, xmlVersion);
                        function = ElytronXmlParser.andThenOp(function, credentialSource -> credentialSource.with(IdentityCredentials.NONE.withCredential(credential)));
                        break;
                    }
                    case "public-key-pem": {
                        PublicKey publicKey = ElytronXmlParser.parsePem(reader, PublicKey.class);
                        function = ElytronXmlParser.andThenOp(function, credentialSource -> credentialSource.with(IdentityCredentials.NONE.withCredential(new PublicKeyCredential(publicKey))));
                        break;
                    }
                    case "bearer-token": {
                        BearerTokenCredential bearerToken = ElytronXmlParser.parseBearerTokenType(reader);
                        function = ElytronXmlParser.andThenOp(function, credentialSource -> credentialSource.with(IdentityCredentials.NONE.withCredential(bearerToken)));
                        break;
                    }
                    case "oauth2-bearer-token": {
                        CredentialSource oauthCredentialSource = ElytronXmlParser.parseOAuth2BearerTokenType(reader, xmlVersion);
                        function = ElytronXmlParser.andThenOp(function, credentialSource -> credentialSource.with(oauthCredentialSource));
                        break;
                    }
                    case "local-kerberos": {
                        if (!xmlVersion.isAtLeast(Version.VERSION_1_1)) {
                            throw reader.unexpectedElement();
                        }
                        CredentialSource kerberosCredentialSource = ElytronXmlParser.parseLocalKerberos(reader);
                        function = ElytronXmlParser.andThenOp(function, credentialSource -> credentialSource.with(kerberosCredentialSource));
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                assert (reader.getLocalName().equals("credentials") || reader.getLocalName().equals("protection-parameter-credentials"));
                ExceptionUnaryOperator finalFunction = function;
                return () -> ElytronXmlParser.lambda$parseCredentialsType$37((ExceptionUnaryOperator)finalFunction);
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    private static KeyPair parseKeyPair(ConfigurationXMLStreamReader reader, Version xmlVersion) throws ConfigXMLParseException {
        ElytronXmlParser.requireNoAttributes(reader);
        PrivateKey privateKey = null;
        PublicKey publicKey = null;
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                ElytronXmlParser.checkElementNamespace(reader, xmlVersion);
                switch (reader.getLocalName()) {
                    case "private-key-pem": {
                        if (privateKey != null) {
                            throw reader.unexpectedElement();
                        }
                        privateKey = ElytronXmlParser.parsePem(reader, PrivateKey.class);
                        break;
                    }
                    case "public-key-pem": {
                        if (publicKey != null) {
                            throw reader.unexpectedElement();
                        }
                        publicKey = ElytronXmlParser.parsePem(reader, PublicKey.class);
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                if (privateKey == null) {
                    throw reader.missingRequiredElement(xmlVersion.namespace, "private-key-pem");
                }
                if (publicKey == null) {
                    throw reader.missingRequiredElement(xmlVersion.namespace, "public-key-pem");
                }
                return new KeyPair(publicKey, privateKey);
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    private static X509CertificateChainPrivateCredential parseCertificateType(ConfigurationXMLStreamReader reader, Version xmlVersion) throws ConfigXMLParseException {
        ElytronXmlParser.requireNoAttributes(reader);
        PrivateKey privateKey = null;
        X509Certificate[] certificates = null;
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                ElytronXmlParser.checkElementNamespace(reader, xmlVersion);
                switch (reader.getLocalName()) {
                    case "private-key-pem": {
                        if (privateKey != null) {
                            throw reader.unexpectedElement();
                        }
                        privateKey = ElytronXmlParser.parsePem(reader, PrivateKey.class);
                        break;
                    }
                    case "pem": {
                        if (certificates != null) {
                            throw reader.unexpectedElement();
                        }
                        certificates = ElytronXmlParser.parseMultiPem(reader, X509Certificate.class, X509Certificate[]::new);
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                if (privateKey == null) {
                    throw reader.missingRequiredElement(xmlVersion.namespace, "private-key-pem");
                }
                if (certificates == null) {
                    throw reader.missingRequiredElement(xmlVersion.namespace, "pem");
                }
                return new X509CertificateChainPrivateCredential(privateKey, certificates);
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    private static <P> P[] parseMultiPem(ConfigurationXMLStreamReader reader, Class<P> pemType, IntFunction<P[]> ctor) throws ConfigXMLParseException {
        ElytronXmlParser.requireNoAttributes(reader);
        Iterator<PemEntry<?>> pemContent = Pem.parsePemContent(CodePointIterator.ofString(reader.getElementText()));
        if (!reader.hasNext()) {
            throw reader.unexpectedDocumentEnd();
        }
        ArrayList<P> arrayList = new ArrayList<P>();
        while (pemContent.hasNext()) {
            PemEntry<?> pemEntry = pemContent.next();
            P pem = pemEntry.tryCast(pemType);
            if (pem == null) {
                throw ElytronMessages.xmlLog.xmlWrongPemType(reader, pemType, pemEntry.getEntry().getClass());
            }
            arrayList.add(pem);
        }
        if (arrayList.isEmpty()) {
            throw ElytronMessages.xmlLog.xmlNoPemContent(reader);
        }
        return arrayList.toArray(ctor.apply(arrayList.size()));
    }

    private static <P> P parsePem(ConfigurationXMLStreamReader reader, Class<P> pemType) throws ConfigXMLParseException {
        ElytronXmlParser.requireNoAttributes(reader);
        Iterator<PemEntry<?>> pemContent = Pem.parsePemContent(CodePointIterator.ofString(reader.getElementText()));
        if (!reader.hasNext()) {
            throw reader.unexpectedDocumentEnd();
        }
        if (!pemContent.hasNext()) {
            throw ElytronMessages.xmlLog.xmlNoPemContent(reader);
        }
        PemEntry<?> pemEntry = pemContent.next();
        P pem = pemEntry.tryCast(pemType);
        if (pem == null) {
            throw ElytronMessages.xmlLog.xmlWrongPemType(reader, pemType, pemEntry.getEntry().getClass());
        }
        return pem;
    }

    static void parseKeyStoresType(ConfigurationXMLStreamReader reader, Version xmlVersion, Map<String, ExceptionSupplier<KeyStore, ConfigXMLParseException>> keyStoresMap, Map<String, ExceptionSupplier<CredentialStore, ConfigXMLParseException>> credentialStoresMap, Supplier<Provider[]> providers) throws ConfigXMLParseException {
        ElytronXmlParser.requireNoAttributes(reader);
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                ElytronXmlParser.checkElementNamespace(reader, xmlVersion);
                switch (reader.getLocalName()) {
                    case "key-store": {
                        ElytronXmlParser.parseKeyStoreType(reader, xmlVersion, keyStoresMap, credentialStoresMap, providers);
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                return;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static void parseKeyStoreType(ConfigurationXMLStreamReader reader, Version xmlVersion, Map<String, ExceptionSupplier<KeyStore, ConfigXMLParseException>> keyStoresMap, Map<String, ExceptionSupplier<CredentialStore, ConfigXMLParseException>> credentialStoresMap, Supplier<Provider[]> providers) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        String name = null;
        String type = null;
        String provider = null;
        Boolean wrap = null;
        block28: for (int i = 0; i < attributeCount; ++i) {
            ElytronXmlParser.checkAttributeNamespace(reader, i);
            switch (reader.getAttributeLocalName(i)) {
                case "type": {
                    if (type != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    type = reader.getAttributeValueResolved(i);
                    continue block28;
                }
                case "provider": {
                    if (provider != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    provider = reader.getAttributeValueResolved(i);
                    continue block28;
                }
                case "name": {
                    if (name != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    name = reader.getAttributeValueResolved(i);
                    continue block28;
                }
                case "wrap-passwords": {
                    if (wrap != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    wrap = Boolean.parseBoolean(reader.getAttributeValueResolved(i));
                    continue block28;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        if (type == null) {
            throw ElytronXmlParser.missingAttribute(reader, "type");
        }
        if (name == null) {
            throw ElytronXmlParser.missingAttribute(reader, "name");
        }
        XMLLocation location = reader.getLocation();
        ExceptionSupplier passwordFactory = null;
        boolean gotSource = false;
        boolean gotCredential = false;
        String fileSource = null;
        ExceptionSupplier<InputStream, IOException> resourceSource = null;
        URI uriSource = null;
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                ElytronXmlParser.checkElementNamespace(reader, xmlVersion);
                switch (reader.getLocalName()) {
                    case "key-store-credential": {
                        if (gotCredential) {
                            throw reader.unexpectedElement();
                        }
                        gotCredential = true;
                        XMLLocation nestedLocation = reader.getLocation();
                        ExceptionSupplier<KeyStore.Entry, ConfigXMLParseException> entryFactory = ElytronXmlParser.parseKeyStoreRefType(reader, xmlVersion, keyStoresMap, credentialStoresMap, providers);
                        passwordFactory = () -> {
                            KeyStore.Entry entry = (KeyStore.Entry)entryFactory.get();
                            if (entry instanceof PasswordEntry) {
                                try {
                                    Password password = ((PasswordEntry)entry).getPassword();
                                    PasswordFactory passwordFactory1 = PasswordFactory.getInstance(password.getAlgorithm());
                                    ClearPasswordSpec passwordSpec = passwordFactory1.getKeySpec(password, ClearPasswordSpec.class);
                                    return passwordSpec.getEncodedPassword();
                                }
                                catch (GeneralSecurityException e) {
                                    throw ElytronMessages.xmlLog.xmlFailedToCreateCredential((Location)nestedLocation, e);
                                }
                            }
                            return null;
                        };
                        break;
                    }
                    case "credential-store-reference": {
                        if (gotCredential || !xmlVersion.isAtLeast(Version.VERSION_1_0_1)) {
                            throw reader.unexpectedElement();
                        }
                        gotCredential = true;
                        XMLLocation nestedLocation = reader.getLocation();
                        ExceptionSupplier<CredentialSource, ConfigXMLParseException> credentialSourceSupplier = ElytronXmlParser.parseCredentialStoreRefType(reader, credentialStoresMap);
                        passwordFactory = () -> {
                            try {
                                return ((CredentialSource)credentialSourceSupplier.get()).applyToCredential(PasswordCredential.class, c -> c.getPassword().castAndApply(ClearPassword.class, ClearPassword::getPassword));
                            }
                            catch (IOException e) {
                                throw ElytronMessages.xmlLog.xmlFailedToCreateCredential((Location)nestedLocation, e);
                            }
                        };
                        break;
                    }
                    case "key-store-clear-password": {
                        if (gotCredential) {
                            throw reader.unexpectedElement();
                        }
                        gotCredential = true;
                        char[] clearPassword = ((ClearPassword)ElytronXmlParser.parseClearPassword(reader, providers).get()).getPassword();
                        passwordFactory = () -> clearPassword;
                        break;
                    }
                    case "file": {
                        if (gotSource || gotCredential) {
                            throw reader.unexpectedElement();
                        }
                        gotSource = true;
                        fileSource = ElytronXmlParser.parseNameType(reader);
                        break;
                    }
                    case "resource": {
                        if (gotSource || gotCredential) {
                            throw reader.unexpectedElement();
                        }
                        gotSource = true;
                        resourceSource = ElytronXmlParser.parseResourceType(reader, xmlVersion);
                        break;
                    }
                    case "uri": {
                        if (gotSource || gotCredential) {
                            throw reader.unexpectedElement();
                        }
                        gotSource = true;
                        uriSource = ElytronXmlParser.parseUriType(reader);
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                Object keyStoreFactory = new KeyStoreCreateFactory(provider, type, location);
                if (wrap == Boolean.TRUE) {
                    keyStoreFactory = new PasswordKeyStoreFactory((ExceptionSupplier<KeyStore, ConfigXMLParseException>)keyStoreFactory);
                }
                keyStoreFactory = fileSource != null ? new FileLoadingKeyStoreFactory((ExceptionSupplier<KeyStore, ConfigXMLParseException>)keyStoreFactory, (ExceptionSupplier<char[], ConfigXMLParseException>)passwordFactory, fileSource, location) : (resourceSource != null ? new ResourceLoadingKeyStoreFactory((ExceptionSupplier<KeyStore, ConfigXMLParseException>)keyStoreFactory, (ExceptionSupplier<char[], ConfigXMLParseException>)passwordFactory, resourceSource, location) : (uriSource != null ? new URILoadingKeyStoreFactory((ExceptionSupplier<KeyStore, ConfigXMLParseException>)keyStoreFactory, (ExceptionSupplier<char[], ConfigXMLParseException>)passwordFactory, uriSource, location) : new NullLoadingKeyStoreFactory((ExceptionSupplier<KeyStore, ConfigXMLParseException>)keyStoreFactory, (ExceptionSupplier<char[], ConfigXMLParseException>)passwordFactory, location)));
                keyStoresMap.put(name, (ExceptionSupplier<KeyStore, ConfigXMLParseException>)keyStoreFactory);
                return;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static ExceptionSupplier<KeyStore.Entry, ConfigXMLParseException> parseKeyStoreRefType(ConfigurationXMLStreamReader reader, Version xmlVersion, Map<String, ExceptionSupplier<KeyStore, ConfigXMLParseException>> keyStoresMap, Map<String, ExceptionSupplier<CredentialStore, ConfigXMLParseException>> credentialStoresMap, Supplier<Provider[]> providers) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        XMLLocation location = reader.getLocation();
        String keyStoreName = null;
        String alias = null;
        block18: for (int i = 0; i < attributeCount; ++i) {
            ElytronXmlParser.checkAttributeNamespace(reader, i);
            switch (reader.getAttributeLocalName(i)) {
                case "key-store-name": {
                    if (keyStoreName != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    keyStoreName = reader.getAttributeValueResolved(i);
                    continue block18;
                }
                case "alias": {
                    if (alias != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    alias = reader.getAttributeValueResolved(i);
                    continue block18;
                }
                default: {
                    throw reader.unexpectedElement();
                }
            }
        }
        if (keyStoreName == null) {
            throw ElytronXmlParser.missingAttribute(reader, "key-store-name");
        }
        ExceptionSupplier keyStoreCredential = null;
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                ElytronXmlParser.checkElementNamespace(reader, xmlVersion);
                switch (reader.getLocalName()) {
                    case "key-store-credential": {
                        if (keyStoreCredential != null) {
                            throw reader.unexpectedElement();
                        }
                        keyStoreCredential = ElytronXmlParser.parseKeyStoreRefType(reader, xmlVersion, keyStoresMap, credentialStoresMap, providers);
                        break;
                    }
                    case "key-store-clear-password": {
                        if (keyStoreCredential != null) {
                            throw reader.unexpectedElement();
                        }
                        ExceptionSupplier<Password, ConfigXMLParseException> credential = ElytronXmlParser.parseClearPassword(reader, providers);
                        keyStoreCredential = () -> new PasswordEntry((Password)credential.get());
                        break;
                    }
                    case "credential-store-reference": {
                        if (keyStoreCredential != null || !xmlVersion.isAtLeast(Version.VERSION_1_0_1)) {
                            throw reader.unexpectedElement();
                        }
                        XMLLocation nestedLocation = reader.getLocation();
                        ExceptionSupplier<CredentialSource, ConfigXMLParseException> credentialSourceSupplier = ElytronXmlParser.parseCredentialStoreRefType(reader, credentialStoresMap);
                        keyStoreCredential = () -> {
                            try {
                                PasswordCredential passwordCredential = ((CredentialSource)credentialSourceSupplier.get()).getCredential(PasswordCredential.class);
                                if (passwordCredential == null) {
                                    throw new ConfigXMLParseException((Throwable)ElytronMessages.xmlLog.couldNotObtainCredential(), (XMLStreamReader)reader);
                                }
                                return new PasswordEntry(passwordCredential.getPassword());
                            }
                            catch (IOException e) {
                                throw ElytronMessages.xmlLog.xmlFailedToCreateCredential((Location)nestedLocation, e);
                            }
                        };
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                ExceptionSupplier finalKeyStoreCredential = keyStoreCredential;
                String finalKeyStoreName = keyStoreName;
                String finalAlias = alias;
                return () -> {
                    try {
                        KeyStore.PasswordProtection protectionParameter;
                        KeyStore.Entry entry;
                        ExceptionSupplier keyStoreSupplier = (ExceptionSupplier)keyStoresMap.get(finalKeyStoreName);
                        if (keyStoreSupplier == null) {
                            throw ElytronMessages.xmlLog.xmlUnknownKeyStoreSpecified((Location)location);
                        }
                        KeyStore.Entry entry2 = entry = finalKeyStoreCredential == null ? null : (KeyStore.Entry)finalKeyStoreCredential.get();
                        if (entry instanceof PasswordEntry) {
                            Password password = ((PasswordEntry)entry).getPassword();
                            PasswordFactory passwordFactory = PasswordFactory.getInstance(password.getAlgorithm());
                            password = passwordFactory.translate(password);
                            ClearPasswordSpec spec = passwordFactory.getKeySpec(password, ClearPasswordSpec.class);
                            protectionParameter = new KeyStore.PasswordProtection(spec.getEncodedPassword());
                        } else {
                            SecretKey secretKey;
                            SecretKeyFactory instance;
                            SecretKeySpec keySpec;
                            byte[] encoded;
                            protectionParameter = entry instanceof KeyStore.SecretKeyEntry ? ((encoded = (keySpec = (SecretKeySpec)(instance = SecretKeyFactory.getInstance((secretKey = ((KeyStore.SecretKeyEntry)entry).getSecretKey()).getAlgorithm())).getKeySpec(secretKey, SecretKeySpec.class)).getEncoded()) == null ? null : new KeyStore.PasswordProtection(new String(encoded, StandardCharsets.UTF_8).toCharArray())) : null;
                        }
                        if (finalAlias != null) {
                            KeyStore.Entry finalEntry = ((KeyStore)keyStoreSupplier.get()).getEntry(finalAlias, protectionParameter == null ? null : protectionParameter);
                            if (finalEntry == null) {
                                throw ElytronMessages.xmlLog.keyStoreEntryMissing((Location)location, finalAlias);
                            }
                            return finalEntry;
                        }
                        if (((KeyStore)keyStoreSupplier.get()).size() > 1) {
                            throw ElytronMessages.xmlLog.missingAlias((Location)location);
                        }
                        if (((KeyStore)keyStoreSupplier.get()).aliases().hasMoreElements()) {
                            String firstAlias = ((KeyStore)keyStoreSupplier.get()).aliases().nextElement();
                            KeyStore.Entry finalEntry = ((KeyStore)keyStoreSupplier.get()).getEntry(firstAlias, protectionParameter == null ? null : protectionParameter);
                            if (finalEntry == null) {
                                throw ElytronMessages.xmlLog.keyStoreEntryMissing((Location)location, firstAlias);
                            }
                            return finalEntry;
                        }
                        return null;
                    }
                    catch (GeneralSecurityException e) {
                        throw ElytronMessages.xmlLog.xmlFailedToLoadKeyStoreData((Location)location, e);
                    }
                };
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static ExceptionSupplier<KeyStore, ConfigXMLParseException> parseTrustStoreRefType(ConfigurationXMLStreamReader reader, Map<String, ExceptionSupplier<KeyStore, ConfigXMLParseException>> keyStoresMap) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        XMLLocation location = reader.getLocation();
        String keyStoreName = null;
        Object alias = null;
        block6: for (int i = 0; i < attributeCount; ++i) {
            ElytronXmlParser.checkAttributeNamespace(reader, i);
            switch (reader.getAttributeLocalName(i)) {
                case "key-store-name": {
                    if (keyStoreName != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    keyStoreName = reader.getAttributeValueResolved(i);
                    continue block6;
                }
                default: {
                    throw reader.unexpectedElement();
                }
            }
        }
        if (keyStoreName == null) {
            throw ElytronXmlParser.missingAttribute(reader, "key-store-name");
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                String finalKeyStoreName = keyStoreName;
                ExceptionSupplier<KeyStore, ConfigXMLParseException> keyStoreSupplier = keyStoresMap.get(finalKeyStoreName);
                if (keyStoreSupplier == null) {
                    throw ElytronMessages.xmlLog.xmlUnknownKeyStoreSpecified((Location)location);
                }
                return keyStoreSupplier;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static ExceptionSupplier<CredentialSource, ConfigXMLParseException> parseCredentialStoreRefType(ConfigurationXMLStreamReader reader, Map<String, ExceptionSupplier<CredentialStore, ConfigXMLParseException>> credentialStoresMap) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        String storeName = null;
        String alias = null;
        String clearText = null;
        block10: for (int i = 0; i < attributeCount; ++i) {
            ElytronXmlParser.checkAttributeNamespace(reader, i);
            switch (reader.getAttributeLocalName(i)) {
                case "store": {
                    if (storeName != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    storeName = reader.getAttributeValueResolved(i);
                    continue block10;
                }
                case "alias": {
                    if (alias != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    alias = reader.getAttributeValueResolved(i);
                    continue block10;
                }
                case "clear-text": {
                    if (clearText != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    clearText = reader.getAttributeValueResolved(i);
                    continue block10;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        if (!reader.hasNext()) {
            throw reader.unexpectedDocumentEnd();
        }
        if (reader.nextTag() != 2) {
            throw reader.unexpectedContent();
        }
        return ElytronXmlParser.createCredentialStoreSupplier(reader.getLocation(), storeName, alias, clearText, credentialStoresMap);
    }

    private static ExceptionSupplier<CredentialSource, ConfigXMLParseException> createCredentialStoreSupplier(XMLLocation location, String storeName, String alias, String clearText, Map<String, ExceptionSupplier<CredentialStore, ConfigXMLParseException>> credentialStoresMap) {
        return () -> {
            if (storeName != null) {
                ExceptionSupplier supplier = (ExceptionSupplier)credentialStoresMap.get(storeName);
                if (supplier == null) {
                    throw ElytronMessages.xmlLog.xmlCredentialStoreNameNotDefined((Location)location, storeName);
                }
                CredentialStore credentialStore = (CredentialStore)supplier.get();
                return new CredentialStoreCredentialSource(credentialStore, alias);
            }
            if (clearText != null) {
                PasswordCredential passwordCredential = new PasswordCredential(ClearPassword.createRaw("clear", clearText.toCharArray()));
                return IdentityCredentials.NONE.withCredential(passwordCredential);
            }
            throw ElytronMessages.xmlLog.xmlInvalidCredentialStoreRef((Location)location);
        };
    }

    private static void parseCredentialStoresType(ConfigurationXMLStreamReader reader, Version xmlVersion, Map<String, ExceptionSupplier<KeyStore, ConfigXMLParseException>> keyStoresMap, Map<String, ExceptionSupplier<CredentialStore, ConfigXMLParseException>> credentialStoresMap, Supplier<Provider[]> providers) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        if (attributeCount > 0) {
            throw reader.unexpectedAttribute(0);
        }
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                ElytronXmlParser.checkElementNamespace(reader, xmlVersion);
                switch (reader.getLocalName()) {
                    case "credential-store": {
                        ElytronXmlParser.parseCredentialStoreType(reader, xmlVersion, keyStoresMap, credentialStoresMap, providers);
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                return;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    private static void parseCredentialStoreType(ConfigurationXMLStreamReader reader, Version xmlVersion, Map<String, ExceptionSupplier<KeyStore, ConfigXMLParseException>> keyStoresMap, Map<String, ExceptionSupplier<CredentialStore, ConfigXMLParseException>> credentialStoresMap, Supplier<Provider[]> providers) throws ConfigXMLParseException {
        XMLLocation location = reader.getLocation();
        int attributeCount = reader.getAttributeCount();
        String name = null;
        String type = null;
        String provider = null;
        block20: for (int i = 0; i < attributeCount; ++i) {
            String attributeNamespace = reader.getAttributeNamespace(i);
            if (attributeNamespace != null && !attributeNamespace.isEmpty()) {
                throw reader.unexpectedAttribute(i);
            }
            switch (reader.getAttributeLocalName(i)) {
                case "type": {
                    if (type != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    type = reader.getAttributeValueResolved(i);
                    continue block20;
                }
                case "provider": {
                    if (provider != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    provider = reader.getAttributeValueResolved(i);
                    continue block20;
                }
                case "name": {
                    if (name != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    name = reader.getAttributeValueResolved(i);
                    continue block20;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        if (name == null) {
            throw ElytronXmlParser.missingAttribute(reader, "name");
        }
        HashMap<String, String> attributesMap = new HashMap<String, String>();
        int foundBits = 0;
        ExceptionSupplier<CredentialSource, ConfigXMLParseException> credentialSourceSupplier = null;
        DeferredSupplier<Provider[]> providersSupplier = new DeferredSupplier<Provider[]>(providers);
        block21: while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                ElytronXmlParser.checkElementNamespace(reader, xmlVersion);
                switch (reader.getLocalName()) {
                    case "attributes": {
                        if (ElytronXmlParser.isSet(foundBits, 1)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 1);
                        ElytronXmlParser.parseAttributesType(reader, xmlVersion, attributesMap);
                        break;
                    }
                    case "protection-parameter-credentials": {
                        if (ElytronXmlParser.isSet(foundBits, 2)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 2);
                        credentialSourceSupplier = ElytronXmlParser.parseCredentialsType(reader, xmlVersion, keyStoresMap, credentialStoresMap, providersSupplier);
                        break;
                    }
                    case "providers": {
                        if (ElytronXmlParser.isSet(foundBits, 3)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 3);
                        Supplier<Provider[]> supplier = ElytronXmlParser.parseProvidersType(reader, xmlVersion);
                        if (supplier == null) continue block21;
                        providersSupplier.setSupplier(supplier);
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                if (credentialStoresMap.containsKey(name)) {
                    throw ElytronMessages.xmlLog.duplicateCredentialStoreName((XMLStreamReader)reader, name);
                }
                CredentialStoreFactory credentialStoreSecurityFactory = new CredentialStoreFactory(name, type, attributesMap, provider, location, credentialSourceSupplier, providersSupplier);
                credentialStoresMap.put(name, credentialStoreSecurityFactory);
                return;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    private static void parseAttributesType(ConfigurationXMLStreamReader reader, Version xmlVersion, Map<String, String> attributesMap) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        if (attributeCount > 0) {
            throw reader.unexpectedAttribute(0);
        }
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                ElytronXmlParser.checkElementNamespace(reader, xmlVersion);
                switch (reader.getLocalName()) {
                    case "attribute": {
                        ElytronXmlParser.parseAttributeType(reader, attributesMap);
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                return;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    private static void parseAttributeType(ConfigurationXMLStreamReader reader, Map<String, String> attributesMap) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        String name = null;
        String value = null;
        block8: for (int i = 0; i < attributeCount; ++i) {
            String attributeNamespace = reader.getAttributeNamespace(i);
            if (attributeNamespace != null && !attributeNamespace.isEmpty()) {
                throw reader.unexpectedAttribute(i);
            }
            switch (reader.getAttributeLocalName(i)) {
                case "name": {
                    if (name != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    name = reader.getAttributeValueResolved(i);
                    continue block8;
                }
                case "value": {
                    if (value != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    value = reader.getAttributeValueResolved(i);
                    continue block8;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedContent();
            }
            if (tag == 2) {
                if (attributesMap.containsKey(name)) {
                    throw ElytronMessages.xmlLog.duplicateAttributeFound((XMLStreamReader)reader, name);
                }
                attributesMap.put(name, value);
                return;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedContent();
    }

    static void parseEmptyType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        ElytronXmlParser.requireNoAttributes(reader);
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                return;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static String parseNameType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        return ElytronXmlParser.parseNameType(reader, false);
    }

    static String parseNameType(ConfigurationXMLStreamReader reader, boolean optional) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        String name = null;
        for (int i = 0; i < attributeCount; ++i) {
            ElytronXmlParser.checkAttributeNamespace(reader, i);
            if (!reader.getAttributeLocalName(i).equals("name")) {
                throw reader.unexpectedAttribute(i);
            }
            name = reader.getAttributeValueResolved(i);
        }
        if (name == null && !optional) {
            throw ElytronXmlParser.missingAttribute(reader, "name");
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                return name;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static ExceptionSupplier<InputStream, IOException> parseResourceType(ConfigurationXMLStreamReader reader, Version xmlVersion) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        String name = null;
        String module = null;
        for (int i = 0; i < attributeCount; ++i) {
            ElytronXmlParser.checkAttributeNamespace(reader, i);
            if (reader.getAttributeLocalName(i).equals("name")) {
                name = reader.getAttributeValueResolved(i);
                continue;
            }
            if (reader.getAttributeLocalName(i).equals("module-name") && xmlVersion.isAtLeast(Version.VERSION_1_1)) {
                module = reader.getAttributeValueResolved(i);
                continue;
            }
            throw reader.unexpectedAttribute(i);
        }
        if (name == null) {
            throw ElytronXmlParser.missingAttribute(reader, "name");
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                String resourceName = name;
                ClassLoader classLoader = module != null ? ModuleLoader.getClassLoaderFromModule((XMLStreamReader)reader, module) : Thread.currentThread().getContextClassLoader();
                return () -> {
                    ClassLoader actualClassLoader = classLoader != null ? classLoader : ElytronXmlParser.class.getClassLoader();
                    InputStream stream = actualClassLoader.getResourceAsStream(resourceName);
                    if (stream == null) {
                        throw new FileNotFoundException(resourceName);
                    }
                    return stream;
                };
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static int parsePortType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        int number = -1;
        for (int i = 0; i < attributeCount; ++i) {
            ElytronXmlParser.checkAttributeNamespace(reader, i);
            if (reader.getAttributeLocalName(i).equals("number")) {
                String s = reader.getAttributeValueResolved(i);
                try {
                    number = Integer.parseInt(s);
                }
                catch (NumberFormatException ignored) {
                    throw ElytronXmlParser.invalidPortNumber(reader, i);
                }
                if (number >= 1 && number <= 65535) continue;
                throw ElytronXmlParser.invalidPortNumber(reader, i);
            }
            throw reader.unexpectedAttribute(i);
        }
        if (number == -1) {
            throw ElytronXmlParser.missingAttribute(reader, "number");
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                return number;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static NameRewriter parseRegexSubstitutionType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        Pattern pattern = null;
        String replacement = null;
        for (int i = 0; i < attributeCount; ++i) {
            ElytronXmlParser.checkAttributeNamespace(reader, i);
            if (reader.getAttributeLocalName(i).equals("pattern")) {
                pattern = Pattern.compile(reader.getAttributeValueResolved(i));
                continue;
            }
            if (reader.getAttributeLocalName(i).equals("replacement")) {
                replacement = reader.getAttributeValueResolved(i);
                continue;
            }
            throw reader.unexpectedAttribute(i);
        }
        if (pattern == null) {
            throw ElytronXmlParser.missingAttribute(reader, "pattern");
        }
        if (replacement == null) {
            throw ElytronXmlParser.missingAttribute(reader, "replacement");
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                return new RegexNameRewriter(pattern, replacement, true);
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static String[] parseNamesType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        String[] names = null;
        for (int i = 0; i < attributeCount; ++i) {
            ElytronXmlParser.checkAttributeNamespace(reader, i);
            if (!reader.getAttributeLocalName(i).equals("names")) {
                throw reader.unexpectedAttribute(i);
            }
            String s = reader.getAttributeValueResolved(i);
            names = s.trim().split("\\s+");
        }
        if (names == null) {
            throw ElytronXmlParser.missingAttribute(reader, "names");
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                return names;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static URI parseUriType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        URI uri = null;
        for (int i = 0; i < attributeCount; ++i) {
            ElytronXmlParser.checkAttributeNamespace(reader, i);
            if (!reader.getAttributeLocalName(i).equals("uri")) {
                throw reader.unexpectedAttribute(i);
            }
            uri = reader.getURIAttributeValueResolved(i);
        }
        if (uri == null) {
            throw ElytronXmlParser.missingAttribute(reader, "uri");
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                return uri;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static SaslMechanismSelector parseSaslMechanismSelectorType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        SaslMechanismSelector selector = null;
        for (int i = 0; i < attributeCount; ++i) {
            ElytronXmlParser.checkAttributeNamespace(reader, i);
            if (!reader.getAttributeLocalName(i).equals("selector")) {
                throw reader.unexpectedAttribute(i);
            }
            selector = SaslMechanismSelector.fromString(reader.getAttributeValueResolved(i));
        }
        if (selector == null) {
            throw ElytronXmlParser.missingAttribute(reader, "selector");
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                return selector;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static CipherSuiteSelector parseCipherSuiteSelectorType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        CipherSuiteSelector selector = null;
        for (int i = 0; i < attributeCount; ++i) {
            ElytronXmlParser.checkAttributeNamespace(reader, i);
            if (!reader.getAttributeLocalName(i).equals("selector")) {
                throw reader.unexpectedAttribute(i);
            }
            selector = CipherSuiteSelector.fromString(reader.getAttributeValueResolved(i));
        }
        if (selector == null) {
            throw ElytronXmlParser.missingAttribute(reader, "selector");
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                return selector;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static ProtocolSelector parseProtocolSelectorNamesType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        ProtocolSelector selector = ProtocolSelector.empty();
        for (String name : ElytronXmlParser.parseNamesType(reader)) {
            selector = selector.add(name);
        }
        return selector;
    }

    static String parseModuleRefType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        String moduleName = null;
        for (int i = 0; i < attributeCount; ++i) {
            ElytronXmlParser.checkAttributeNamespace(reader, i);
            if (!reader.getAttributeLocalName(i).equals("module-name")) {
                throw reader.unexpectedAttribute(i);
            }
            moduleName = reader.getAttributeValueResolved(i);
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                return moduleName;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static ExceptionSupplier<Password, ConfigXMLParseException> parseClearPassword(ConfigurationXMLStreamReader reader, Supplier<Provider[]> providers) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        char[] password = null;
        for (int i = 0; i < attributeCount; ++i) {
            ElytronXmlParser.checkAttributeNamespace(reader, i);
            if (!reader.getAttributeLocalName(i).equals("password")) {
                throw reader.unexpectedAttribute(i);
            }
            password = reader.getAttributeValueResolved(i).toCharArray();
        }
        if (password == null) {
            throw ElytronXmlParser.missingAttribute(reader, "password");
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                XMLLocation location = reader.getLocation();
                char[] finalPassword = password;
                return () -> {
                    try {
                        PasswordFactory factory = PasswordFactory.getInstance("clear", providers);
                        return (Password)Assert.assertNotNull((Object)factory.generatePassword(new ClearPasswordSpec(finalPassword)).castAs(ClearPassword.class));
                    }
                    catch (NoSuchAlgorithmException | InvalidKeySpecException cause) {
                        throw ElytronMessages.xmlLog.xmlFailedToCreateCredential((Location)location, cause);
                    }
                };
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static Map<String, String> parsePropertiesType(ConfigurationXMLStreamReader reader, Version xmlVersion) throws ConfigXMLParseException {
        if (reader.getAttributeCount() > 0) {
            throw reader.unexpectedAttribute(0);
        }
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                ElytronXmlParser.checkElementNamespace(reader, xmlVersion);
                switch (reader.getLocalName()) {
                    case "property": {
                        int attributeCount = reader.getAttributeCount();
                        String key = null;
                        String value = null;
                        block15: for (int i = 0; i < attributeCount; ++i) {
                            ElytronXmlParser.checkAttributeNamespace(reader, i);
                            switch (reader.getAttributeLocalName(i)) {
                                case "key": {
                                    if (key != null) {
                                        throw reader.unexpectedAttribute(i);
                                    }
                                    key = reader.getAttributeValueResolved(i);
                                    continue block15;
                                }
                                case "value": {
                                    if (value != null) {
                                        throw reader.unexpectedAttribute(i);
                                    }
                                    value = reader.getAttributeValueResolved(i);
                                    continue block15;
                                }
                                default: {
                                    throw reader.unexpectedAttribute(i);
                                }
                            }
                        }
                        if (key == null) {
                            throw ElytronXmlParser.missingAttribute(reader, "key");
                        }
                        if (value == null) {
                            throw ElytronXmlParser.missingAttribute(reader, "value");
                        }
                        propertiesMap.put(key, value);
                        if (reader.hasNext()) {
                            int innerTag = reader.nextTag();
                            if (innerTag == 1) {
                                throw reader.unexpectedElement();
                            }
                            if (innerTag == 2) break;
                            throw reader.unexpectedContent();
                        }
                        throw reader.unexpectedDocumentEnd();
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                return propertiesMap;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static BearerTokenCredential parseBearerTokenType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        String value = ElytronXmlParser.requireSingleAttribute(reader, "value");
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                return new BearerTokenCredential(value);
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static CredentialSource parseOAuth2BearerTokenType(ConfigurationXMLStreamReader reader, Version xmlVersion) throws ConfigXMLParseException {
        OAuth2CredentialSource.Builder builder;
        URI tokenEndpointUri = ElytronXmlParser.requireSingleURIAttribute(reader, "token-endpoint-uri");
        try {
            builder = OAuth2CredentialSource.builder(tokenEndpointUri.toURL());
        }
        catch (MalformedURLException e) {
            throw ElytronMessages.xmlLog.xmlInvalidUrl(tokenEndpointUri.toString());
        }
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                ElytronXmlParser.checkElementNamespace(reader, xmlVersion);
                switch (reader.getLocalName()) {
                    case "resource-owner-credentials": {
                        builder = ElytronXmlParser.parseOAuth2ResourceOwnerCredentials(reader, builder);
                        break;
                    }
                    case "client-credentials": {
                        builder = ElytronXmlParser.parseOAuth2ClientCredentials(reader, builder);
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                return builder.build();
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static OAuth2CredentialSource.Builder parseOAuth2ResourceOwnerCredentials(ConfigurationXMLStreamReader reader, OAuth2CredentialSource.Builder builder) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        String userName = null;
        String password = null;
        block8: for (int i = 0; i < attributeCount; ++i) {
            ElytronXmlParser.checkAttributeNamespace(reader, i);
            switch (reader.getAttributeLocalName(i)) {
                case "name": {
                    if (userName != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    userName = reader.getAttributeValueResolved(i);
                    continue block8;
                }
                case "password": {
                    if (password != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    password = reader.getAttributeValueResolved(i);
                    continue block8;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                if (userName != null && password != null) {
                    return builder.useResourceOwnerPassword(userName, password);
                }
                return builder;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static OAuth2CredentialSource.Builder parseOAuth2ClientCredentials(ConfigurationXMLStreamReader reader, OAuth2CredentialSource.Builder builder) throws ConfigXMLParseException {
        String id = null;
        String secret = null;
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ElytronXmlParser.checkAttributeNamespace(reader, i);
            switch (reader.getAttributeLocalName(i)) {
                case "client-id": {
                    if (id != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    id = reader.getAttributeValueResolved(i);
                    continue block8;
                }
                case "client-secret": {
                    if (secret != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    secret = reader.getAttributeValueResolved(i);
                    continue block8;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                if (id != null && secret != null) {
                    return builder.clientCredentials(id, secret);
                }
                return builder;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static CredentialSource parseLocalKerberos(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        LinkedList<Oid> mechanismOids = new LinkedList<Oid>();
        for (int i = 0; i < attributeCount; ++i) {
            ElytronXmlParser.checkAttributeNamespace(reader, i);
            if (reader.getAttributeLocalName(i).equals("mechanism-names")) {
                for (String name : reader.getListAttributeValueAsArrayResolved(i)) {
                    String oid = OidsUtil.attributeNameToOid(OidsUtil.Category.GSS, name);
                    if (oid == null) {
                        throw ElytronMessages.xmlLog.xmlInvalidGssMechanismName((XMLStreamReader)reader, name);
                    }
                    try {
                        mechanismOids.add(new Oid(oid));
                    }
                    catch (GSSException e) {
                        throw ElytronMessages.xmlLog.xmlGssMechanismOidConversionFailed((XMLStreamReader)reader, oid, e);
                    }
                }
                continue;
            }
            if (reader.getAttributeLocalName(i).equals("mechanism-oids")) {
                for (String oid : reader.getListAttributeValueAsArrayResolved(i)) {
                    try {
                        mechanismOids.add(new Oid(oid));
                    }
                    catch (GSSException e) {
                        throw ElytronMessages.xmlLog.xmlGssMechanismOidConversionFailed((XMLStreamReader)reader, oid, e);
                    }
                }
                continue;
            }
            throw reader.unexpectedAttribute(i);
        }
        if (mechanismOids.size() == 0) {
            mechanismOids.add(GSSCredentialSecurityFactory.KERBEROS_V5);
            mechanismOids.add(GSSCredentialSecurityFactory.SPNEGO);
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                return LocalKerberosCredentialSource.builder().setMechanismOids(mechanismOids.toArray(new Oid[mechanismOids.size()])).build();
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    private static String checkGetElementNamespace(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        String namespaceUri = reader.getNamespaceURI();
        if (!KNOWN_NAMESPACES.containsKey(namespaceUri)) {
            throw reader.unexpectedElement();
        }
        return namespaceUri;
    }

    private static void checkElementNamespace(ConfigurationXMLStreamReader reader, Version xmlVersion) throws ConfigXMLParseException {
        if (!xmlVersion.namespace.equals(reader.getNamespaceURI())) {
            throw reader.unexpectedElement();
        }
    }

    private static void checkAttributeNamespace(ConfigurationXMLStreamReader reader, int idx) throws ConfigXMLParseException {
        String attributeNamespace = reader.getAttributeNamespace(idx);
        if (attributeNamespace != null && !attributeNamespace.isEmpty()) {
            throw reader.unexpectedAttribute(idx);
        }
    }

    private static void requireNoAttributes(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        if (attributeCount > 0) {
            throw reader.unexpectedAttribute(0);
        }
    }

    private static String requireSingleAttribute(ConfigurationXMLStreamReader reader, String attributeName) throws ConfigXMLParseException {
        return (String)ElytronXmlParser.requireSingleAttribute(reader, attributeName, () -> reader.getAttributeValueResolved(0));
    }

    private static URI requireSingleURIAttribute(ConfigurationXMLStreamReader reader, String attributeName) throws ConfigXMLParseException {
        return (URI)ElytronXmlParser.requireSingleAttribute(reader, attributeName, () -> reader.getURIAttributeValueResolved(0));
    }

    private static <A> A requireSingleAttribute(ConfigurationXMLStreamReader reader, String attributeName, ExceptionSupplier<A, ConfigXMLParseException> attributeFunction) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        if (attributeCount < 1) {
            throw reader.missingRequiredAttribute("", attributeName);
        }
        ElytronXmlParser.checkAttributeNamespace(reader, 0);
        if (!reader.getAttributeLocalName(0).equals(attributeName)) {
            throw reader.unexpectedAttribute(0);
        }
        if (attributeCount > 1) {
            throw reader.unexpectedAttribute(1);
        }
        return (A)attributeFunction.get();
    }

    private static ConfigXMLParseException missingAttribute(ConfigurationXMLStreamReader reader, String name) {
        return reader.missingRequiredAttribute(null, name);
    }

    private static ConfigXMLParseException invalidPortNumber(ConfigurationXMLStreamReader reader, int index) throws ConfigXMLParseException {
        return ElytronMessages.xmlLog.xmlInvalidPortNumber((XMLStreamReader)reader, reader.getAttributeValueResolved(index), reader.getAttributeLocalName(index), reader.getName());
    }

    private static /* synthetic */ CredentialSource lambda$parseCredentialsType$37(ExceptionUnaryOperator finalFunction) throws ConfigXMLParseException {
        return (CredentialSource)finalFunction.apply(null);
    }

    static {
        HashMap<String, Version> knownNamespaces = new HashMap<String, Version>();
        for (Version version : Version.values()) {
            knownNamespaces.put(version.namespace, version);
        }
        KNOWN_NAMESPACES = Collections.unmodifiableMap(knownNamespaces);
    }

    static final class DeferredSupplier<T>
    implements Supplier<T> {
        private volatile Supplier<T> supplier;
        private T value;

        DeferredSupplier(Supplier<T> supplier) {
            Assert.checkNotNullParam((String)"supplier", supplier);
            this.supplier = supplier;
        }

        void setSupplier(Supplier<T> supplier) {
            Assert.checkNotNullParam((String)"supplier", supplier);
            this.supplier = supplier;
        }

        @Override
        public T get() {
            return this.supplier.get();
        }
    }

    static final class PrivateKeyKeyStoreEntryCredentialFactory
    implements ExceptionSupplier<X509CertificateChainPrivateCredential, ConfigXMLParseException> {
        private final ExceptionSupplier<KeyStore.Entry, ConfigXMLParseException> entrySupplier;
        private final XMLLocation location;

        PrivateKeyKeyStoreEntryCredentialFactory(ExceptionSupplier<KeyStore.Entry, ConfigXMLParseException> entrySupplier, XMLLocation location) {
            this.entrySupplier = entrySupplier;
            this.location = location;
        }

        public X509CertificateChainPrivateCredential get() throws ConfigXMLParseException {
            KeyStore.Entry entry = (KeyStore.Entry)this.entrySupplier.get();
            if (entry == null) {
                throw ElytronMessages.xmlLog.keyStoreEntryMissing((Location)this.location, "unknown");
            }
            if (entry instanceof KeyStore.PrivateKeyEntry) {
                KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)entry;
                X509Certificate[] certificateChain = X500.asX509CertificateArray(privateKeyEntry.getCertificateChain());
                return new X509CertificateChainPrivateCredential(privateKeyEntry.getPrivateKey(), certificateChain);
            }
            throw ElytronMessages.xmlLog.xmlInvalidKeyStoreEntryType((Location)this.location, "unknown", KeyStore.PrivateKeyEntry.class, entry.getClass());
        }
    }

    static final class NullLoadingKeyStoreFactory
    extends AbstractLoadingKeyStoreFactory {
        NullLoadingKeyStoreFactory(ExceptionSupplier<KeyStore, ConfigXMLParseException> delegateFactory, ExceptionSupplier<char[], ConfigXMLParseException> passwordFactory, XMLLocation location) {
            super(delegateFactory, passwordFactory, location);
        }

        @Override
        InputStream createStream() throws IOException {
            return null;
        }
    }

    static final class URILoadingKeyStoreFactory
    extends AbstractLoadingKeyStoreFactory {
        private final URI uri;

        URILoadingKeyStoreFactory(ExceptionSupplier<KeyStore, ConfigXMLParseException> delegateFactory, ExceptionSupplier<char[], ConfigXMLParseException> passwordFactory, URI uri, XMLLocation location) {
            super(delegateFactory, passwordFactory, location);
            this.uri = uri;
        }

        @Override
        InputStream createStream() throws IOException {
            return this.uri.toURL().openStream();
        }
    }

    static final class ResourceLoadingKeyStoreFactory
    extends AbstractLoadingKeyStoreFactory {
        private final ExceptionSupplier<InputStream, IOException> resourceSupplier;

        ResourceLoadingKeyStoreFactory(ExceptionSupplier<KeyStore, ConfigXMLParseException> delegateFactory, ExceptionSupplier<char[], ConfigXMLParseException> passwordFactory, ExceptionSupplier<InputStream, IOException> resourceSupplier, XMLLocation location) {
            super(delegateFactory, passwordFactory, location);
            this.resourceSupplier = resourceSupplier;
        }

        @Override
        InputStream createStream() throws IOException {
            return (InputStream)this.resourceSupplier.get();
        }
    }

    static final class FileLoadingKeyStoreFactory
    extends AbstractLoadingKeyStoreFactory {
        private final String fileName;

        FileLoadingKeyStoreFactory(ExceptionSupplier<KeyStore, ConfigXMLParseException> delegateFactory, ExceptionSupplier<char[], ConfigXMLParseException> passwordFactory, String fileName, XMLLocation location) {
            super(delegateFactory, passwordFactory, location);
            this.fileName = fileName;
        }

        @Override
        InputStream createStream() throws FileNotFoundException {
            return new FileInputStream(this.fileName);
        }
    }

    static abstract class AbstractLoadingKeyStoreFactory
    implements ExceptionSupplier<KeyStore, ConfigXMLParseException> {
        protected final ExceptionSupplier<KeyStore, ConfigXMLParseException> delegateFactory;
        protected final ExceptionSupplier<char[], ConfigXMLParseException> passwordFactory;
        protected final XMLLocation location;

        protected AbstractLoadingKeyStoreFactory(ExceptionSupplier<KeyStore, ConfigXMLParseException> delegateFactory, ExceptionSupplier<char[], ConfigXMLParseException> passwordFactory, XMLLocation location) {
            this.delegateFactory = delegateFactory;
            this.passwordFactory = passwordFactory;
            this.location = location;
        }

        public KeyStore get() throws ConfigXMLParseException {
            try {
                KeyStore keyStore = (KeyStore)this.delegateFactory.get();
                try (InputStream fis = this.createStream();){
                    keyStore.load(fis, this.passwordFactory == null ? null : (char[])this.passwordFactory.get());
                }
                return keyStore;
            }
            catch (IOException | GeneralSecurityException e) {
                throw ElytronMessages.xmlLog.xmlFailedToLoadKeyStoreData((Location)this.location, e);
            }
        }

        abstract InputStream createStream() throws IOException;
    }

    static final class PasswordKeyStoreFactory
    implements ExceptionSupplier<KeyStore, ConfigXMLParseException> {
        private final ExceptionSupplier<KeyStore, ConfigXMLParseException> delegateFactory;

        PasswordKeyStoreFactory(ExceptionSupplier<KeyStore, ConfigXMLParseException> delegateFactory) {
            this.delegateFactory = delegateFactory;
        }

        public KeyStore get() throws ConfigXMLParseException {
            return new WrappingPasswordKeyStore((KeyStore)this.delegateFactory.get());
        }
    }

    static final class KeyStoreCreateFactory
    implements ExceptionSupplier<KeyStore, ConfigXMLParseException> {
        private final String provider;
        private final String type;
        private final XMLLocation location;

        KeyStoreCreateFactory(String provider, String type, XMLLocation location) {
            this.provider = provider;
            this.type = type;
            this.location = location;
        }

        public KeyStore get() throws ConfigXMLParseException {
            try {
                return this.provider == null ? KeyStore.getInstance(this.type) : KeyStore.getInstance(this.type, this.provider);
            }
            catch (GeneralSecurityException e) {
                throw ElytronMessages.xmlLog.xmlFailedToCreateKeyStore((Location)this.location, e);
            }
        }
    }

    private static class TrustManagerBuilder {
        KeyStore trustStore;
        boolean crl = false;
        InputStream crlStream = null;
        int maxCertPath = 5;

        private TrustManagerBuilder() {
        }

        void setTrustStore(KeyStore trustStore) {
            Assert.checkNotNullParam((String)"trustStore", (Object)trustStore);
            this.trustStore = trustStore;
        }

        void setCrl() {
            this.crl = true;
        }

        void setCrlStream(InputStream crlStream) {
            this.crlStream = crlStream;
        }

        void setMaxCertPath(int maxCertPath) {
            Assert.checkMinimumParameter((String)"maxCertPath", (int)1, (int)maxCertPath);
            this.maxCertPath = maxCertPath;
        }

        X509TrustManager build() throws NoSuchAlgorithmException, KeyStoreException {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(this.trustStore);
            if (this.crl) {
                return new X509CRLExtendedTrustManager(this.trustStore, trustManagerFactory, this.crlStream, this.maxCertPath, null);
            }
            for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
                if (!(trustManager instanceof X509TrustManager)) continue;
                return (X509TrustManager)trustManager;
            }
            throw ElytronMessages.log.noDefaultTrustManager();
        }
    }

    private static enum Version {
        VERSION_1_0("urn:elytron:1.0", null),
        VERSION_1_0_1("urn:elytron:1.0.1", VERSION_1_0),
        VERSION_1_1("urn:elytron:client:1.1", VERSION_1_0_1);

        final String namespace;
        final Version parent;

        private Version(String namespace, Version parent) {
            this.namespace = namespace;
            this.parent = parent;
        }

        boolean isAtLeast(Version version) {
            return this.equals((Object)version) || this.parent != null && this.parent.isAtLeast(version);
        }
    }
}

