/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.digest;

import java.util.Map;

abstract class AbstractDigestFactory {
    private static final String[] MECHS = new String[]{"DIGEST-SHA-512", "DIGEST-SHA-256", "DIGEST-SHA-384", "DIGEST-SHA", "DIGEST-MD5"};
    private static final String[] NO_MECHS = new String[0];

    AbstractDigestFactory() {
    }

    boolean matches(Map<String, ?> props, boolean query) {
        if (props == null) {
            return true;
        }
        if ("true".equals(props.get("wildfly.sasl.mechanism-query-all")) && query) {
            return true;
        }
        return !"true".equals(props.get("javax.security.sasl.policy.forward")) && !"true".equals(props.get("javax.security.sasl.policy.credentials")) && !"true".equals(props.get("javax.security.sasl.policy.nodictionary")) && !"true".equals(props.get("javax.security.sasl.policy.noactive"));
    }

    boolean matchesMech(String mechanismName) {
        switch (mechanismName) {
            case "DIGEST-MD5": 
            case "DIGEST-SHA": 
            case "DIGEST-SHA-256": 
            case "DIGEST-SHA-384": 
            case "DIGEST-SHA-512": {
                return true;
            }
        }
        return false;
    }

    String select(String[] mechanismNames) {
        for (String mechanismName : mechanismNames) {
            if (!this.matchesMech(mechanismName)) continue;
            return mechanismName;
        }
        return null;
    }

    public String[] getMechanismNames(Map<String, ?> props) {
        return this.matches(props, true) ? (String[])MECHS.clone() : NO_MECHS;
    }
}

