/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.wildfly.security.http.oidc.AccessAndIDTokenResponse;
import org.wildfly.security.http.oidc.ClientCredentialsProviderUtils;
import org.wildfly.security.http.oidc.ElytronMessages;
import org.wildfly.security.http.oidc.OidcClientConfiguration;
import org.wildfly.security.jose.util.JsonSerialization;

public class ServerRequest {
    private static final int BUFFER_LENGTH = 4096;

    public static AccessAndIDTokenResponse invokeRefresh(OidcClientConfiguration deployment, String refreshToken) throws IOException, HttpFailure {
        ArrayList<NameValuePair> formparams = new ArrayList<NameValuePair>();
        formparams.add(new BasicNameValuePair("grant_type", "refresh_token"));
        formparams.add(new BasicNameValuePair("refresh_token", refreshToken));
        HttpPost post = new HttpPost(deployment.getTokenUrl());
        ClientCredentialsProviderUtils.setClientCredentials(deployment, post, formparams);
        UrlEncodedFormEntity form = new UrlEncodedFormEntity(formparams, StandardCharsets.UTF_8);
        post.setEntity(form);
        HttpResponse response = deployment.getClient().execute(post);
        int status = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        if (status != 200) {
            ServerRequest.error(status, entity);
        }
        if (entity == null) {
            throw new HttpFailure(status, null);
        }
        InputStream is = entity.getContent();
        try {
            int c;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while ((c = is.read()) != -1) {
                os.write(c);
            }
            byte[] bytes = os.toByteArray();
            String json = new String(bytes);
            try {
                AccessAndIDTokenResponse accessAndIDTokenResponse = JsonSerialization.readValue(json, AccessAndIDTokenResponse.class);
                return accessAndIDTokenResponse;
            }
            catch (IOException e) {
                throw new IOException(json, e);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void invokeLogout(OidcClientConfiguration deployment, String refreshToken) throws IOException, HttpFailure {
        HttpClient client = deployment.getClient();
        String uri = deployment.getLogoutUrl();
        ArrayList<NameValuePair> formparams = new ArrayList<NameValuePair>();
        formparams.add(new BasicNameValuePair("refresh_token", refreshToken));
        HttpPost post = new HttpPost(uri);
        ClientCredentialsProviderUtils.setClientCredentials(deployment, post, formparams);
        UrlEncodedFormEntity form = new UrlEncodedFormEntity(formparams, StandardCharsets.UTF_8);
        post.setEntity(form);
        HttpResponse response = client.execute(post);
        int status = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        if (status != 204) {
            ServerRequest.error(status, entity);
        }
        if (entity == null) {
            return;
        }
        InputStream is = entity.getContent();
        if (is != null) {
            is.close();
        }
    }

    public static AccessAndIDTokenResponse invokeAccessCodeToToken(OidcClientConfiguration deployment, String code, String redirectUri) throws IOException, HttpFailure {
        ArrayList<NameValuePair> formparams = new ArrayList<NameValuePair>();
        formparams.add(new BasicNameValuePair("grant_type", "authorization_code"));
        formparams.add(new BasicNameValuePair("code", code));
        formparams.add(new BasicNameValuePair("redirect_uri", redirectUri));
        HttpPost post = new HttpPost(deployment.getTokenUrl());
        ClientCredentialsProviderUtils.setClientCredentials(deployment, post, formparams);
        UrlEncodedFormEntity form = new UrlEncodedFormEntity(formparams, StandardCharsets.UTF_8);
        post.setEntity(form);
        HttpResponse response = deployment.getClient().execute(post);
        int status = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        if (status != 200) {
            ServerRequest.error(status, entity);
        }
        if (entity == null) {
            throw new HttpFailure(status, null);
        }
        InputStream is = entity.getContent();
        try {
            int c;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while ((c = is.read()) != -1) {
                os.write(c);
            }
            byte[] bytes = os.toByteArray();
            String json = new String(bytes);
            try {
                AccessAndIDTokenResponse accessAndIDTokenResponse = JsonSerialization.readValue(json, AccessAndIDTokenResponse.class);
                return accessAndIDTokenResponse;
            }
            catch (IOException e) {
                throw new IOException(json, e);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void invokeRegisterNodeForKeycloak(OidcClientConfiguration deployment, String host) throws HttpFailure, IOException {
        String registerNodeUrl = deployment.getRegisterNodeUrl();
        ServerRequest.invokeClientManagementRequestForKeycloak(deployment, host, registerNodeUrl);
    }

    public static void invokeUnregisterNodeForKeycloak(OidcClientConfiguration deployment, String host) throws HttpFailure, IOException {
        String unregisterNodeUrl = deployment.getUnregisterNodeUrl();
        ServerRequest.invokeClientManagementRequestForKeycloak(deployment, host, unregisterNodeUrl);
    }

    public static void invokeClientManagementRequestForKeycloak(OidcClientConfiguration deployment, String host, String endpointUrl) throws HttpFailure, IOException {
        if (endpointUrl == null) {
            throw new IOException("You need to configure URI for register/unregister node for application " + deployment.getResourceName());
        }
        ArrayList<NameValuePair> formparams = new ArrayList<NameValuePair>();
        formparams.add(new BasicNameValuePair("client_cluster_host", host));
        HttpPost post = new HttpPost(endpointUrl);
        ClientCredentialsProviderUtils.setClientCredentials(deployment, post, formparams);
        UrlEncodedFormEntity form = new UrlEncodedFormEntity(formparams, "UTF-8");
        post.setEntity(form);
        HttpResponse response = deployment.getClient().execute(post);
        int status = response.getStatusLine().getStatusCode();
        if (status != 204) {
            HttpEntity entity = response.getEntity();
            ServerRequest.error(status, entity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void error(int status, HttpEntity entity) throws HttpFailure, IOException {
        String body = null;
        if (entity != null) {
            InputStream is = entity.getContent();
            try {
                body = ServerRequest.readString(is, Charset.defaultCharset());
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        throw new HttpFailure(status, body);
    }

    private static String readString(InputStream in, Charset charset) throws IOException {
        int wasRead;
        char[] buffer = new char[4096];
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, charset));
        do {
            if ((wasRead = reader.read(buffer, 0, 4096)) <= 0) continue;
            builder.append(buffer, 0, wasRead);
        } while (wasRead > -1);
        return builder.toString();
    }

    public static AccessAndIDTokenResponse getBearerToken(OidcClientConfiguration oidcClientConfiguration, String username, String password) throws Exception {
        AccessAndIDTokenResponse tokenResponse;
        HttpClient client = oidcClientConfiguration.getClient();
        HttpPost post = new HttpPost(oidcClientConfiguration.getTokenUrl());
        ArrayList<NameValuePair> formparams = new ArrayList<NameValuePair>();
        formparams.add(new BasicNameValuePair("grant_type", "password"));
        formparams.add(new BasicNameValuePair("username", username));
        formparams.add(new BasicNameValuePair("password", password));
        ClientCredentialsProviderUtils.setClientCredentials(oidcClientConfiguration, post, formparams);
        UrlEncodedFormEntity form = new UrlEncodedFormEntity(formparams, "UTF-8");
        post.setEntity(form);
        HttpResponse response = client.execute(post);
        int status = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        if (status != 200) {
            EntityUtils.consumeQuietly(entity);
            throw ElytronMessages.log.unableToObtainToken(status);
        }
        if (entity == null) {
            throw ElytronMessages.log.noMessageEntity();
        }
        try (InputStream is = entity.getContent();){
            tokenResponse = JsonSerialization.readValue(is, AccessAndIDTokenResponse.class);
        }
        return tokenResponse;
    }

    public static class HttpFailure
    extends Exception {
        private int status;
        private String error;

        public HttpFailure(int status, String error) {
            this.status = status;
            this.error = error;
        }

        public int getStatus() {
            return this.status;
        }

        public String getError() {
            return this.error;
        }
    }
}

