/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.anonymous;

import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.sasl.SaslException;
import org.wildfly.common.Assert;
import org.wildfly.common.bytes.ByteStringBuilder;
import org.wildfly.security.auth.principal.AnonymousPrincipal;
import org.wildfly.security.mechanism._private.ElytronMessages;
import org.wildfly.security.sasl.util.AbstractSaslClient;
import org.wildfly.security.sasl.util.StringPrep;

public final class AnonymousSaslClient
extends AbstractSaslClient {
    private static final int INITIAL_STATE = 1;

    AnonymousSaslClient(String protocol, String serverName, CallbackHandler callbackHandler, String authorizationId) {
        super("ANONYMOUS", protocol, serverName, callbackHandler, authorizationId, true, ElytronMessages.saslAnonymous);
        this.setNegotiationState(1);
    }

    @Override
    protected byte[] evaluateMessage(int state, byte[] message) throws SaslException {
        switch (state) {
            case 1: {
                if (message != null && message.length > 0) {
                    throw ElytronMessages.saslAnonymous.mechInvalidServerMessage().toSaslException();
                }
                NameCallback nameCallback = new NameCallback("Authentication name", "anonymous");
                this.handleCallbacks(nameCallback);
                String name = nameCallback.getName();
                if (name == null) {
                    throw ElytronMessages.saslAnonymous.mechNotProvidedUserName().toSaslException();
                }
                if (name.length() > 255) {
                    throw ElytronMessages.saslAnonymous.mechAuthenticationNameTooLong().toSaslException();
                }
                if (name.isEmpty()) {
                    throw ElytronMessages.saslAnonymous.mechAuthenticationNameIsEmpty().toSaslException();
                }
                ByteStringBuilder b = new ByteStringBuilder();
                StringPrep.encode(name, b, 7159L);
                this.negotiationComplete();
                return b.toArray();
            }
        }
        throw Assert.impossibleSwitchCase((int)state);
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        this.assertComplete();
        return "wildfly.sasl.principal".equals(propName) ? AnonymousPrincipal.getInstance() : super.getNegotiatedProperty(propName);
    }
}

