/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.keystore;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.wildfly.security.keystore.ElytronMessages;
import org.wildfly.security.keystore.PasswordEntry;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.util.ModularCrypt;

public final class PasswordKeyStoreSpi
extends KeyStoreSpi {
    private final AtomicReference<HashMap<String, PasswordEntry>> pwRef = new AtomicReference();

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        HashMap<String, PasswordEntry> map = this.pwRef.get();
        if (map == null) {
            return null;
        }
        PasswordEntry key = map.get(alias);
        if (key == null) {
            return null;
        }
        if (password != null) {
            throw ElytronMessages.log.invalidKeyStoreEntryPassword(alias);
        }
        return key.getPassword();
    }

    @Override
    public KeyStore.Entry engineGetEntry(String alias, KeyStore.ProtectionParameter protParam) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        HashMap<String, PasswordEntry> map = this.pwRef.get();
        if (map == null) {
            return null;
        }
        PasswordEntry key = map.get(alias);
        if (key == null) {
            return null;
        }
        if (protParam != null) {
            throw ElytronMessages.log.invalidKeyStoreEntryPassword(alias);
        }
        return key;
    }

    @Override
    public void engineSetEntry(String alias, KeyStore.Entry entry, KeyStore.ProtectionParameter protParam) throws KeyStoreException {
        LinkedHashMap<Object, Object> newMap;
        HashMap<String, PasswordEntry> map;
        if (!(entry instanceof PasswordEntry)) {
            throw ElytronMessages.log.invalidKeyStoreEntryType(alias, PasswordEntry.class, entry.getClass());
        }
        if (protParam != null) {
            throw ElytronMessages.log.keyCannotBeProtected(alias);
        }
        do {
            newMap = (map = this.pwRef.get()) == null ? new LinkedHashMap(1) : new LinkedHashMap<String, PasswordEntry>(map);
            newMap.put(alias, (PasswordEntry)entry);
        } while (!this.pwRef.compareAndSet(map, newMap));
    }

    @Override
    public boolean engineEntryInstanceOf(String alias, Class<? extends KeyStore.Entry> entryClass) {
        HashMap<String, PasswordEntry> map = this.pwRef.get();
        return map != null && entryClass.isInstance(map.get(alias));
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        return null;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        return null;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        return null;
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        if (password != null) {
            throw new KeyStoreException(ElytronMessages.log.invalidKeyStoreEntryPassword(alias));
        }
        if (key instanceof Password) {
            this.engineSetEntry(alias, new PasswordEntry((Password)key), null);
        }
        throw ElytronMessages.log.invalidKeyStoreEntryType(alias, PasswordEntry.class, Key.class);
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw ElytronMessages.log.invalidKeyStoreEntryType(alias, PasswordEntry.class, Key.class);
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        throw ElytronMessages.log.invalidKeyStoreEntryType(alias, PasswordEntry.class, Certificate.class);
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        LinkedHashMap<String, PasswordEntry> newMap;
        HashMap<String, PasswordEntry> map;
        do {
            if ((map = this.pwRef.get()) == null || !map.containsKey(alias)) {
                return;
            }
            if (map.size() == 1) {
                newMap = null;
                continue;
            }
            newMap = new LinkedHashMap<String, PasswordEntry>(map);
            newMap.remove(alias);
        } while (!this.pwRef.compareAndSet(map, newMap));
    }

    @Override
    public Enumeration<String> engineAliases() {
        HashMap<String, PasswordEntry> map = this.pwRef.get();
        return Collections.enumeration(map == null ? Collections.emptySet() : map.keySet());
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        HashMap<String, PasswordEntry> map = this.pwRef.get();
        return map != null && map.containsKey(alias);
    }

    @Override
    public int engineSize() {
        HashMap<String, PasswordEntry> map = this.pwRef.get();
        return map == null ? 0 : map.size();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        return false;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        return false;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        return null;
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        HashMap<String, PasswordEntry> map = this.pwRef.get();
        if (map != null) {
            OutputStreamWriter osw = new OutputStreamWriter(stream, StandardCharsets.UTF_8);
            BufferedWriter bw = new BufferedWriter(osw);
            for (Map.Entry<String, PasswordEntry> entry : map.entrySet()) {
                char[] chars;
                PasswordEntry passwordEntry = entry.getValue();
                Password pw = passwordEntry.getPassword();
                String alias = entry.getKey();
                try {
                    chars = ModularCrypt.encode(pw);
                }
                catch (InvalidKeySpecException e) {
                    throw ElytronMessages.log.keyStoreFailedToTranslate(alias, e);
                }
                bw.write(alias.replaceAll("([\\\\:])", "\\$1"));
                bw.write(58);
                bw.write(chars);
                bw.write(10);
                bw.flush();
            }
        }
    }

    private static int forceReadCP(Reader r) throws IOException {
        int i = PasswordKeyStoreSpi.readCP(r);
        if (i == -1) {
            throw ElytronMessages.log.unexpectedEof();
        }
        return i;
    }

    private static int readCP(Reader r) throws IOException {
        int hi = r.read();
        if (hi == -1) {
            return -1;
        }
        if (Character.isHighSurrogate((char)hi)) {
            int lo = r.read();
            if (lo == -1) {
                throw ElytronMessages.log.unexpectedEof();
            }
            if (Character.isLowSurrogate((char)lo)) {
                return Character.toCodePoint((char)hi, (char)lo);
            }
            throw new CharacterCodingException();
        }
        return hi;
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        LinkedHashMap<String, PasswordEntry> map = new LinkedHashMap<String, PasswordEntry>();
        InputStreamReader isr = new InputStreamReader(stream, StandardCharsets.UTF_8);
        BufferedReader br = new BufferedReader(isr);
        StringBuilder b = new StringBuilder();
        block2: while (true) {
            int ch;
            if ((ch = PasswordKeyStoreSpi.readCP(br)) == -1) {
                this.pwRef.set(map);
                return;
            }
            while (ch == 92) {
                ch = PasswordKeyStoreSpi.forceReadCP(br);
                b.appendCodePoint(ch);
            }
            if (ch == 58) {
                String alias = b.toString();
                b.setLength(0);
                while (true) {
                    if ((ch = PasswordKeyStoreSpi.forceReadCP(br)) == 10 || ch == 13 || ch == 58) {
                        Password pw;
                        char[] c = new char[b.length()];
                        b.getChars(0, b.length(), c, 0);
                        String algorithm = ModularCrypt.identifyAlgorithm(c);
                        if (algorithm == null) {
                            throw ElytronMessages.log.noAlgorithmForPassword(alias);
                        }
                        try {
                            pw = ModularCrypt.decode(c);
                        }
                        catch (InvalidKeySpecException e) {
                            throw ElytronMessages.log.noAlgorithmForPassword(alias);
                        }
                        map.put(alias, new PasswordEntry(pw));
                        while (ch != 10) {
                            ch = PasswordKeyStoreSpi.forceReadCP(br);
                        }
                        b.setLength(0);
                        continue block2;
                    }
                    b.appendCodePoint(ch);
                }
            }
            if (Character.isWhitespace(ch)) {
                throw ElytronMessages.log.unexpectedWhitespaceInPasswordFile();
            }
            b.appendCodePoint(ch);
        }
    }
}

