/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500.cert._private;

import java.security.cert.CertificateException;
import java.time.ZonedDateTime;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.annotations.ValidIdRanges;
import org.wildfly.security.asn1.ASN1Exception;

@MessageLogger(projectCode="ELY", length=5)
@ValidIdRanges(value={@ValidIdRange(min=3010, max=3033), @ValidIdRange(min=7001, max=7004), @ValidIdRange(min=10000, max=10024)})
public interface ElytronMessages
extends BasicLogger {
    public static final ElytronMessages log = Logger.getMessageLogger(ElytronMessages.class, "org.wildfly.security");

    @Message(id=3010, value="Malformed PEM content at offset %d")
    public IllegalArgumentException malformedPemContent(long var1);

    @Message(id=3011, value="Invalid PEM type (expected \"%s\", got \"%s\"")
    public IllegalArgumentException invalidPemType(String var1, String var2);

    @Message(id=3012, value="Certificate parse error")
    public IllegalArgumentException certificateParseError(@Cause CertificateException var1);

    @Message(id=3023, value="PublicKey parse error")
    public IllegalArgumentException publicKeyParseError(@Cause Throwable var1);

    @Message(id=3033, value="PrivateKey parse error")
    public IllegalArgumentException privateKeyParseError(@Cause Throwable var1);

    @Message(id=7001, value="Unrecognized encoding algorithm [%s]")
    public ASN1Exception asnUnrecognisedAlgorithm(String var1);

    @Message(id=7004, value="Unexpected ASN.1 tag encountered")
    public ASN1Exception asnUnexpectedTag();

    @Message(id=10000, value="X.509 certificate extension with OID %s already exists")
    public IllegalArgumentException extensionAlreadyExists(String var1);

    @Message(id=10001, value="No signature algorithm name given")
    public IllegalArgumentException noSignatureAlgorithmNameGiven();

    @Message(id=10002, value="Signature algorithm name \"%s\" is not recognized")
    public IllegalArgumentException unknownSignatureAlgorithmName(String var1);

    @Message(id=10003, value="No signing key given")
    public IllegalArgumentException noSigningKeyGiven();

    @Message(id=10004, value="Signing key algorithm name \"%s\" is not compatible with signature algorithm name \"%s\"")
    public IllegalArgumentException signingKeyNotCompatWithSig(String var1, String var2);

    @Message(id=10005, value="Not-valid-before date of %s is after not-valid-after date of %s")
    public IllegalArgumentException validAfterBeforeValidBefore(ZonedDateTime var1, ZonedDateTime var2);

    @Message(id=10006, value="No issuer DN given")
    public IllegalArgumentException noIssuerDnGiven();

    @Message(id=10007, value="No public key given")
    public IllegalArgumentException noPublicKeyGiven();

    @Message(id=10008, value="Issuer and subject unique ID are only allowed in certificates with version 2 or higher")
    public IllegalArgumentException uniqueIdNotAllowed();

    @Message(id=10009, value="Extensions are only allowed in certificates with version 3 or higher")
    public IllegalArgumentException extensionsNotAllowed();

    @Message(id=10010, value="X.509 encoding of public key with algorithm \"%s\" failed")
    public IllegalArgumentException invalidKeyForCert(String var1, @Cause Exception var2);

    @Message(id=10011, value="Failed to sign certificate")
    public IllegalArgumentException certSigningFailed(@Cause Exception var1);

    @Message(id=10012, value="Certificate serial number must be positive")
    public IllegalArgumentException serialNumberTooSmall();

    @Message(id=10013, value="Certificate serial number too large (cannot exceed 20 octets)")
    public IllegalArgumentException serialNumberTooLarge();

    @Message(id=10014, value="Failed to sign certification request info")
    public IllegalArgumentException certRequestInfoSigningFailed(@Cause Exception var1);

    @Message(id=10015, value="No certificate given")
    public IllegalArgumentException noCertificateGiven();

    @Message(id=10017, value="No DN given")
    public IllegalArgumentException noDnGiven();

    @Message(id=10018, value="Failed to generate self-signed X.509 certificate")
    public IllegalArgumentException selfSignedCertificateGenerationFailed(@Cause Exception var1);

    @Message(id=10019, value="Unable to determine default compatible signature algorithm name for key algorithm name \"%s\"")
    public IllegalArgumentException unableToDetermineDefaultCompatibleSignatureAlgorithmName(String var1);

    @Message(id=10020, value="Creating an X.509 certificate extension from a string value is not supported for extension name \"%s\"")
    public IllegalArgumentException certificateExtensionCreationFromStringNotSupported(String var1);

    @Message(id=10021, value="Invalid X.509 certificate extension string value \"%s\"")
    public IllegalArgumentException invalidCertificateExtensionStringValue(String var1);

    @Message(id=10022, value="Failed to create X.509 certificate extension from string value")
    public IllegalArgumentException certificateExtensionCreationFromStringFailed(@Cause Exception var1);

    @Message(id=10023, value="X.509 certificate extension \"%s\" must be non-critical")
    public IllegalArgumentException certificateExtensionMustBeNonCritical(String var1);

    @Message(id=10024, value="Invalid X.509 certificate extension string value")
    public IllegalArgumentException invalidCertificateExtensionStringValue();
}

