/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.auth.util;

import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.sasl.auth.util.AuthenticationContextSaslClient;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslClientFactory;

public final class AuthenticationContextSaslClientFactory
extends AbstractDelegatingSaslClientFactory {
    private final AuthenticationContext context;

    public AuthenticationContextSaslClientFactory(SaslClientFactory delegate) {
        super(delegate);
        this.context = AuthenticationContext.captureCurrent();
    }

    public AuthenticationContextSaslClientFactory(SaslClientFactory delegate, AuthenticationContext context) {
        super(delegate);
        this.context = context;
    }

    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        SaslClient delegate = super.createSaslClient(mechanisms, authorizationId, protocol, serverName, props, cbh);
        if (delegate == null) {
            return null;
        }
        return new AuthenticationContextSaslClient(delegate, this.context);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof AuthenticationContextSaslClientFactory && this.equals((AuthenticationContextSaslClientFactory)other);
    }

    @Override
    public boolean equals(AbstractDelegatingSaslClientFactory other) {
        return other instanceof AuthenticationContextSaslClientFactory && this.equals((AuthenticationContextSaslClientFactory)other);
    }

    public boolean equals(AuthenticationContextSaslClientFactory other) {
        return super.equals(other) && this.context.equals(other.context);
    }

    @Override
    protected int calculateHashCode() {
        return HashMath.multiHashOrdered((int)HashMath.multiHashOrdered((int)super.calculateHashCode(), (int)this.getClass().hashCode()), (int)this.context.hashCode());
    }
}

