/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.audit;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.audit.AuditEndpoint;
import org.wildfly.security.audit.EventPriority;

public class FileAuditEndpoint
implements AuditEndpoint {
    private static final byte[] LINE_TERMINATOR = System.lineSeparator().getBytes(StandardCharsets.UTF_8);
    private volatile boolean accepting = true;
    private final Supplier<DateTimeFormatter> dateTimeFormatterSupplier;
    private final boolean syncOnAccept;
    private File file;
    private FileDescriptor fileDescriptor;
    private OutputStream outputStream;
    protected final Clock clock;

    FileAuditEndpoint(Builder builder) throws IOException {
        this.dateTimeFormatterSupplier = builder.dateTimeFormatterSupplier;
        this.syncOnAccept = builder.syncOnAccept;
        this.clock = builder.clock;
        this.setFile(builder.location.toFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFile(File file) throws IOException {
        boolean ok = false;
        FileOutputStream fos = new FileOutputStream(file, true);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            try {
                this.fileDescriptor = fos.getFD();
                this.outputStream = bos;
                this.file = file;
                ok = true;
            }
            finally {
                if (!ok) {
                    this.safeClose(bos);
                }
            }
        }
        finally {
            if (!ok) {
                this.safeClose(fos);
            }
        }
    }

    File getFile() {
        return this.file;
    }

    private void safeClose(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (Exception e) {
            ElytronMessages.audit.trace("Unable to close", e);
        }
    }

    void write(byte[] bytes) throws IOException {
        this.outputStream.write(bytes);
    }

    void preWrite(Instant instant) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(EventPriority t, String u) throws IOException {
        if (!this.accepting) {
            return;
        }
        Instant instant = this.clock.instant();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.dateTimeFormatterSupplier.get().format(instant).getBytes(StandardCharsets.UTF_8));
        baos.write(44);
        baos.write(t.toString().getBytes(StandardCharsets.UTF_8));
        baos.write(44);
        baos.write(u.getBytes(StandardCharsets.UTF_8));
        baos.write(LINE_TERMINATOR);
        byte[] toWrite = baos.toByteArray();
        FileAuditEndpoint fileAuditEndpoint = this;
        synchronized (fileAuditEndpoint) {
            if (!this.accepting) {
                return;
            }
            this.preWrite(instant);
            this.write(toWrite);
            if (this.syncOnAccept) {
                this.outputStream.flush();
                this.fileDescriptor.sync();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.accepting = false;
        FileAuditEndpoint fileAuditEndpoint = this;
        synchronized (fileAuditEndpoint) {
            this.closeStreams();
        }
    }

    void closeStreams() throws IOException {
        this.outputStream.flush();
        this.fileDescriptor.sync();
        this.outputStream.close();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Clock clock = Clock.systemUTC();
        private Supplier<DateTimeFormatter> dateTimeFormatterSupplier = () -> DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).withZone(ZoneId.systemDefault());
        private Path location = new File("audit.log").toPath();
        private boolean syncOnAccept = true;

        Builder() {
        }

        public Builder setDateTimeFormatterSupplier(Supplier<DateTimeFormatter> dateTimeFormatterSupplier) {
            this.dateTimeFormatterSupplier = (Supplier)Assert.checkNotNullParam((String)"dateTimeFormatterSupplier", dateTimeFormatterSupplier);
            return this;
        }

        public Builder setLocation(Path location) {
            this.location = (Path)Assert.checkNotNullParam((String)"location", (Object)location);
            return this;
        }

        public Builder setSyncOnAccept(boolean syncOnAccept) {
            this.syncOnAccept = syncOnAccept;
            return this;
        }

        Builder setClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public AuditEndpoint build() throws IOException {
            return new FileAuditEndpoint(this);
        }
    }
}

