/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential;

import java.security.MessageDigest;
import java.security.Provider;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.credential.AlgorithmCredential;
import org.wildfly.security.credential.X509CertificateChainCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.X509PeerCertificateChainEvidence;
import org.wildfly.security.key.KeyUtil;

abstract class AbstractX509CertificateChainCredential
implements X509CertificateChainCredential {
    final X509Certificate[] certificateChain;

    AbstractX509CertificateChainCredential(X509Certificate ... certificateChain) {
        Assert.checkNotNullParam((String)"certificateChain", (Object)certificateChain);
        if (certificateChain.length > 0) {
            this.certificateChain = (X509Certificate[])certificateChain.clone();
            int length = this.certificateChain.length;
            for (int i = 0; i < length; ++i) {
                Assert.checkNotNullArrayParam((String)"certificateChain", (int)i, (Object)this.certificateChain[i]);
            }
        } else {
            throw ElytronMessages.log.certificateChainIsEmpty();
        }
    }

    @Override
    public boolean canVerify(Class<? extends Evidence> evidenceClass, String algorithmName) {
        return evidenceClass == X509PeerCertificateChainEvidence.class && this.getAlgorithm().equals(algorithmName);
    }

    @Override
    public boolean verify(Evidence evidence) {
        if (evidence instanceof X509PeerCertificateChainEvidence) {
            X509PeerCertificateChainEvidence peerCertificateChainEvidence = (X509PeerCertificateChainEvidence)evidence;
            try {
                return this.getAlgorithm().equals(peerCertificateChainEvidence.getAlgorithm()) && MessageDigest.isEqual(this.getFirstCertificate().getEncoded(), peerCertificateChainEvidence.getFirstCertificate().getEncoded());
            }
            catch (CertificateEncodingException certificateEncodingException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean verify(Supplier<Provider[]> providerSupplier, Evidence evidence) {
        return this.verify(evidence);
    }

    @Override
    public String getAlgorithm() {
        return this.getFirstCertificate().getPublicKey().getAlgorithm();
    }

    @Override
    public boolean supportsParameters(Class<? extends AlgorithmParameterSpec> paramSpecClass) {
        return KeyUtil.getParameters(this.getFirstCertificate().getPublicKey(), paramSpecClass) != null;
    }

    @Override
    public <P extends AlgorithmParameterSpec> P getParameters(Class<P> paramSpecClass) {
        return KeyUtil.getParameters(this.getFirstCertificate().getPublicKey(), paramSpecClass);
    }

    @Override
    public boolean impliesSameParameters(AlgorithmCredential other) {
        return KeyUtil.hasParameters(this.getFirstCertificate().getPublicKey(), other.getParameters());
    }

    @Override
    public X509Certificate[] getCertificateChain() {
        return (X509Certificate[])this.certificateChain.clone();
    }

    @Override
    public X509Certificate getFirstCertificate() {
        return this.certificateChain[0];
    }

    @Override
    public X509Certificate getLastCertificate() {
        return this.certificateChain[this.certificateChain.length - 1];
    }

    @Override
    public abstract AbstractX509CertificateChainCredential clone();
}

