/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Predicate;
import javax.security.auth.callback.CallbackHandler;
import org.wildfly.common.Assert;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;

public final class FilterServerMechanismFactory
implements HttpServerAuthenticationMechanismFactory {
    private final HttpServerAuthenticationMechanismFactory delegate;
    private final Predicate<String> predicate;

    public FilterServerMechanismFactory(HttpServerAuthenticationMechanismFactory delegate, Predicate<String> predicate) {
        this.delegate = (HttpServerAuthenticationMechanismFactory)Assert.checkNotNullParam((String)"delegate", (Object)delegate);
        this.predicate = (Predicate)Assert.checkNotNullParam((String)"predicate", predicate);
    }

    public FilterServerMechanismFactory(HttpServerAuthenticationMechanismFactory delegate, boolean include, String ... mechanismNames) {
        this.delegate = (HttpServerAuthenticationMechanismFactory)Assert.checkNotNullParam((String)"delegate", (Object)delegate);
        HashSet nameSet = new HashSet(mechanismNames.length);
        Collections.addAll(nameSet, mechanismNames);
        Predicate<String> predicate = nameSet::contains;
        this.predicate = include ? predicate : predicate.negate();
    }

    public FilterServerMechanismFactory(HttpServerAuthenticationMechanismFactory delegate, boolean include, Collection<String> mechanismNames) {
        this.delegate = (HttpServerAuthenticationMechanismFactory)Assert.checkNotNullParam((String)"delegate", (Object)delegate);
        HashSet nameSet = new HashSet((Collection)Assert.checkNotNullParam((String)"mechanismNames", mechanismNames));
        Predicate<String> predicate = nameSet::contains;
        this.predicate = include ? predicate : predicate.negate();
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> properties) {
        String[] allMechanisms = this.delegate.getMechanismNames(properties);
        ArrayList<String> filtered = new ArrayList<String>(allMechanisms.length);
        for (String current : allMechanisms) {
            if (!this.predicate.test(current)) continue;
            filtered.add(current);
        }
        return filtered.toArray(new String[filtered.size()]);
    }

    @Override
    public HttpServerAuthenticationMechanism createAuthenticationMechanism(String mechanismName, Map<String, ?> properties, CallbackHandler callbackHandler) throws HttpAuthenticationException {
        return this.predicate.test(mechanismName) ? this.delegate.createAuthenticationMechanism(mechanismName, properties, callbackHandler) : null;
    }
}

