/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpConstants;
import org.wildfly.security.http.HttpScope;
import org.wildfly.security.http.HttpServerMechanismsResponder;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.HttpServerResponse;
import org.wildfly.security.http.Scope;
import org.wildfly.security.http.impl.UsernamePasswordAuthenticationMechanism;

class FormAuthenticationMechanism
extends UsernamePasswordAuthenticationMechanism {
    private static final String USERNAME = "j_username";
    private static final String PASSWORD = "j_password";
    private static final String LOCATION_KEY = FormAuthenticationMechanism.class.getName() + ".Location";
    private static final String AUTHENTICATED_PRINCIPAL_KEY = FormAuthenticationMechanism.class.getName() + ".authenticated-principal";
    private static final String DEFAULT_POST_LOCATION = "j_security_check";
    private final String contextPath;
    private final String loginPage;
    private final String errorPage;
    private final String postLocation;

    FormAuthenticationMechanism(CallbackHandler callbackHandler, Map<String, ?> properties) {
        super((CallbackHandler)Assert.checkNotNullParam((String)"callbackHandler", (Object)callbackHandler));
        Assert.checkNotNullParam((String)"properties", properties);
        String postLocation = (String)properties.get(HttpConstants.CONFIG_POST_LOCATION);
        this.postLocation = postLocation != null ? postLocation : DEFAULT_POST_LOCATION;
        this.contextPath = properties.containsKey(HttpConstants.CONFIG_CONTEXT_PATH) ? (String)properties.get(HttpConstants.CONFIG_CONTEXT_PATH) : "";
        this.loginPage = (String)properties.get(HttpConstants.CONFIG_LOGIN_PAGE);
        this.errorPage = (String)properties.get(HttpConstants.CONFIG_ERROR_PAGE);
    }

    @Override
    public String getMechanismName() {
        return "FORM";
    }

    @Override
    public void evaluateRequest(HttpServerRequest request) throws HttpAuthenticationException {
        if (this.attemptReAuthentication(request)) {
            return;
        }
        if ("POST".equals(request.getRequestMethod()) && request.getRequestURI().getPath().endsWith(this.postLocation)) {
            this.attemptAuthentication(request);
            return;
        }
        if (this.loginPage != null) {
            request.noAuthenticationInProgress(response -> this.sendLogin(request, response));
        }
    }

    private void error(String message, HttpServerRequest request) {
        request.authenticationFailed(message, response -> this.sendPage(this.errorPage, request, response));
    }

    private void attemptAuthentication(HttpServerRequest request) throws HttpAuthenticationException {
        String username = request.getFirstParameterValue(USERNAME);
        String password = request.getFirstParameterValue(PASSWORD);
        if (username == null || password == null) {
            this.error(ElytronMessages.log.usernameOrPasswordMissing(), request);
            return;
        }
        char[] passwordChars = password.toCharArray();
        try {
            if (this.authenticate(null, username, passwordChars)) {
                if (this.authorize(username)) {
                    this.succeed();
                    HttpScope session = request.getScope(Scope.SESSION);
                    HttpServerMechanismsResponder responder = null;
                    if (session != null) {
                        session.setAttachment(AUTHENTICATED_PRINCIPAL_KEY, username);
                        String originalPath = session.getAttachment(LOCATION_KEY, String.class);
                        if (originalPath != null) {
                            session.setAttachment(LOCATION_KEY, null);
                            responder = response -> this.sendRedirect(response, originalPath);
                        }
                    }
                    request.authenticationComplete(responder);
                    return;
                }
                this.failAndRedirectToErrorPage(request, username);
                return;
            }
            this.failAndRedirectToErrorPage(request, username);
            return;
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw new HttpAuthenticationException(e);
        }
        finally {
            Arrays.fill(passwordChars, '\u0000');
        }
    }

    private boolean attemptReAuthentication(HttpServerRequest request) throws HttpAuthenticationException {
        String principalName;
        HttpScope session = request.getScope(Scope.SESSION);
        if (session != null && (principalName = session.getAttachment(AUTHENTICATED_PRINCIPAL_KEY, String.class)) != null) {
            try {
                AuthorizeCallback authorizeCallback = new AuthorizeCallback(principalName, null);
                this.callbackHandler.handle(new Callback[]{authorizeCallback});
                if (authorizeCallback.isAuthorized()) {
                    this.succeed();
                    request.authenticationComplete();
                    request.resumeRequest();
                    return true;
                }
                session.setAttachment(AUTHENTICATED_PRINCIPAL_KEY, null);
            }
            catch (IOException | UnsupportedCallbackException e) {
                throw new HttpAuthenticationException(e);
            }
        }
        return false;
    }

    private void failAndRedirectToErrorPage(HttpServerRequest request, String username) throws IOException, UnsupportedCallbackException {
        HttpScope session = request.getScope(Scope.SESSION);
        if (session != null) {
            session.setAttachment(AUTHENTICATED_PRINCIPAL_KEY, null);
        }
        this.fail();
        this.error(ElytronMessages.log.authorizationFailed(username, "FORM"), request);
    }

    void sendLogin(HttpServerRequest request, HttpServerResponse response) throws HttpAuthenticationException {
        HttpScope session = request.getScope(Scope.SESSION);
        if (session != null && session.supportsAttachments()) {
            session.setAttachment(LOCATION_KEY, request.getRequestURI().getPath());
            request.suspendRequest();
        }
        this.sendPage(this.loginPage, request, response);
    }

    void sendPage(String page, HttpServerRequest request, HttpServerResponse response) throws HttpAuthenticationException {
        if (response.forward(page)) {
            return;
        }
        HttpScope application = request.getScope(Scope.APPLICATION);
        if (application != null && application.supportsResources()) {
            try (InputStream pageStream = application.getResource(page);){
                OutputStream responseStream;
                if (pageStream != null && (responseStream = response.getOutputStream()) != null) {
                    int length;
                    byte[] content = new byte[1024];
                    while ((length = pageStream.read(content)) > 0) {
                        responseStream.write(content, 0, length);
                    }
                    return;
                }
            }
            catch (IOException e) {
                throw new HttpAuthenticationException(e);
            }
        }
        this.sendRedirect(response, this.contextPath + page);
    }

    private void sendRedirect(HttpServerResponse response, String location) {
        response.addResponseHeader("Location", location);
        response.setStatusCode(303);
    }
}

