/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.RoleDecoder;
import org.wildfly.security.authz.RoleMapper;

class RealmInfo {
    private final SecurityRealm securityRealm;
    private final String name;
    private final RoleMapper roleMapper;
    private final NameRewriter nameRewriter;
    private final RoleDecoder roleDecoder;

    RealmInfo(SecurityDomain.RealmBuilder realmBuilder) {
        this.name = realmBuilder.getName();
        this.securityRealm = realmBuilder.getRealm();
        this.roleMapper = realmBuilder.getRoleMapper();
        this.nameRewriter = realmBuilder.getNameRewriter();
        this.roleDecoder = realmBuilder.getRoleDecoder();
    }

    RealmInfo() {
        this.securityRealm = SecurityRealm.EMPTY_REALM;
        this.name = "default";
        this.roleMapper = RoleMapper.IDENTITY_ROLE_MAPPER;
        this.nameRewriter = NameRewriter.IDENTITY_REWRITER;
        this.roleDecoder = RoleDecoder.DEFAULT;
    }

    String getName() {
        return this.name;
    }

    SecurityRealm getSecurityRealm() {
        return this.securityRealm;
    }

    RoleMapper getRoleMapper() {
        return this.roleMapper;
    }

    NameRewriter getNameRewriter() {
        return this.nameRewriter;
    }

    RoleDecoder getRoleDecoder() {
        return this.roleDecoder;
    }
}

