/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.security.auth.callback.ChannelBindingCallback;
import org.wildfly.security.auth.callback.SSLCallback;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslClientFactory;
import org.wildfly.security.sasl.util.TLSServerEndPointChannelBinding;

public final class TLSServerEndPointChannelBindingSaslClientFactory
extends AbstractDelegatingSaslClientFactory {
    public TLSServerEndPointChannelBindingSaslClientFactory(SaslClientFactory delegate) {
        super(delegate);
    }

    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, final CallbackHandler cbh) throws SaslException {
        return super.createSaslClient(mechanisms, authorizationId, protocol, serverName, props, new CallbackHandler(){
            private byte[] bindingData;

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                ArrayList<Callback> list = new ArrayList<Callback>(Arrays.asList(callbacks));
                Iterator<Callback> iterator = list.iterator();
                while (iterator.hasNext()) {
                    Callback callback = iterator.next();
                    if (callback instanceof SSLCallback) {
                        X509Certificate peerCertificate;
                        String sigAlgOID;
                        String digestAlgorithm;
                        SSLCallback sslCallback = (SSLCallback)callback;
                        Certificate[] peerCertificates = sslCallback.getSslSession().getPeerCertificates();
                        if (peerCertificates == null || peerCertificates.length <= 0 || (digestAlgorithm = TLSServerEndPointChannelBinding.getDigestAlgorithm(sigAlgOID = (peerCertificate = (X509Certificate)peerCertificates[0]).getSigAlgOID())) == null) continue;
                        try {
                            MessageDigest messageDigest = MessageDigest.getInstance(digestAlgorithm);
                            byte[] encoded = peerCertificate.getEncoded();
                            this.bindingData = messageDigest.digest(encoded);
                        }
                        catch (NoSuchAlgorithmException | CertificateEncodingException generalSecurityException) {}
                        continue;
                    }
                    if (!(callback instanceof ChannelBindingCallback) || this.bindingData == null) continue;
                    ChannelBindingCallback bindingCallback = (ChannelBindingCallback)callback;
                    bindingCallback.setBindingType("tls-server-end-point");
                    bindingCallback.setBindingData(this.bindingData);
                    iterator.remove();
                }
                if (!list.isEmpty()) {
                    cbh.handle(list.toArray(new Callback[list.size()]));
                }
            }
        });
    }
}

