/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.anonymous;

import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.sasl.SaslException;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.sasl.util.AbstractSaslClient;
import org.wildfly.security.sasl.util.StringPrep;
import org.wildfly.security.util.ByteStringBuilder;

public final class AnonymousSaslClient
extends AbstractSaslClient {
    private static final int INITIAL_STATE = 1;

    protected AnonymousSaslClient(String protocol, String serverName, CallbackHandler callbackHandler, String authorizationId) {
        super("ANONYMOUS", protocol, serverName, callbackHandler, authorizationId, true);
        this.setNegotiationState(1);
    }

    @Override
    protected byte[] evaluateMessage(int state, byte[] message) throws SaslException {
        switch (state) {
            case 1: {
                if (message != null && message.length > 0) {
                    throw ElytronMessages.log.mechInvalidServerMessage(this.getMechanismName()).toSaslException();
                }
                NameCallback nameCallback = new NameCallback("Authentication name", "anonymous");
                this.handleCallbacks(nameCallback);
                String name = nameCallback.getName();
                if (name == null) {
                    throw ElytronMessages.log.mechNotProvidedUserName(this.getMechanismName()).toSaslException();
                }
                if (name.length() > 255) {
                    throw ElytronMessages.log.mechAuthenticationNameTooLong(this.getMechanismName()).toSaslException();
                }
                if (name.isEmpty()) {
                    throw ElytronMessages.log.mechAuthenticationNameIsEmpty(this.getMechanismName()).toSaslException();
                }
                ByteStringBuilder b = new ByteStringBuilder();
                StringPrep.encode(name, b, 7159L);
                this.negotiationComplete();
                return b.toArray();
            }
        }
        throw Assert.impossibleSwitchCase((int)state);
    }
}

